/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.propertyTable.editor;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.mihalis.opal.propertyTable.PTProperty;
import org.mihalis.opal.propertyTable.PTWidget;
import org.mihalis.opal.propertyTable.editor.PTChooserEditor;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class PTColorEditor
extends PTChooserEditor {
    @Override
    protected void openWindow(PTWidget pTWidget, Item item, PTProperty pTProperty) {
        ColorDialog colorDialog = new ColorDialog(pTWidget.getWidget().getShell());
        RGB rGB = colorDialog.open();
        if (rGB != null) {
            pTProperty.setValue(rGB);
            Color color = this.getBackgroundColor(pTProperty);
            if (color != null) {
                if (item instanceof TableItem) {
                    ((TableItem)item).setBackground(1, color);
                }
                if (item instanceof TreeItem) {
                    ((TreeItem)item).setBackground(1, color);
                }
                SWTGraphicUtil.addDisposer((Widget)item, (Resource)color);
            }
            if (item instanceof TableItem) {
                ((TableItem)item).setText(1, this.getTextFor(pTProperty));
            } else {
                ((TreeItem)item).setText(1, this.getTextFor(pTProperty));
            }
        }
    }

    @Override
    protected String getTextFor(PTProperty pTProperty) {
        if (pTProperty.getValue() == null) {
            return "";
        }
        RGB rGB = (RGB)pTProperty.getValue();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("R:").append(rGB.red).append(" G:").append(rGB.green).append(" B:").append(rGB.blue);
        stringBuilder.append(" - #");
        stringBuilder.append(("0" + Integer.toHexString(rGB.red)).substring(0, 2));
        stringBuilder.append(("0" + Integer.toHexString(rGB.green)).substring(0, 2));
        stringBuilder.append(("0" + Integer.toHexString(rGB.blue)).substring(0, 2));
        return stringBuilder.toString();
    }

    @Override
    protected Color getBackgroundColor(PTProperty pTProperty) {
        if (pTProperty.getValue() == null) {
            return null;
        }
        RGB rGB = (RGB)pTProperty.getValue();
        return new Color((Device)Display.getDefault(), rGB);
    }
}

