/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.utils;

import java.util.ArrayList;
import java.util.List;

public class FixedSizeQueue<T> {
    private T[] buffer;
    private int index;

    public FixedSizeQueue(int n) {
        this.buffer = new Object[n];
        this.index = 0;
    }

    public void put(T t) {
        if (this.index == this.buffer.length) {
            System.arraycopy(this.buffer, 1, this.buffer, 0, this.buffer.length - 1);
            this.buffer[this.index - 1] = t;
        } else {
            this.buffer[this.index++] = t;
        }
    }

    public List<T> getValues() {
        ArrayList<T> arrayList = new ArrayList<T>(this.index);
        for (int i = 0; i < this.index; ++i) {
            if (this.buffer[i] == null) continue;
            arrayList.add(this.buffer[i]);
        }
        return arrayList;
    }

    public int getSize() {
        return this.index;
    }

    public void resizeTo(int n) {
        if (n < 0) {
            n = 1;
        }
        if (n == this.buffer.length) {
            return;
        }
        Object[] objectArray = new Object[n];
        if (n > this.buffer.length) {
            System.arraycopy(this.buffer, 0, objectArray, 0, this.buffer.length);
        } else {
            int n2 = Math.max(0, this.index - n);
            System.arraycopy(this.buffer, n2, objectArray, 0, n);
            this.index = n;
        }
        this.buffer = objectArray;
    }

    public static void main(String[] stringArray) {
        FixedSizeQueue<Integer> fixedSizeQueue = new FixedSizeQueue<Integer>(5);
        System.out.println("Filling...");
        for (int i = 0; i < 10; ++i) {
            fixedSizeQueue.put(i);
            System.out.println("i=" + i + ", size=" + fixedSizeQueue.getSize() + ", values=" + fixedSizeQueue.getValues());
        }
        System.out.println("Resize to 10...");
        fixedSizeQueue.resizeTo(10);
        System.out.println("size=" + fixedSizeQueue.getSize() + ", values=" + fixedSizeQueue.getValues());
        fixedSizeQueue.put(10);
        System.out.println("size=" + fixedSizeQueue.getSize() + ", values=" + fixedSizeQueue.getValues());
        System.out.println("Resize to 3...");
        fixedSizeQueue.resizeTo(3);
        System.out.println("size=" + fixedSizeQueue.getSize() + ", values=" + fixedSizeQueue.getValues());
        fixedSizeQueue.put(11);
        System.out.println("size=" + fixedSizeQueue.getSize() + ", values=" + fixedSizeQueue.getValues());
        System.out.println("Resize to 5...");
        fixedSizeQueue.resizeTo(5);
        fixedSizeQueue.put(12);
        fixedSizeQueue.put(13);
        fixedSizeQueue.put(14);
        System.out.println("size=" + fixedSizeQueue.getSize() + ", values=" + fixedSizeQueue.getValues());
        System.out.println("Resize to 3...");
        fixedSizeQueue.resizeTo(3);
        System.out.println("size=" + fixedSizeQueue.getSize() + ", values=" + fixedSizeQueue.getValues());
    }
}

