/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;

public class WriteConcern {
    public static final WriteConcern NONE = new WriteConcern(-1);
    public static final WriteConcern NORMAL = new WriteConcern(0);
    public static final WriteConcern SAFE;
    @Deprecated
    public static final WriteConcern STRICT;
    public static final WriteConcern FSYNC_SAFE;
    public static final WriteConcern REPLICAS_SAFE;
    final int _w;
    final int _wtimeout;
    final boolean _fsync;
    final BasicDBObject _command;

    public WriteConcern() {
        this(0);
    }

    public WriteConcern(int w) {
        this(w, 0, false);
    }

    public WriteConcern(int w, int wtimeout) {
        this(w, wtimeout, false);
    }

    public WriteConcern(boolean fsync) {
        this(1, 0, fsync);
    }

    public WriteConcern(int w, int wtimeout, boolean fsync) {
        this._w = w;
        this._wtimeout = wtimeout;
        this._fsync = fsync;
        this._command = new BasicDBObject("getlasterror", (Object)1);
        if (this._w > 0) {
            this._command.put("w", (Object)this._w);
            this._command.put("wtimeout", (Object)wtimeout);
        }
        if (this._fsync) {
            this._command.put("fsync", (Object)true);
        }
    }

    public BasicDBObject getCommand() {
        return this._command;
    }

    public int getW() {
        return this._w;
    }

    public int getWtimeout() {
        return this._wtimeout;
    }

    public boolean fsync() {
        return this._fsync;
    }

    public boolean raiseNetworkErrors() {
        return this._w >= 0;
    }

    public boolean callGetLastError() {
        return this._w > 0;
    }

    public String toString() {
        return "WriteConcern " + this._command;
    }

    static {
        STRICT = SAFE = new WriteConcern(1);
        FSYNC_SAFE = new WriteConcern(true);
        REPLICAS_SAFE = new WriteConcern(2);
    }
}

