/*
 * Decompiled with CFR 0.152.
 */
package su.artix.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.widgets.BitsManipulator;

public class BitCheckGroup
extends Composite {
    private static final Logger log = LoggerFactory.getLogger(BitCheckGroup.class);
    private Map<TableItem, Integer> checkBoxesMap;
    private Table table;

    public BitCheckGroup(Composite parent, int style) {
        this(parent, style, new HashMap<Integer, String>());
    }

    public BitCheckGroup(Composite parent, int style, Map<Integer, String> checkBoxesNames) {
        super(parent, style);
        GridLayoutFactory.swtDefaults().applyTo((Composite)this);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this);
        this.checkBoxesMap = new HashMap<TableItem, Integer>();
        this.table = new Table((Composite)this, 32);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.table);
        this.init(checkBoxesNames);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.table.setBackground(this.getBackground());
    }

    public void addListener(int eventType, Listener listener) {
        super.addListener(eventType, listener);
        if (this.table != null) {
            this.table.addListener(eventType, listener);
        }
    }

    private void init(Map<Integer, String> names) {
        for (Map.Entry<Integer, String> entry : names.entrySet()) {
            String name = entry.getValue();
            TableItem item = new TableItem(this.table, 0);
            item.setData((Object)entry.getKey());
            item.setText(name);
            this.checkBoxesMap.put(item, entry.getKey());
        }
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem current = (TableItem)e.item;
                int index = (Integer)BitCheckGroup.this.checkBoxesMap.get(current);
                Integer value = BitCheckGroup.this.getValue();
                value = current.getChecked() ? Integer.valueOf(BitsManipulator.setBit(value, index)) : Integer.valueOf(BitsManipulator.clearBit(value, index));
                BitCheckGroup.this.setValue(value);
                log.trace("val={}", (Object)BitCheckGroup.this.getValue());
            }
        });
    }

    public Integer getValue() {
        log.trace("getValue={}", this.getData());
        return (Integer)this.getData();
    }

    public void setValue(Integer value) {
        log.trace("setValue={}", (Object)value);
        this.setData(value);
        this.notifyListeners(24, null);
    }

    public void initCheckBoxes(Integer value) {
        for (Map.Entry<TableItem, Integer> entry : this.checkBoxesMap.entrySet()) {
            entry.getKey().setChecked(BitsManipulator.testBit(value, entry.getValue()));
        }
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }
}

