/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.figures;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.internal.xygraph.undo.OperationsManager;
import org.eclipse.nebula.visualization.internal.xygraph.undo.XYGraphMemento;
import org.eclipse.nebula.visualization.internal.xygraph.undo.ZoomCommand;
import org.eclipse.nebula.visualization.xygraph.figures.Annotation;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.DefaultAxesFactory;
import org.eclipse.nebula.visualization.xygraph.figures.Grid;
import org.eclipse.nebula.visualization.xygraph.figures.IAxesFactory;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Legend;
import org.eclipse.nebula.visualization.xygraph.figures.PlotArea;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.ZoomType;
import org.eclipse.nebula.visualization.xygraph.linearscale.AbstractScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.nebula.visualization.xygraph.util.Log10;
import org.eclipse.nebula.visualization.xygraph.util.SingleSourceHelper2;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class XYGraph
extends Figure
implements IXYGraph {
    @Deprecated
    public static final String PROPERTY_CONFIG = "config";
    @Deprecated
    public static final String PROPERTY_XY_GRAPH_MEM = "xyGraphMem";
    @Deprecated
    public static final String PROPERTY_ZOOMTYPE = "zoomType";
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private XYGraphMemento xyGraphMem;
    private static final int GAP = 2;
    public static final RGB[] DEFAULT_TRACES_COLOR = new RGB[]{new RGB(21, 21, 196), new RGB(242, 26, 26), new RGB(33, 179, 33), new RGB(0, 0, 0), new RGB(128, 0, 255), new RGB(255, 170, 0), new RGB(255, 0, 240), new RGB(243, 132, 132), new RGB(0, 255, 11), new RGB(0, 214, 255), new RGB(114, 40, 3), new RGB(219, 128, 4)};
    private int traceNum = 0;
    protected boolean transparent = false;
    private boolean showLegend = true;
    protected Map<Axis, Legend> legendMap;
    private String title = "";
    private Color titleColor;
    protected Label titleLabel;
    private FontData titleFontData;
    private RGB titleColorRgb;
    protected List<Axis> xAxisList;
    protected List<Axis> yAxisList;
    protected PlotArea plotArea;
    @Deprecated
    public final Axis primaryXAxis;
    @Deprecated
    public final Axis primaryYAxis;
    protected OperationsManager operationsManager;
    private ZoomType zoomType = ZoomType.NONE;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(property, listener);
    }

    @Override
    public void fireConfigChanged() {
        this.changeSupport.firePropertyChange(PROPERTY_CONFIG, null, this);
    }

    @Override
    public XYGraphMemento getXyGraphMem() {
        return this.xyGraphMem;
    }

    @Override
    public void setXyGraphMem(XYGraphMemento xyGraphMem) {
        XYGraphMemento old = this.xyGraphMem;
        this.xyGraphMem = xyGraphMem;
        this.changeSupport.firePropertyChange(PROPERTY_XY_GRAPH_MEM, old, this.xyGraphMem);
    }

    public XYGraph() {
        this(new DefaultAxesFactory());
    }

    public XYGraph(IAxesFactory axesFactory) {
        this.setOpaque(!this.transparent);
        this.legendMap = new LinkedHashMap<Axis, Legend>();
        this.titleLabel = new Label();
        String sysFontName = Display.getCurrent().getSystemFont().getFontData()[0].getName();
        this.setTitleFont(XYGraphMediaFactory.getInstance().getFont(new FontData(sysFontName, 12, 1)));
        this.setFont(Display.getCurrent().getSystemFont());
        this.xAxisList = new ArrayList<Axis>();
        this.yAxisList = new ArrayList<Axis>();
        this.plotArea = new PlotArea((IXYGraph)this);
        this.getPlotArea().setOpaque(!this.transparent);
        this.add((IFigure)this.titleLabel);
        this.add((IFigure)this.plotArea);
        this.primaryYAxis = axesFactory.createYAxis();
        this.addAxis(this.primaryYAxis);
        this.primaryXAxis = axesFactory.createXAxis();
        this.addAxis(this.primaryXAxis);
        this.operationsManager = new OperationsManager();
    }

    public boolean isOpaque() {
        return false;
    }

    protected void layout() {
        Axis xAxis;
        Rectangle clientArea = this.getClientArea().getCopy();
        boolean hasRightYAxis = false;
        boolean hasTopXAxis = false;
        boolean hasLeftYAxis = false;
        boolean hasBottomXAxis = false;
        if (this.titleLabel != null && this.titleLabel.isVisible() && this.titleLabel.getText().length() > 0) {
            Dimension titleSize = this.titleLabel.getPreferredSize();
            this.titleLabel.setBounds(new Rectangle(clientArea.x + clientArea.width / 2 - titleSize.width / 2, clientArea.y, titleSize.width, titleSize.height));
            clientArea.y += titleSize.height + 2;
            clientArea.height -= titleSize.height + 2;
        }
        if (this.showLegend) {
            ArrayList<Integer> rowHPosList = new ArrayList<Integer>();
            ArrayList<Dimension> legendSizeList = new ArrayList<Dimension>();
            ArrayList<Integer> rowLegendNumList = new ArrayList<Integer>();
            ArrayList<Legend> legendList = new ArrayList<Legend>();
            Object[] yAxes = this.legendMap.keySet().toArray();
            int hPos = 0;
            int rowLegendNum = 0;
            int i = 0;
            while (i < yAxes.length) {
                Legend legend = this.legendMap.get(yAxes[i]);
                if (legend != null && legend.isVisible()) {
                    legendList.add(legend);
                    Dimension legendSize = legend.getPreferredSize(clientArea.width, clientArea.height);
                    legendSizeList.add(legendSize);
                    if (hPos + legendSize.width + 2 > clientArea.width) {
                        if (rowLegendNum == 0) break;
                        rowHPosList.add(clientArea.x + (clientArea.width - hPos) / 2);
                        rowLegendNumList.add(rowLegendNum);
                        rowLegendNum = 1;
                        hPos = legendSize.width + 2;
                        clientArea.height -= legendSize.height + 2;
                        if (i == yAxes.length - 1) {
                            hPos = legendSize.width + 2;
                            rowLegendNum = 1;
                            rowHPosList.add(clientArea.x + (clientArea.width - hPos) / 2);
                            rowLegendNumList.add(rowLegendNum);
                            clientArea.height -= legendSize.height + 2;
                        }
                    } else {
                        hPos += legendSize.width + 2;
                        ++rowLegendNum;
                        if (i == yAxes.length - 1) {
                            rowHPosList.add(clientArea.x + (clientArea.width - hPos) / 2);
                            rowLegendNumList.add(rowLegendNum);
                            clientArea.height -= legendSize.height + 2;
                        }
                    }
                }
                ++i;
            }
            int lm = 0;
            int vPos = clientArea.y + clientArea.height + 2;
            int i2 = 0;
            while (i2 < rowLegendNumList.size()) {
                hPos = (Integer)rowHPosList.get(i2);
                int j = 0;
                while (j < (Integer)rowLegendNumList.get(i2)) {
                    ((Legend)((Object)legendList.get(lm))).setBounds(new Rectangle(hPos, vPos, ((Dimension)legendSizeList.get((int)lm)).width, ((Dimension)legendSizeList.get((int)lm)).height));
                    hPos += ((Dimension)legendSizeList.get((int)lm)).width + 2;
                    ++lm;
                    ++j;
                }
                vPos += ((Dimension)legendSizeList.get((int)(lm - 1))).height + 2;
                ++i2;
            }
        }
        int i = this.xAxisList.size() - 1;
        while (i >= 0) {
            xAxis = this.xAxisList.get(i);
            Dimension xAxisSize = xAxis.getPreferredSize(clientArea.width, clientArea.height);
            if (xAxis.getTickLabelSide() == AbstractScale.LabelSide.Primary) {
                if (xAxis.isVisible()) {
                    hasBottomXAxis = true;
                }
                xAxis.setBounds(new Rectangle(clientArea.x, clientArea.y + clientArea.height - xAxisSize.height, xAxisSize.width, xAxisSize.height));
                clientArea.height -= xAxisSize.height;
            } else {
                if (xAxis.isVisible()) {
                    hasTopXAxis = true;
                }
                xAxis.setBounds(new Rectangle(clientArea.x, clientArea.y + 1, xAxisSize.width, xAxisSize.height));
                clientArea.y += xAxisSize.height;
                clientArea.height -= xAxisSize.height;
            }
            --i;
        }
        i = this.yAxisList.size() - 1;
        while (i >= 0) {
            Axis yAxis;
            int hintHeight = clientArea.height + (hasTopXAxis ? 1 : 0) * (yAxis = this.yAxisList.get(i)).getMargin() + (hasBottomXAxis ? 1 : 0) * yAxis.getMargin();
            if (hintHeight > this.getClientArea().height) {
                hintHeight = clientArea.height;
            }
            Dimension yAxisSize = yAxis.getPreferredSize(clientArea.width, hintHeight);
            if (yAxis.getTickLabelSide() == AbstractScale.LabelSide.Primary) {
                if (yAxis.isVisible()) {
                    hasLeftYAxis = true;
                }
                yAxis.setBounds(new Rectangle(clientArea.x, clientArea.y - (hasTopXAxis ? yAxis.getMargin() : 0), yAxisSize.width, yAxisSize.height));
                clientArea.x += yAxisSize.width;
                clientArea.width -= yAxisSize.width;
            } else {
                if (yAxis.isVisible()) {
                    hasRightYAxis = true;
                }
                yAxis.setBounds(new Rectangle(clientArea.x + clientArea.width - yAxisSize.width - 1, clientArea.y - (hasTopXAxis ? yAxis.getMargin() : 0), yAxisSize.width, yAxisSize.height));
                clientArea.width -= yAxisSize.width;
            }
            --i;
        }
        i = this.xAxisList.size() - 1;
        while (i >= 0) {
            xAxis = this.xAxisList.get(i);
            Rectangle r = xAxis.getBounds().getCopy();
            if (hasLeftYAxis) {
                r.x = clientArea.x - xAxis.getMargin() - 1;
            }
            r.width = clientArea.width + (hasLeftYAxis ? xAxis.getMargin() : -1) + (hasRightYAxis ? xAxis.getMargin() : 0);
            xAxis.setBounds(r);
            --i;
        }
        if (this.plotArea != null && this.plotArea.isVisible()) {
            Rectangle plotAreaBound = new Rectangle(this.primaryXAxis.getBounds().x + this.primaryXAxis.getMargin() + 1, this.primaryYAxis.getBounds().y + this.primaryYAxis.getMargin(), this.primaryXAxis.getBounds().width - 2 * this.primaryXAxis.getMargin(), this.primaryYAxis.getBounds().height - 2 * this.primaryYAxis.getMargin());
            this.plotArea.setBounds(plotAreaBound);
        }
        super.layout();
    }

    @Override
    public void setZoomType(ZoomType zoomType) {
        if (this.zoomType == zoomType) {
            return;
        }
        this.plotArea.setZoomType(zoomType);
        for (Axis axis : this.xAxisList) {
            axis.setZoomType(zoomType);
        }
        for (Axis axis : this.yAxisList) {
            axis.setZoomType(zoomType);
        }
        this.zoomType = zoomType;
        this.changeSupport.firePropertyChange(PROPERTY_ZOOMTYPE, (Object)this.zoomType, (Object)this.zoomType);
    }

    @Override
    public ZoomType getZoomType() {
        return this.zoomType;
    }

    @Override
    public void setTitle(String title) {
        this.title = title.trim();
        this.titleLabel.setText(title);
    }

    @Override
    public void setShowTitle(boolean showTitle) {
        this.titleLabel.setVisible(showTitle);
        this.revalidate();
    }

    @Override
    public boolean isShowTitle() {
        return this.titleLabel.isVisible();
    }

    @Override
    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
        for (Axis yAxis : this.legendMap.keySet()) {
            Legend legend = this.legendMap.get((Object)yAxis);
            legend.setVisible(showLegend);
        }
        this.revalidate();
    }

    @Override
    public boolean isShowLegend() {
        return this.showLegend;
    }

    @Override
    public void addAxis(Axis axis) {
        if (axis.isHorizontal()) {
            this.xAxisList.add(axis);
        } else {
            this.yAxisList.add(axis);
        }
        this.plotArea.addGrid(new Grid(axis));
        this.add((IFigure)axis);
        axis.setXyGraph((IXYGraph)this);
        this.revalidate();
    }

    @Override
    public boolean removeAxis(Axis axis) {
        this.remove((IFigure)axis);
        this.plotArea.removeGrid(axis.getGrid());
        this.revalidate();
        if (axis.isHorizontal()) {
            return this.xAxisList.remove((Object)axis);
        }
        return this.yAxisList.remove((Object)axis);
    }

    @Override
    public void addTrace(Trace trace) {
        if (trace.getTraceColor() == null) {
            trace.setTraceColor(XYGraphMediaFactory.getInstance().getColor(DEFAULT_TRACES_COLOR[this.traceNum % DEFAULT_TRACES_COLOR.length]));
            ++this.traceNum;
        }
        if (this.legendMap.containsKey((Object)trace.getYAxis())) {
            this.legendMap.get((Object)trace.getYAxis()).addTrace(trace);
        } else {
            this.legendMap.put(trace.getYAxis(), new Legend((IXYGraph)this));
            this.legendMap.get((Object)trace.getYAxis()).addTrace(trace);
            this.add((IFigure)this.legendMap.get((Object)trace.getYAxis()));
        }
        this.plotArea.addTrace(trace);
        trace.setXYGraph((IXYGraph)this);
        trace.dataChanged(null);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void removeTrace(Trace trace) {
        if (this.legendMap.containsKey((Object)trace.getYAxis())) {
            this.legendMap.get((Object)trace.getYAxis()).removeTrace(trace);
            if (this.legendMap.get((Object)trace.getYAxis()).getTraceList().size() <= 0) {
                this.remove((IFigure)this.legendMap.remove((Object)trace.getYAxis()));
            }
        }
        this.plotArea.removeTrace(trace);
        trace.getXAxis().removeTrace(trace);
        trace.getYAxis().removeTrace(trace);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void addAnnotation(Annotation annotation) {
        this.plotArea.addAnnotation(annotation);
    }

    @Override
    public void removeAnnotation(Annotation annotation) {
        this.plotArea.removeAnnotation(annotation);
    }

    @Override
    public void setTitleFont(Font titleFont) {
        this.titleLabel.setFont(titleFont);
        this.titleFontData = titleFont.getFontData()[0];
    }

    @Override
    public Font getTitleFont() {
        return this.titleLabel.getFont();
    }

    @Override
    public FontData getTitleFontData() {
        return this.titleFontData;
    }

    @Override
    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
        this.titleLabel.setForegroundColor(titleColor);
        this.titleColorRgb = titleColor.getRGB();
    }

    @Override
    public void paintFigure(Graphics graphics) {
        if (!this.transparent) {
            graphics.fillRectangle(this.getClientArea());
        }
        super.paintFigure(graphics);
    }

    @Override
    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
        this.getPlotArea().setOpaque(!transparent);
        this.repaint();
    }

    @Override
    public boolean isTransparent() {
        return this.transparent;
    }

    @Override
    public PlotArea getPlotArea() {
        return this.plotArea;
    }

    @Override
    public Image getImage() {
        return SingleSourceHelper2.getXYGraphSnapShot(this);
    }

    @Override
    public Color getTitleColor() {
        if (this.titleColor == null) {
            return this.getForegroundColor();
        }
        return this.titleColor;
    }

    @Override
    public RGB getTitleColorRgb() {
        return this.titleColorRgb;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public OperationsManager getOperationsManager() {
        return this.operationsManager;
    }

    @Override
    public List<Axis> getXAxisList() {
        return this.xAxisList;
    }

    @Override
    public List<Axis> getYAxisList() {
        return this.yAxisList;
    }

    @Override
    public List<Axis> getAxisList() {
        ArrayList<Axis> list = new ArrayList<Axis>();
        list.addAll(this.xAxisList);
        list.addAll(this.yAxisList);
        return list;
    }

    @Override
    public Map<Axis, Legend> getLegendMap() {
        return this.legendMap;
    }

    @Override
    public void performAutoScale() {
        ZoomCommand command = new ZoomCommand("Auto Scale", this.xAxisList, this.yAxisList);
        for (Axis axis : this.xAxisList) {
            axis.performAutoScale(true);
        }
        for (Axis axis : this.yAxisList) {
            axis.performAutoScale(true);
        }
        command.saveState();
        this.operationsManager.addCommand(command);
    }

    @Override
    public void performStagger() {
        ZoomCommand command = new ZoomCommand("Stagger Axes", null, this.yAxisList);
        int N = this.yAxisList.size();
        int i = 0;
        while (i < N) {
            Range axis_range;
            Axis yaxis = this.yAxisList.get(i);
            if (!yaxis.isAutoScale() && (axis_range = yaxis.getTraceDataRange()) != null) {
                double high;
                double low = axis_range.getLower();
                if (low == (high = axis_range.getUpper())) {
                    double half = Math.abs(low / 2.0);
                    low -= half;
                    high += half;
                }
                if (yaxis.isLogScaleEnabled()) {
                    low = Log10.log10(low);
                    high = Log10.log10(high);
                }
                double span = high - low;
                low -= 0.1 * span;
                high += 0.1 * span;
                span = high - low;
                low -= (double)(N - i - 1) * span;
                high += (double)i * span;
                if (yaxis.isLogScaleEnabled()) {
                    low = Log10.pow10(low);
                    high = Log10.pow10(high);
                }
                if (low < high && !Double.isInfinite(low) && !Double.isInfinite(high)) {
                    yaxis.setRange(low, high);
                }
            }
            ++i;
        }
        command.saveState();
        this.operationsManager.addCommand(command);
    }

    @Override
    public Axis getPrimaryXAxis() {
        if (this.xAxisList.size() > 0) {
            return this.xAxisList.get(0);
        }
        return null;
    }

    @Override
    public Axis getPrimaryYAxis() {
        if (this.yAxisList.size() > 0) {
            return this.yAxisList.get(0);
        }
        return null;
    }
}

