/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.rest.client.legacy.entities;

import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import su.artix.cashserver.rest.client.RestInvokerManager;
import su.artix.cashserver.rest.legacy.domain.ShopInfo;

public class ShopsLegacyRestClient {
    private static final String SHOP_URL = "shops";
    private final RestInvokerManager restInvokerManager;

    public ShopsLegacyRestClient(RestInvokerManager restInvokerManager) {
        this.restInvokerManager = restInvokerManager;
    }

    public List<ShopInfo> getShopInfosList() {
        ParameterizedTypeReference<List<ShopInfo>> returnTypeRef = new ParameterizedTypeReference<List<ShopInfo>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(SHOP_URL, returnTypeRef);
    }

    public List<ShopInfo> getShopsByGroupCode(String groupId) {
        ParameterizedTypeReference<List<ShopInfo>> returnTypeRef = new ParameterizedTypeReference<List<ShopInfo>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet("shops?groupId=" + groupId, returnTypeRef);
    }

    public List<ShopInfo> getShopsByTagId(String tagId) {
        ParameterizedTypeReference<List<ShopInfo>> returnTypeRef = new ParameterizedTypeReference<List<ShopInfo>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet("shops?tagId=" + tagId, returnTypeRef);
    }

    public ShopInfo getShop(String shopId) {
        return this.restInvokerManager.getRestInvoker().invokeGet("shops/" + shopId, ShopInfo.class);
    }

    public void addShop(ShopInfo newShopInfo) {
        this.restInvokerManager.getRestInvoker().invokePost(SHOP_URL, newShopInfo);
    }

    public void editShop(ShopInfo correctShopInfo) {
        this.restInvokerManager.getRestInvoker().invokePut(SHOP_URL, correctShopInfo);
    }

    public void delShop(String shopId) {
        this.restInvokerManager.getRestInvoker().invokeDelete("shops/" + shopId);
    }
}

