/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain.dict.notes;

import org.apache.commons.lang.BooleanUtils;
import ru.ssa.cashadmin.domain.dict.notes.DialogParams;
import ru.ssa.cashadmin.domain.dict.notes.JsonDialogParams;

public class DialogParamsInputText
extends DialogParams {
    private String title;
    private String message;
    private String okBtnText;
    private String cancelBtnText;
    private String inputMask;
    private boolean checkInputMaskOnEnter;
    private String defaultValue;
    private String inputPattern;
    private boolean onlyNumber;
    private Integer allowDevices = 1;
    private boolean allowScanCard;
    private boolean disableEnter = true;
    private boolean moneyItem;
    private boolean forCustomer = true;
    private boolean returnCancelButtonText;
    private boolean enableHotkeys = true;
    private boolean password;
    private boolean hideCancel;

    public DialogParamsInputText() {
        super("dialogInputText");
    }

    public DialogParamsInputText(JsonDialogParams paramsJson) {
        this();
        this.title = paramsJson.getTitle();
        this.message = paramsJson.getMessage();
        this.okBtnText = paramsJson.getOkBtnText();
        this.cancelBtnText = paramsJson.getCancelBtnText();
        this.inputMask = paramsJson.getInputMask();
        this.checkInputMaskOnEnter = paramsJson.isCheckInputMaskOnEnter();
        this.defaultValue = paramsJson.getDefaultValue();
        this.inputPattern = paramsJson.getInputPattern();
        this.onlyNumber = paramsJson.isOnlyNumber();
        this.allowScanCard = paramsJson.isAllowScanCard();
        this.disableEnter = paramsJson.isDisableEnter();
        this.moneyItem = paramsJson.isMoneyItem();
        this.returnCancelButtonText = paramsJson.isReturnCancelButtonText();
        this.enableHotkeys = paramsJson.isEnableHotkeys();
        this.password = paramsJson.isPassword();
        this.hideCancel = paramsJson.isHideCancel();
        this.forCustomer = BooleanUtils.isNotFalse((Boolean)paramsJson.getForCustomer());
        this.allowDevices = paramsJson.getAllowDevices();
    }

    @Override
    public JsonDialogParams toJsonDialogParams() {
        JsonDialogParams paramsJson = new JsonDialogParams(this.getDialogType());
        paramsJson.setTitle(this.getTitle());
        paramsJson.setMessage(this.getMessage());
        paramsJson.setOkBtnText(this.getOkBtnText());
        paramsJson.setCancelBtnText(this.getCancelBtnText());
        paramsJson.setInputMask(this.getInputMask());
        paramsJson.setCheckInputMaskOnEnter(this.isCheckInputMaskOnEnter());
        paramsJson.setDefaultValue(this.getDefaultValue());
        paramsJson.setInputPattern(this.getInputPattern());
        paramsJson.setOnlyNumber(this.isOnlyNumber());
        paramsJson.setAllowScanCard(this.isAllowScanCard());
        paramsJson.setDisableEnter(this.isDisableEnter());
        paramsJson.setMoneyItem(this.isMoneyItem());
        paramsJson.setReturnCancelButtonText(this.isReturnCancelButtonText());
        paramsJson.setEnableHotkeys(this.isEnableHotkeys());
        paramsJson.setPassword(this.isPassword());
        paramsJson.setHideCancel(this.isHideCancel());
        paramsJson.setForCustomer(this.isForCustomer());
        paramsJson.setAllowDevices(this.getAllowDevices());
        return paramsJson;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getOkBtnText() {
        return this.okBtnText;
    }

    public void setOkBtnText(String okBtnText) {
        this.okBtnText = okBtnText;
    }

    public String getCancelBtnText() {
        return this.cancelBtnText;
    }

    public void setCancelBtnText(String cancelBtnText) {
        this.cancelBtnText = cancelBtnText;
    }

    public String getInputMask() {
        return this.inputMask;
    }

    public void setInputMask(String inputMask) {
        this.inputMask = inputMask;
    }

    public boolean isCheckInputMaskOnEnter() {
        return this.checkInputMaskOnEnter;
    }

    public void setCheckInputMaskOnEnter(boolean checkInputMaskOnEnter) {
        this.checkInputMaskOnEnter = checkInputMaskOnEnter;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getInputPattern() {
        return this.inputPattern;
    }

    public void setInputPattern(String inputPattern) {
        this.inputPattern = inputPattern;
    }

    public boolean isOnlyNumber() {
        return this.onlyNumber;
    }

    public void setOnlyNumber(boolean onlyNumber) {
        this.onlyNumber = onlyNumber;
    }

    public Integer getAllowDevices() {
        return this.allowDevices;
    }

    public void setAllowDevices(Integer allowDevices) {
        this.allowDevices = allowDevices;
    }

    public boolean isAllowScanCard() {
        return this.allowScanCard;
    }

    public void setAllowScanCard(boolean allowScanCard) {
        this.allowScanCard = allowScanCard;
    }

    public boolean isDisableEnter() {
        return this.disableEnter;
    }

    public void setDisableEnter(boolean disableEnter) {
        this.disableEnter = disableEnter;
    }

    public boolean isMoneyItem() {
        return this.moneyItem;
    }

    public void setMoneyItem(boolean moneyItem) {
        this.moneyItem = moneyItem;
    }

    public boolean isForCustomer() {
        return this.forCustomer;
    }

    public void setForCustomer(boolean forCustomer) {
        this.forCustomer = forCustomer;
    }

    public boolean isReturnCancelButtonText() {
        return this.returnCancelButtonText;
    }

    public void setReturnCancelButtonText(boolean returnCancelButtonText) {
        this.returnCancelButtonText = returnCancelButtonText;
    }

    public boolean isEnableHotkeys() {
        return this.enableHotkeys;
    }

    public void setEnableHotkeys(boolean enableHotkeys) {
        this.enableHotkeys = enableHotkeys;
    }

    public boolean isPassword() {
        return this.password;
    }

    public void setPassword(boolean password) {
        this.password = password;
    }

    public boolean isHideCancel() {
        return this.hideCancel;
    }

    public void setHideCancel(boolean hideCancel) {
        this.hideCancel = hideCancel;
    }
}

