/*
 * Decompiled with CFR 0.152.
 */
package com.richclientgui.toolbox.celleditors;

import com.richclientgui.toolbox.celleditors.ComboBoxCellEditorContentProvider;
import com.richclientgui.toolbox.celleditors.ComboBoxCellEditorLabelProvider;
import com.richclientgui.toolbox.celleditors.DefaultComboCellEditorLabelProvider;
import com.richclientgui.toolbox.util.ToolboxUtil;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ObjectComboBoxCellEditor<T>
extends ComboBoxCellEditor {
    private static final String[] EMPTY_STR_ARRAY = new String[0];
    private T[] items;
    private Map<Object, Integer> itemToIndexMap = new HashMap<Object, Integer>();
    private final ComboBoxCellEditorLabelProvider<T> labelProvider;
    private final ComboBoxCellEditorContentProvider<T> contentProvider;
    private static final Integer NOT_FOUND = new Integer(-1);

    public ObjectComboBoxCellEditor(Composite parent, int style, ComboBoxCellEditorContentProvider<T> contentProvider, ComboBoxCellEditorLabelProvider<T> labelProvider) {
        this(parent, style, contentProvider, labelProvider, false);
    }

    public ObjectComboBoxCellEditor(Composite parent, int style, ComboBoxCellEditorContentProvider<T> contentProvider, ComboBoxCellEditorLabelProvider<T> labelProvider, boolean populateOnDropDown) {
        super(parent, EMPTY_STR_ARRAY, style);
        if (contentProvider == null) {
            throw new IllegalArgumentException("Content provider cannot be null.");
        }
        if (labelProvider == null) {
            labelProvider = new DefaultComboCellEditorLabelProvider();
        }
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        if (populateOnDropDown) {
            this.getControl().addListener(15, new Listener(){

                public void handleEvent(Event event) {
                    Object sel = ObjectComboBoxCellEditor.this.doGetValue();
                    ObjectComboBoxCellEditor.this.populate();
                    ObjectComboBoxCellEditor.this.doSetValue(sel);
                }
            });
        }
        this.populate();
    }

    private void populate() {
        this.itemToIndexMap.clear();
        T[] values = this.contentProvider.getValues();
        this.items = ToolboxUtil.copyOf(values, values.length);
        String[] strItems = new String[this.items.length];
        int i = 0;
        while (i < this.items.length) {
            T currObj = this.items[i];
            this.itemToIndexMap.put(this.getLookupValue(currObj), i);
            strItems[i] = this.labelProvider.getLabel(currObj);
            ++i;
        }
        this.setItems(strItems);
    }

    public T doGetValue() {
        Integer index = (Integer)super.doGetValue();
        if (this.items == null || index == null || index == -1 || this.items.length <= index) {
            return null;
        }
        return this.items[index];
    }

    protected void doSetValue(Object value) {
        if (this.items == null) {
            return;
        }
        Integer index = this.itemToIndexMap.get(value);
        super.doSetValue((Object)(index == null ? NOT_FOUND : index));
    }

    public void refresh() {
        this.populate();
    }

    public Object getLookupValue(T object) {
        return object;
    }

    public T retrieveObject(Object lookupValue) {
        Integer index = this.itemToIndexMap.get(lookupValue);
        if (index == null || index < 0 || index >= this.items.length) {
            return null;
        }
        return this.items[index];
    }

    protected ComboBoxCellEditorLabelProvider<T> getLabelProvider() {
        assert (this.labelProvider != null);
        return this.labelProvider;
    }

    public static class Builder<T> {
        private Composite parent = null;
        private int style = 0;
        private ComboBoxCellEditorLabelProvider<T> labelProvider;
        private final ComboBoxCellEditorContentProvider<T> contentProvider;
        private boolean populateOnDropDown = false;

        public Builder(Composite parent, ComboBoxCellEditorContentProvider<T> contentProvider) {
            if (contentProvider == null) {
                throw new IllegalArgumentException("Content Provider may not be null.");
            }
            if (parent == null) {
                throw new IllegalArgumentException("parent cannot be null.");
            }
            this.parent = parent;
            this.contentProvider = contentProvider;
        }

        public Builder<T> labelProvider(ComboBoxCellEditorLabelProvider<T> labelProvider) {
            this.labelProvider = labelProvider;
            return this;
        }

        public Builder<T> style(int style) {
            this.style = style;
            return this;
        }

        public ObjectComboBoxCellEditor<T> build() {
            return new ObjectComboBoxCellEditor<T>(this.parent, this.style, this.contentProvider, this.labelProvider, this.populateOnDropDown);
        }
    }
}

