/*
 * Decompiled with CFR 0.152.
 */
package com.richclientgui.toolbox.duallists;

import com.richclientgui.toolbox.Messages;
import com.richclientgui.toolbox.duallists.IRemovableContentProvider;
import com.richclientgui.toolbox.propagate.PropagateComposite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class DualListComposite<T>
extends PropagateComposite {
    public static final int DEFAULT_WIDTH_HINT = 200;
    public static final int DEFAULT_HEIGHT_HINT = 100;
    private IRemovableContentProvider<T> availableContentProvider;
    private IBaseLabelProvider availableLabelProvider;
    private ViewerComparator availableComparator;
    private ViewerFilter availableViewerFilter;
    private Table availableTable;
    private IRemovableContentProvider<T> chosenContentProvider;
    private IBaseLabelProvider chosenLabelProvider;
    private ViewerComparator chosenComparator;
    private ViewerFilter chosenViewerFilter;
    private Table chosenTable;
    private Label lblAvailable;
    private Label lblBlank;
    private Label lblChosen;
    private TableViewer availableViewer;
    private TableViewer chosenViewer;
    private PropagateComposite centerComposite;
    private Button btnAdd;
    private Button btnAddAll;
    private Button btnRemove;
    private Button btnRemoveAll;
    private final List<ListContentChangedListener<T>> chosenListChangedListeners = new ArrayList<ListContentChangedListener<T>>();
    private final List<ListContentChangedListener<T>> availableListChangedListeners = new ArrayList<ListContentChangedListener<T>>();
    private final Image addButtonImage;
    private final Image addAllButtonImage;
    private final Image removeButtonImage;
    private final Image removeAllButtonImage;

    public DualListComposite(Composite parent, int style) {
        this(parent, style, null, null, null, null);
    }

    public DualListComposite(Composite parent, int style, Image addButtonImage, Image addAllButtonImage, Image removeButtonImage, Image removeAllButtonImage) {
        super(parent, style);
        this.addButtonImage = addButtonImage;
        this.addAllButtonImage = addAllButtonImage;
        this.removeButtonImage = removeButtonImage;
        this.removeAllButtonImage = removeAllButtonImage;
        this.createControl();
    }

    private void createControl() {
        this.setLayout((Layout)new GridLayout(3, false));
        this.availableTable = this.createAvailableTable(this);
        if (this.availableTable == null) {
            this.availableViewer = new TableViewer((Composite)this);
            this.availableTable = this.availableViewer.getTable();
            GridData viewerGridData = new GridData(4, 4, true, true);
            viewerGridData.heightHint = 100;
            viewerGridData.widthHint = 200;
            this.availableTable.setLayoutData((Object)viewerGridData);
        } else {
            this.availableViewer = new TableViewer(this.availableTable);
        }
        this.availableLabelProvider = new LabelProvider();
        this.availableViewer.setLabelProvider(this.availableLabelProvider);
        this.availableViewer.setUseHashlookup(true);
        this.centerComposite = new PropagateComposite(this, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginWidth = 2;
        buttonLayout.marginHeight = 2;
        this.centerComposite.setLayout((Layout)buttonLayout);
        this.centerComposite.setLayoutData(new GridData(0x1000000, 0x1000000, false, true));
        this.btnAdd = new Button((Composite)this.centerComposite, 8);
        if (this.addButtonImage == null) {
            this.btnAdd.setText(Messages.getString("button.duallist.add"));
        } else {
            this.btnAdd.setImage(this.addButtonImage);
            this.btnAdd.setToolTipText(Messages.getString("button.duallist.add"));
        }
        this.btnAdd.setLayoutData((Object)new GridData(4, 4, true, false));
        this.btnRemove = new Button((Composite)this.centerComposite, 8);
        if (this.removeButtonImage == null) {
            this.btnRemove.setText(Messages.getString("button.duallist.remove"));
        } else {
            this.btnRemove.setImage(this.removeButtonImage);
            this.btnRemove.setToolTipText(Messages.getString("button.duallist.remove"));
        }
        this.btnRemove.setLayoutData((Object)new GridData(4, 4, true, false));
        this.btnAddAll = new Button((Composite)this.centerComposite, 8);
        if (this.addAllButtonImage == null) {
            this.btnAddAll.setText(Messages.getString("button.duallist.addall"));
        } else {
            this.btnAddAll.setImage(this.addAllButtonImage);
            this.btnAddAll.setToolTipText(Messages.getString("button.duallist.addall"));
        }
        this.btnAddAll.setLayoutData((Object)new GridData(4, 4, true, false));
        this.btnRemoveAll = new Button((Composite)this.centerComposite, 8);
        if (this.removeAllButtonImage == null) {
            this.btnRemoveAll.setText(Messages.getString("button.duallist.removeall"));
        } else {
            this.btnRemoveAll.setImage(this.removeAllButtonImage);
            this.btnRemoveAll.setToolTipText(Messages.getString("button.duallist.removeall"));
        }
        this.btnRemoveAll.setLayoutData((Object)new GridData(4, 4, true, false));
        this.chosenTable = this.createChosenTable(this);
        if (this.chosenTable == null) {
            this.chosenViewer = new TableViewer((Composite)this);
            this.chosenTable = this.chosenViewer.getTable();
            GridData viewerGridData = new GridData(4, 4, true, true);
            viewerGridData.heightHint = 100;
            viewerGridData.widthHint = 200;
            this.chosenTable.setLayoutData((Object)viewerGridData);
        } else {
            this.chosenViewer = new TableViewer(this.chosenTable);
        }
        this.chosenViewer.setUseHashlookup(true);
        this.chosenLabelProvider = new LabelProvider();
        this.chosenViewer.setLabelProvider(this.chosenLabelProvider);
        if (this.hasBottonControl()) {
            this.createControlAtBottomOfAvailableTable(this);
            new Label((Composite)this, 0);
            this.createControlAtBottomOfChosenTable(this);
        }
        this.addListeners();
    }

    protected Table createAvailableTable(Composite parent) {
        return null;
    }

    protected Table createChosenTable(Composite parent) {
        return null;
    }

    private void addListeners() {
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)DualListComposite.this.availableViewer.getSelection();
                for (Object obj : selection) {
                    DualListComposite.this.availableContentProvider.removeElement(obj);
                    DualListComposite.this.chosenContentProvider.addElement(obj);
                }
                DualListComposite.this.refreshTableViewers();
                DualListComposite.this.fireChosenListContentChangedEvent(DualListComposite.this.chosenContentProvider);
                DualListComposite.this.fireAvailableListContentChangedEvent(DualListComposite.this.availableContentProvider);
            }
        });
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)DualListComposite.this.chosenViewer.getSelection();
                for (Object obj : selection) {
                    DualListComposite.this.availableContentProvider.addElement(obj);
                    DualListComposite.this.chosenContentProvider.removeElement(obj);
                }
                DualListComposite.this.refreshTableViewers();
                DualListComposite.this.fireChosenListContentChangedEvent(DualListComposite.this.chosenContentProvider);
                DualListComposite.this.fireAvailableListContentChangedEvent(DualListComposite.this.availableContentProvider);
            }
        });
        this.btnAddAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = DualListComposite.this.availableTable.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i] != null) {
                        Object obj = items[i].getData();
                        DualListComposite.this.availableContentProvider.removeElement(obj);
                        DualListComposite.this.chosenContentProvider.addElement(obj);
                    }
                    ++i;
                }
                DualListComposite.this.refreshTableViewers();
                DualListComposite.this.fireChosenListContentChangedEvent(DualListComposite.this.chosenContentProvider);
                DualListComposite.this.fireAvailableListContentChangedEvent(DualListComposite.this.availableContentProvider);
            }
        });
        this.btnRemoveAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = DualListComposite.this.chosenTable.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i] != null) {
                        Object obj = items[i].getData();
                        DualListComposite.this.chosenContentProvider.removeElement(obj);
                        DualListComposite.this.availableContentProvider.addElement(obj);
                    }
                    ++i;
                }
                DualListComposite.this.refreshTableViewers();
                DualListComposite.this.fireChosenListContentChangedEvent(DualListComposite.this.chosenContentProvider);
                DualListComposite.this.fireAvailableListContentChangedEvent(DualListComposite.this.availableContentProvider);
            }
        });
        this.availableTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DualListComposite.this.centerComposite.setEnabledOfChild((Control)DualListComposite.this.btnAdd, DualListComposite.this.availableTable.getSelectionCount() > 0);
            }
        });
        this.availableTable.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                DualListComposite.this.centerComposite.setEnabledOfChild((Control)DualListComposite.this.btnAdd, DualListComposite.this.availableTable.getSelectionCount() > 0);
                DualListComposite.this.centerComposite.setEnabledOfChild((Control)DualListComposite.this.btnAddAll, DualListComposite.this.availableTable.getItemCount() > 0);
            }
        });
        this.chosenTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DualListComposite.this.centerComposite.setEnabledOfChild((Control)DualListComposite.this.btnRemove, DualListComposite.this.chosenTable.getSelectionCount() > 0);
            }
        });
        this.chosenTable.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                DualListComposite.this.centerComposite.setEnabledOfChild((Control)DualListComposite.this.btnRemove, DualListComposite.this.chosenTable.getSelectionCount() > 0);
                DualListComposite.this.centerComposite.setEnabledOfChild((Control)DualListComposite.this.btnRemoveAll, DualListComposite.this.chosenTable.getItemCount() > 0);
            }
        });
    }

    public void refreshTableViewers() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                DualListComposite.this.availableViewer.refresh();
                DualListComposite.this.chosenViewer.refresh();
            }
        });
    }

    public void refreshChosenViewer() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                DualListComposite.this.chosenViewer.refresh();
            }
        });
    }

    public void refreshAvailableViewer() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                DualListComposite.this.availableViewer.refresh();
            }
        });
    }

    public void setViewerLabels(String availableLabel, String chosenLabel) {
        if ((availableLabel == null || availableLabel.trim().equals("")) && (chosenLabel == null || chosenLabel.trim().equals(""))) {
            return;
        }
        if (this.lblAvailable == null) {
            this.lblAvailable = new Label((Composite)this, 0);
            this.lblAvailable.setText(availableLabel);
            this.lblAvailable.moveAbove((Control)this.availableTable);
            this.lblBlank = new Label((Composite)this, 0);
            this.lblBlank.moveBelow((Control)this.lblAvailable);
            this.lblChosen = new Label((Composite)this, 0);
            this.lblChosen.setText(chosenLabel);
            this.lblChosen.moveBelow((Control)this.lblBlank);
        }
        this.lblAvailable.setText(availableLabel == null ? "" : availableLabel);
        this.lblChosen.setText(chosenLabel == null ? "" : chosenLabel);
    }

    public void setAvailableContentProvider(IRemovableContentProvider<T> provider) {
        if (DualListComposite.isEqual(provider, this.availableContentProvider)) {
            return;
        }
        this.availableContentProvider = provider;
        this.availableViewer.setContentProvider(provider);
        this.availableViewer.setInput((Object)this);
    }

    public void setChosenContentProvider(IRemovableContentProvider<T> provider) {
        if (DualListComposite.isEqual(provider, this.chosenContentProvider)) {
            return;
        }
        this.chosenContentProvider = provider;
        this.chosenViewer.setContentProvider(provider);
        this.chosenViewer.setInput((Object)this);
    }

    public void setAvailableViewerComparator(ViewerComparator comparator) {
        if (DualListComposite.isEqual(comparator, this.availableComparator)) {
            return;
        }
        this.availableComparator = comparator;
        this.availableViewer.setComparator(comparator);
    }

    public void setChosenComparator(ViewerComparator comparator) {
        if (DualListComposite.isEqual(comparator, this.chosenComparator)) {
            return;
        }
        this.chosenComparator = comparator;
        this.chosenViewer.setComparator(comparator);
    }

    public void setComparators(ViewerComparator comparator) {
        this.setAvailableViewerComparator(comparator);
        this.setChosenComparator(comparator);
    }

    public void setAvailableLabelProvider(IBaseLabelProvider labelProvider) {
        if (labelProvider == null) {
            throw new IllegalArgumentException("Available label provider cannot be null.");
        }
        if (labelProvider.equals(this.availableLabelProvider)) {
            return;
        }
        this.availableLabelProvider = labelProvider;
        this.availableViewer.setLabelProvider(labelProvider);
    }

    public void setChosenLabelProvider(IBaseLabelProvider labelProvider) {
        if (labelProvider == null) {
            throw new IllegalArgumentException("Chosen label provider cannot be null.");
        }
        if (labelProvider.equals(this.chosenLabelProvider)) {
            return;
        }
        this.chosenLabelProvider = labelProvider;
        this.chosenViewer.setLabelProvider(labelProvider);
    }

    public void setLabelProviders(IBaseLabelProvider labelProvider) {
        if (labelProvider == null) {
            throw new IllegalArgumentException("labelProvider cannot be null.");
        }
        this.setChosenLabelProvider(labelProvider);
        this.setAvailableLabelProvider(labelProvider);
    }

    public void setAvailableViewerFilter(ViewerFilter filter) {
        if (DualListComposite.isEqual(this.availableViewerFilter, filter)) {
            return;
        }
        ViewerFilter[] filters = this.availableViewer.getFilters();
        int i = 0;
        while (i < filters.length) {
            this.availableViewer.removeFilter(filters[i]);
            ++i;
        }
        this.availableViewer.addFilter(filter);
    }

    public void setChosenViewerFilter(ViewerFilter filter) {
        if (DualListComposite.isEqual(this.chosenViewerFilter, filter)) {
            return;
        }
        ViewerFilter[] filters = this.chosenViewer.getFilters();
        int i = 0;
        while (i < filters.length) {
            this.chosenViewer.removeFilter(filters[i]);
            ++i;
        }
        this.chosenViewer.addFilter(filter);
    }

    public Table getAvailableTable() {
        return this.availableTable;
    }

    public Table getChosenTable() {
        return this.chosenTable;
    }

    public void setAvailableTableLinesVisible(boolean show) {
        this.getAvailableTable().setLinesVisible(show);
    }

    public void setChosenTableLinesVisible(boolean show) {
        this.getChosenTable().setLinesVisible(show);
    }

    public void setAvailableTableHeaderVisible(boolean show) {
        this.getAvailableTable().setHeaderVisible(show);
    }

    public void setChosenTableHeaderVisible(boolean show) {
        this.getChosenTable().setHeaderVisible(show);
    }

    public void setTableLinesVisible(boolean show) {
        this.setAvailableTableLinesVisible(show);
        this.setChosenTableLinesVisible(show);
    }

    public void setTableHeadersVisible(boolean show) {
        this.setAvailableTableHeaderVisible(show);
        this.setChosenTableHeaderVisible(show);
    }

    public void addChosenListChangedSelectionListener(ListContentChangedListener<T> listener) {
        if (listener != null) {
            this.chosenListChangedListeners.add(listener);
        }
    }

    public void removeChosenListChangedSelectionListener(ListContentChangedListener<T> listener) {
        if (listener != null) {
            this.chosenListChangedListeners.remove(listener);
        }
    }

    public void addAvailableListChangedSelectionListener(ListContentChangedListener<T> listener) {
        if (listener != null) {
            this.availableListChangedListeners.add(listener);
        }
    }

    public void removeAvailableListChangedSelectionListener(ListContentChangedListener<T> listener) {
        if (listener != null) {
            this.availableListChangedListeners.remove(listener);
        }
    }

    private void fireChosenListContentChangedEvent(IRemovableContentProvider<T> contentProvider) {
        Iterator<ListContentChangedListener<T>> it = this.chosenListChangedListeners.iterator();
        while (it.hasNext()) {
            it.next().listContentChanged(contentProvider);
        }
    }

    private void fireAvailableListContentChangedEvent(IRemovableContentProvider<T> contentProvider) {
        Iterator<ListContentChangedListener<T>> it = this.availableListChangedListeners.iterator();
        while (it.hasNext()) {
            it.next().listContentChanged(contentProvider);
        }
    }

    public void createControlAtBottomOfAvailableTable(Composite parent) {
    }

    protected boolean hasBottonControl() {
        return true;
    }

    public void createControlAtBottomOfChosenTable(Composite parent) {
    }

    public static boolean isEqual(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static interface ListContentChangedListener<E> {
        public void listContentChanged(IRemovableContentProvider<E> var1);
    }
}

