/*
 * Decompiled with CFR 0.152.
 */
package com.richclientgui.toolbox.validation;

import com.richclientgui.toolbox.validation.IFieldErrorMessageHandler;
import com.richclientgui.toolbox.validation.IQuickFixProvider;
import com.richclientgui.toolbox.validation.NullErrorMessageHandler;
import com.richclientgui.toolbox.validation.converter.IContentsStringConverter;
import com.richclientgui.toolbox.validation.validator.IFieldValidator;
import com.richclientgui.toolbox.validation.validator.IInputMaskValidator;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;

public class ValidatingField<T> {
    private final ControlDecoration controlDecoration;
    private final Control control;
    private final IFieldValidator<T> fieldValidator;
    private final IControlContentAdapter contentAdapter;
    private final IContentsStringConverter<T> stringConverter;
    private FieldDecoration errorDecoration;
    private FieldDecoration warningDecoration;
    private IFieldErrorMessageHandler errorMessageHandler;
    private IQuickFixProvider<T> quickFixProvider;
    private Menu quickFixMenu;
    private final boolean isRequiredField;
    private boolean hasContentAssist = false;

    public ValidatingField(Control control, IFieldValidator<T> fieldValidator, IControlContentAdapter contentAdapter, IContentsStringConverter<T> stringConverter, boolean isRequired) {
        this(control, fieldValidator, null, contentAdapter, stringConverter, isRequired, new NullErrorMessageHandler());
    }

    public ValidatingField(Control control, IFieldValidator<T> fieldValidator, ControlDecoration controlDecoration, IControlContentAdapter contentAdapter, IContentsStringConverter<T> stringConverter, boolean isRequired) {
        this(control, fieldValidator, controlDecoration, contentAdapter, stringConverter, isRequired, new NullErrorMessageHandler());
    }

    public ValidatingField(Control control, IFieldValidator<T> fieldValidator, ControlDecoration controlDecoration, IControlContentAdapter contentAdapter, IContentsStringConverter<T> stringConverter, boolean isRequired, IFieldErrorMessageHandler errorMessageHandler) {
        if (control == null) {
            throw new IllegalArgumentException("control may not be null");
        }
        this.control = control;
        if (!(control instanceof Text || control instanceof Combo || control instanceof CCombo)) {
            throw new IllegalArgumentException("Control must be an instance of Text, Combo or CCombo");
        }
        if (fieldValidator == null) {
            throw new IllegalArgumentException("fieldValidator may not be null");
        }
        this.fieldValidator = fieldValidator;
        this.controlDecoration = controlDecoration;
        this.contentAdapter = contentAdapter;
        if (stringConverter == null) {
            throw new IllegalArgumentException("stringConverter may not be null");
        }
        this.stringConverter = stringConverter;
        this.isRequiredField = isRequired;
        if (errorMessageHandler == null) {
            throw new IllegalArgumentException("errorMessageHandler may not be null");
        }
        this.errorMessageHandler = errorMessageHandler;
        if (fieldValidator instanceof IInputMaskValidator) {
            ((IInputMaskValidator)fieldValidator).install(this);
        }
        this.addListeners();
        this.initQuickFixMenu();
    }

    public void setQuickFixProvider(IQuickFixProvider<T> quickFixProvider) {
        this.quickFixProvider = quickFixProvider;
        this.quickFixMenu = null;
    }

    public void setErrorMessageHandler(IFieldErrorMessageHandler messageHandler) {
        if (this.errorMessageHandler == null) {
            throw new IllegalArgumentException("messageHandler may not be NULL!");
        }
        this.errorMessageHandler = messageHandler;
    }

    protected void addListeners() {
        if (this.control instanceof Text) {
            ((Text)this.control).addModifyListener((ModifyListener)new ValidatingModifyListener());
        } else if (this.control instanceof Combo) {
            ((Combo)this.control).addModifyListener((ModifyListener)new ValidatingModifyListener());
        } else if (this.control instanceof CCombo) {
            ((CCombo)this.control).addModifyListener((ModifyListener)new ValidatingModifyListener());
        }
        if (!(this.control instanceof Text)) {
            this.control.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ValidatingField.this.validate();
                }
            });
        }
    }

    private void doQuickFix() {
        this.quickFixProvider.doQuickFix(this);
    }

    private Menu createQuickFixMenu() {
        Menu newMenu = new Menu(this.control);
        MenuItem item = new MenuItem(newMenu, 8);
        item.setText(this.quickFixProvider.getQuickFixMenuText());
        item.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ValidatingField.this.doQuickFix();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        return newMenu;
    }

    private void initQuickFixMenu() {
        if (this.controlDecoration == null) {
            return;
        }
        this.controlDecoration.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                if (ValidatingField.this.isValid() || ValidatingField.this.quickFixProvider == null || !ValidatingField.this.hasQuickFix()) {
                    return;
                }
                if (ValidatingField.this.quickFixMenu == null) {
                    ValidatingField.this.quickFixMenu = ValidatingField.this.createQuickFixMenu();
                }
                ValidatingField.this.quickFixMenu.setLocation(event.x, event.y);
                ValidatingField.this.quickFixMenu.setVisible(true);
            }
        });
    }

    public Control getControl() {
        return this.control;
    }

    public boolean isRequired() {
        return this.isRequiredField;
    }

    public boolean hasQuickFix() {
        return this.quickFixProvider != null && this.quickFixProvider.hasQuickFix(this.getContents());
    }

    public boolean hasContentAssist() {
        return this.hasContentAssist;
    }

    public void dispose() {
        if (this.fieldValidator instanceof IInputMaskValidator) {
            ((IInputMaskValidator)this.fieldValidator).uninstall();
        }
        this.quickFixMenu.dispose();
    }

    protected FieldDecoration getErrorDecoration() {
        if (this.errorDecoration == null) {
            FieldDecoration standardError = null;
            standardError = this.hasQuickFix() ? FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERRORQUICKFIX") : FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
            this.errorDecoration = this.fieldValidator.getErrorMessage() == null ? standardError : new FieldDecoration(standardError.getImage(), this.fieldValidator.getErrorMessage());
        }
        this.errorDecoration.setDescription(this.fieldValidator.getErrorMessage());
        return this.errorDecoration;
    }

    protected FieldDecoration getWarningDecoration() {
        if (this.warningDecoration == null) {
            FieldDecoration standardWarning = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
            this.warningDecoration = this.fieldValidator.getWarningMessage() == null ? standardWarning : new FieldDecoration(standardWarning.getImage(), this.fieldValidator.getWarningMessage());
        }
        this.warningDecoration.setDescription(this.fieldValidator.getWarningMessage());
        return this.warningDecoration;
    }

    protected String getStringContents() {
        if (this.contentAdapter != null) {
            return this.contentAdapter.getControlContents(this.control);
        }
        if (this.control instanceof Text) {
            return ((Text)this.control).getText();
        }
        return null;
    }

    protected void setStringContents(String contents) {
        if (this.contentAdapter != null) {
            this.contentAdapter.setControlContents(this.control, contents, contents.length());
        } else if (this.control instanceof Text) {
            ((Text)this.control).setText(contents);
        }
    }

    public T getContents() {
        return this.stringConverter.convertFromString(this.getStringContents());
    }

    public void setContents(T contents) {
        if (contents != null) {
            this.setStringContents(this.stringConverter.convertToString(contents));
            this.validate();
        }
    }

    public boolean isValid() {
        return this.fieldValidator.isValid(this.getContents());
    }

    public boolean isWarning() {
        return this.fieldValidator.warningExist(this.getContents());
    }

    public void validate() {
        this.hideDecoration();
        if (!this.isValid()) {
            this.errorMessageHandler.handleErrorMessage(this.fieldValidator.getErrorMessage(), this.getStringContents());
            this.showErrorDecoration();
        } else if (this.isWarning()) {
            this.errorMessageHandler.handleWarningMessage(this.fieldValidator.getWarningMessage(), this.getStringContents());
            this.showWarningDecoration();
        } else {
            this.errorMessageHandler.clearMessage();
            if (this.hasContentAssist()) {
                this.showContentAssistDecoration();
            } else if (this.isRequired()) {
                this.showRequiredFieldDecoration();
            }
        }
    }

    protected FieldDecoration getRequiredFieldDecoration() {
        return FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED");
    }

    protected FieldDecoration getCueDecoration() {
        return FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
    }

    private void showDecoration(FieldDecoration dec) {
        if (this.controlDecoration != null) {
            this.controlDecoration.setImage(dec.getImage());
            this.controlDecoration.setDescriptionText(dec.getDescription());
            this.controlDecoration.setShowOnlyOnFocus(false);
            this.controlDecoration.show();
        }
    }

    private void hideDecoration() {
        if (this.controlDecoration != null) {
            this.controlDecoration.hide();
        }
    }

    private void showErrorDecoration() {
        FieldDecoration dec = this.getErrorDecoration();
        this.showDecoration(dec);
    }

    private void showWarningDecoration() {
        FieldDecoration dec = this.getWarningDecoration();
        this.showDecoration(dec);
    }

    private void showRequiredFieldDecoration() {
        FieldDecoration dec = this.getRequiredFieldDecoration();
        this.showDecoration(dec);
    }

    private void showContentAssistDecoration() {
        FieldDecoration dec = this.getCueDecoration();
        this.showDecoration(dec);
    }

    private class ValidatingModifyListener
    implements ModifyListener {
        private ValidatingModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            ValidatingField.this.validate();
        }
    }
}

