/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.dao.InvalidDataAccessApiUsageException;

public class Update {
    private HashMap<String, Object> modifierOps = new LinkedHashMap<String, Object>();

    public static Update update(String key, Object value) {
        return new Update().set(key, value);
    }

    public static Update fromDBObject(DBObject object, String ... exclude) {
        Update update = new Update();
        List<String> excludeList = Arrays.asList(exclude);
        for (String key : object.keySet()) {
            if (excludeList.contains(key)) continue;
            update.set(key, object.get(key));
        }
        return update;
    }

    public Update set(String key, Object value) {
        this.addMultiFieldOperation("$set", key, value);
        return this;
    }

    public Update unset(String key) {
        this.addMultiFieldOperation("$unset", key, 1);
        return this;
    }

    public Update inc(String key, Number inc) {
        this.addMultiFieldOperation("$inc", key, inc);
        return this;
    }

    public Update push(String key, Object value) {
        this.addMultiFieldOperation("$push", key, value);
        return this;
    }

    public Update pushAll(String key, Object[] values) {
        Object[] convertedValues = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            convertedValues[i] = values[i];
        }
        BasicDBObject keyValue = new BasicDBObject();
        keyValue.put(key, (Object)convertedValues);
        this.modifierOps.put("$pushAll", keyValue);
        return this;
    }

    public Update addToSet(String key, Object value) {
        this.addMultiFieldOperation("$addToSet", key, value);
        return this;
    }

    public Update pop(String key, Position pos) {
        this.addMultiFieldOperation("$pop", key, pos == Position.FIRST ? -1 : 1);
        return this;
    }

    public Update pull(String key, Object value) {
        this.addMultiFieldOperation("$pull", key, value);
        return this;
    }

    public Update pullAll(String key, Object[] values) {
        Object[] convertedValues = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            convertedValues[i] = values[i];
        }
        BasicDBObject keyValue = new BasicDBObject();
        keyValue.put(key, (Object)convertedValues);
        this.modifierOps.put("$pullAll", keyValue);
        return this;
    }

    public Update rename(String oldName, String newName) {
        this.addMultiFieldOperation("$rename", oldName, newName);
        return this;
    }

    public DBObject getUpdateObject() {
        BasicDBObject dbo = new BasicDBObject();
        for (String k : this.modifierOps.keySet()) {
            dbo.put(k, this.modifierOps.get(k));
        }
        return dbo;
    }

    protected void addMultiFieldOperation(String operator, String key, Object value) {
        LinkedHashMap keyValueMap;
        Object existingValue = this.modifierOps.get(operator);
        if (existingValue == null) {
            keyValueMap = new LinkedHashMap();
            this.modifierOps.put(operator, keyValueMap);
        } else if (existingValue instanceof LinkedHashMap) {
            keyValueMap = (LinkedHashMap)existingValue;
        } else {
            throw new InvalidDataAccessApiUsageException("Modifier Operations should be a LinkedHashMap but was " + existingValue.getClass());
        }
        keyValueMap.put(key, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Position {
        LAST,
        FIRST;

    }
}

