/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain.payment;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.validator.constraints.Length;
import ru.ssa.cashadmin.domain.payment.Provider;
import ru.ssa.cashadmin.domain.payment.Region;

@Entity
@Table(name="defcode")
@MappedSuperclass
public class Defcode
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue
    private Integer defcodeid;
    @NotNull
    private Integer providerid;
    @ManyToOne
    @JoinColumn(name="providerid", insertable=false, updatable=false)
    @NotNull
    @NotFound(action=NotFoundAction.IGNORE)
    private Provider provider;
    @NotNull
    @Length(max=100, min=1)
    private String rangemin;
    @NotNull
    @Length(max=100, min=1)
    private String rangemax;
    @NotNull
    private Integer regionid;
    @ManyToOne
    @JoinColumn(name="regionid", insertable=false, updatable=false)
    @NotNull
    @NotFound(action=NotFoundAction.IGNORE)
    private Region region;

    protected Defcode() {
    }

    public Integer getDefcodeid() {
        return this.defcodeid;
    }

    public void setDefcodeid(Integer defcodeid) {
        this.defcodeid = defcodeid;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
        this.providerid = provider != null ? provider.getProviderid() : null;
    }

    public Integer getProviderid() {
        return this.providerid;
    }

    public void setProviderid(Integer providerid) {
        this.providerid = providerid;
    }

    public String getRangemin() {
        return this.rangemin;
    }

    public void setRangemin(String rangemin) {
        this.rangemin = rangemin;
    }

    public String getRangemax() {
        return this.rangemax;
    }

    public void setRangemax(String rangemax) {
        this.rangemax = rangemax;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
        this.regionid = region != null ? region.getRegionid() : null;
    }

    public Integer getRegionid() {
        return this.regionid;
    }

    public void setRegionid(Integer regionid) {
        this.regionid = regionid;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.defcodeid == null ? 0 : this.defcodeid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Defcode other = (Defcode)obj;
        return !(this.defcodeid == null ? other.defcodeid != null : !this.defcodeid.equals(other.defcodeid));
    }

    public String toString() {
        return "Defcode [defcodeid=" + this.defcodeid + ", providerid=" + this.providerid + ", regionid=" + this.regionid + "]";
    }
}

