/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.core.cashregistry.domain;

import java.io.Serializable;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;
import su.artix.cashserver.core.cashregistry.domain.SecurityObject;

@Document(collection="securityPermission")
@JsonIgnoreProperties(ignoreUnknown=true)
public class SecurityPermission
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    private Integer id;
    @DBRef
    private SecurityObject securityObject;
    private Integer permission;

    public SecurityPermission() {
    }

    @JsonCreator
    public SecurityPermission(@JsonProperty(value="securityObject") SecurityObject securityObject, @JsonProperty(value="permission") Integer permission) {
        this.securityObject = securityObject;
        this.permission = permission;
        this.setId(securityObject, permission);
    }

    public Integer getId() {
        return this.id;
    }

    public SecurityObject getSecurityObject() {
        return this.securityObject;
    }

    public void setSecurityObject(SecurityObject securityObject) {
        this.securityObject = securityObject;
        this.setId(securityObject, this.permission);
    }

    public Integer getPermission() {
        return this.permission;
    }

    public void setPermission(Integer permission) {
        this.permission = permission;
        this.setId(this.securityObject, permission);
    }

    public final void setId(SecurityObject securityObject, Integer permission) {
        int prime = 31;
        int result = 1;
        result = 31 * result + (securityObject == null ? 0 : securityObject.hashCode()) + (permission == null ? 0 : permission.hashCode());
        this.id = result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SecurityPermission other = (SecurityPermission)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SecurityPermission [id=");
        builder.append(this.id);
        builder.append(", permission=");
        builder.append(this.permission);
        builder.append(", securityObject=");
        builder.append(this.securityObject);
        builder.append("]");
        return builder.toString();
    }
}

