/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.model.directory;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.AccumulateSprices;
import ru.ssa.cashadmin.domain.Actionpanel;
import ru.ssa.cashadmin.domain.Aspectscheme;
import ru.ssa.cashadmin.domain.Barcodes;
import ru.ssa.cashadmin.domain.Campaign;
import ru.ssa.cashadmin.domain.Catalog;
import ru.ssa.cashadmin.domain.Cmaction;
import ru.ssa.cashadmin.domain.Command;
import ru.ssa.cashadmin.domain.Invent;
import ru.ssa.cashadmin.domain.InventGroup;
import ru.ssa.cashadmin.domain.Macro;
import ru.ssa.cashadmin.domain.Mol;
import ru.ssa.cashadmin.domain.Role;
import ru.ssa.cashadmin.domain.Sprices;
import ru.ssa.cashadmin.domain.TmcKit;
import ru.ssa.cashadmin.domain.docs.Workshift;
import ru.ssa.cashadmin.domain.payment.Agent;
import ru.ssa.cashadmin.domain.payment.Supplier;
import su.artix.cashserver.core.cashregistry.domain.Dept;
import su.artix.cashserver.core.cashregistry.domain.SecurityObject;
import su.artix.cashserver.core.cashregistry.domain.SecurityPermission;
import su.artix.cashserver.core.cashregistry.domain.SecurityRole;
import su.artix.cashserver.core.cashregistry.domain.ShopGroupLabel;
import su.artix.cashserver.core.cashregistry.domain.ShopLabel;
import su.artix.cashserver.core.cashregistry.domain.WebUser;
import su.artix.yuki.model.ModelExceptionNotifier;
import su.artix.yuki.model.directory.DirectoryAccumulateSpricesModel;
import su.artix.yuki.model.directory.DirectoryActionModel;
import su.artix.yuki.model.directory.DirectoryActionpanelModel;
import su.artix.yuki.model.directory.DirectoryAgentModel;
import su.artix.yuki.model.directory.DirectoryAspectschemeModel;
import su.artix.yuki.model.directory.DirectoryBarcodesModel;
import su.artix.yuki.model.directory.DirectoryCampaignModel;
import su.artix.yuki.model.directory.DirectoryCatalogModel;
import su.artix.yuki.model.directory.DirectoryCommandModel;
import su.artix.yuki.model.directory.DirectoryEditModel;
import su.artix.yuki.model.directory.DirectoryGroupsModel;
import su.artix.yuki.model.directory.DirectoryInventModel;
import su.artix.yuki.model.directory.DirectoryInvocationHandler;
import su.artix.yuki.model.directory.DirectoryMacroModel;
import su.artix.yuki.model.directory.DirectoryModel;
import su.artix.yuki.model.directory.DirectoryRoleModel;
import su.artix.yuki.model.directory.DirectorySpricesModel;
import su.artix.yuki.model.directory.DirectorySupplierModel;
import su.artix.yuki.model.directory.DirectoryTmcKitModel;
import su.artix.yuki.model.directory.DirectoryUserModel;
import su.artix.yuki.model.directory.DirectoryWorkshiftModel;
import su.artix.yuki.model.mongo.MongoModel;
import su.artix.yuki.model.mongo.MongoSecurityRoleModel;

public class DirectoryModelFactory {
    private static Map<Class<?>, DirectoryEditModel<?>> map = new HashMap();
    public static boolean testMode = false;
    private static ModelExceptionNotifier exceptionNotifier;
    private static final Logger log;

    static {
        log = LoggerFactory.getLogger(DirectoryModelFactory.class);
    }

    public static void setExceptionNotifier(ModelExceptionNotifier exceptionNotifier) {
        DirectoryModelFactory.exceptionNotifier = exceptionNotifier;
    }

    public static ModelExceptionNotifier getExceptionNotifier() {
        return exceptionNotifier;
    }

    public static <T> DirectoryEditModel<T> getModel(Class<T> cl) {
        Class actualClass = cl;
        if (!testMode) {
            actualClass = LibActivator.getDefault().getActualClassResolver().getActual(cl);
        }
        log.trace("get model for class:{} actual:{}", (Object)cl, (Object)actualClass);
        DirectoryEditModel<?> model = map.get(actualClass);
        if (model == null) {
            model = DirectoryModelFactory.createModel(actualClass);
            map.put(actualClass, model);
        }
        DirectoryModelFactory.updateClassModel(actualClass, model);
        return model;
    }

    private static void updateClassModel(Class actualClass, DirectoryEditModel model) {
        model.setClazz(actualClass);
    }

    public static void updateAllDirectoryModels() {
        ArrayList list = new ArrayList();
        for (Class<?> clazz : map.keySet()) {
            list.add(map.get(clazz));
        }
        int i = 0;
        while (i < list.size()) {
            ((DirectoryEditModel)list.get(i)).cascadeRefresh();
            ((DirectoryEditModel)list.get(i)).doRefresh();
            ++i;
        }
    }

    public void refresh() {
        this.disposeModels();
    }

    private void disposeModels() {
        map.clear();
    }

    private static DirectoryEditModel<?> createModel(Class<?> cl) {
        log.trace("create model for class:{}", cl);
        DirectoryEditModel<Macro> model = Macro.class.isAssignableFrom(cl) ? new DirectoryMacroModel() : (Cmaction.class.isAssignableFrom(cl) ? new DirectoryActionModel() : (Command.class.isAssignableFrom(cl) ? new DirectoryCommandModel() : (Mol.class.isAssignableFrom(cl) ? new DirectoryUserModel() : (Role.class.isAssignableFrom(cl) ? new DirectoryRoleModel() : (Agent.class.isAssignableFrom(cl) ? new DirectoryAgentModel() : (Supplier.class.isAssignableFrom(cl) ? new DirectorySupplierModel() : (TmcKit.class.isAssignableFrom(cl) ? new DirectoryTmcKitModel() : (InventGroup.class.isAssignableFrom(cl) ? new DirectoryGroupsModel() : (Campaign.class.isAssignableFrom(cl) ? new DirectoryCampaignModel() : (AccumulateSprices.class.isAssignableFrom(cl) ? new DirectoryAccumulateSpricesModel() : (Sprices.class.isAssignableFrom(cl) ? new DirectorySpricesModel() : (SecurityObject.class.isAssignableFrom(cl) || SecurityPermission.class.isAssignableFrom(cl) || WebUser.class.isAssignableFrom(cl) || ShopLabel.class.isAssignableFrom(cl) || ShopGroupLabel.class.isAssignableFrom(cl) || Dept.class.isAssignableFrom(cl) ? new MongoModel(cl) : (SecurityRole.class.isAssignableFrom(cl) ? new MongoSecurityRoleModel() : (Aspectscheme.class.isAssignableFrom(cl) ? new DirectoryAspectschemeModel() : (Invent.class.isAssignableFrom(cl) ? new DirectoryInventModel() : (Barcodes.class.isAssignableFrom(cl) ? new DirectoryBarcodesModel() : (Catalog.class.isAssignableFrom(cl) ? new DirectoryCatalogModel() : (Workshift.class.isAssignableFrom(cl) ? new DirectoryWorkshiftModel() : (Actionpanel.class.isAssignableFrom(cl) ? new DirectoryActionpanelModel() : new DirectoryModel(cl))))))))))))))))))));
        return (DirectoryEditModel)Proxy.newProxyInstance(model.getClass().getClassLoader(), new Class[]{DirectoryEditModel.class}, new DirectoryInvocationHandler(model));
    }
}

