/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.opalDialog;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.mihalis.opal.opalDialog.ChoiceItem;
import org.mihalis.opal.opalDialog.FooterArea;
import org.mihalis.opal.opalDialog.MessageArea;
import org.mihalis.opal.utils.ResourceManager;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class Dialog {
    private CenterOption centerPolicy = CenterOption.CENTER_ON_SCREEN;
    private String title;
    OpalDialogType buttonType;
    private final MessageArea messageArea;
    private final FooterArea footerArea;
    final Shell shell;
    private int minimumWidth = 300;
    private int minimumHeight = 150;

    public Dialog() {
        this(null);
    }

    public Dialog(boolean bl) {
        this(null, bl);
    }

    public Dialog(Shell shell) {
        this(shell, false);
    }

    public Dialog(Shell shell, boolean bl) {
        if (shell == null) {
            this.shell = new Shell(Display.getCurrent(), 0x10860 | (bl ? 16 : 0));
        } else {
            this.shell = new Shell(shell, 0x10860 | (bl ? 16 : 0));
            if (shell.getImage() != null) {
                this.shell.setImage(shell.getImage());
            }
        }
        this.messageArea = new MessageArea(this);
        this.footerArea = new FooterArea(this);
    }

    public int show() {
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.shell.setLayout((Layout)gridLayout);
        this.messageArea.render();
        this.footerArea.render();
        if (this.title != null) {
            this.shell.setText(this.title);
        }
        this.pack();
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.footerArea.getSelectedButton();
    }

    public void close() {
        this.shell.dispose();
    }

    void pack() {
        int n;
        int n2;
        Point point = this.shell.computeSize(-1, -1);
        if (point.x < this.minimumWidth) {
            point.x = this.minimumWidth;
        }
        if (point.y < this.minimumHeight) {
            point.y = this.minimumHeight;
        }
        if (this.centerPolicy == CenterOption.CENTER_ON_SCREEN || this.shell.getParent() == null) {
            Rectangle rectangle = SWTGraphicUtil.getBoundsOfMonitorOnWhichShellIsDisplayed(this.shell);
            n2 = rectangle.x + (rectangle.width - point.x) / 2;
            n = rectangle.y + (rectangle.height - point.y) / 2;
        } else {
            Shell shell = (Shell)this.shell.getParent();
            n2 = shell.getLocation().x + (shell.getSize().x - point.x) / 2;
            n = shell.getLocation().y + (shell.getSize().y - point.y) / 2;
        }
        this.shell.setBounds(n2, n, point.x, point.y);
    }

    public static String ask(String string, String string2, String string3) {
        return Dialog.ask(null, string, string2, string3);
    }

    public static String ask(Shell shell, String string, String string2, String string3) {
        Dialog dialog = new Dialog(shell);
        dialog.setTitle(ResourceManager.getLabel("Input"));
        dialog.getMessageArea().setTitle(string).setText(string2).setIcon(Display.getCurrent().getSystemImage(4)).addTextBox(string3);
        dialog.setButtonType(OpalDialogType.OK_CANCEL);
        if (dialog.show() == 0) {
            return dialog.getMessageArea().getTextBoxValue();
        }
        return null;
    }

    public static void error(String string, String string2) {
        Dialog.error(null, string, string2);
    }

    public static void error(Shell shell, String string, String string2) {
        Dialog dialog = new Dialog(shell);
        dialog.setTitle(ResourceManager.getLabel("ApplicationError"));
        dialog.getMessageArea().setTitle(string).setText(string2).setIcon(Display.getCurrent().getSystemImage(1));
        dialog.setButtonType(OpalDialogType.OK);
        dialog.show();
    }

    public static void inform(String string, String string2) {
        Dialog.inform(null, string, string2);
    }

    public static void inform(Shell shell, String string, String string2) {
        Dialog dialog = new Dialog(shell);
        dialog.setTitle(ResourceManager.getLabel("Information"));
        dialog.getMessageArea().setTitle(string).setText(string2).setIcon(Display.getCurrent().getSystemImage(2));
        dialog.setButtonType(OpalDialogType.CLOSE);
        dialog.show();
    }

    public static boolean isConfirmed(String string, String string2) {
        return Dialog.isConfirmed(null, string, string2, -1);
    }

    public static boolean isConfirmed(Shell shell, String string, String string2) {
        return Dialog.isConfirmed(shell, string, string2, -1);
    }

    public static boolean isConfirmed(String string, String string2, int n) {
        return Dialog.isConfirmed(null, string, string2, n);
    }

    public static boolean isConfirmed(Shell shell, String string, String string2, int n) {
        Dialog dialog = new Dialog(shell);
        dialog.setTitle(ResourceManager.getLabel("Warning"));
        dialog.getMessageArea().setTitle(string).setText(string2).setIcon(Display.getCurrent().getSystemImage(8));
        dialog.getFooterArea().setTimer(n).setTimerIndexButton(0);
        dialog.setButtonType(OpalDialogType.YES_NO);
        return dialog.show() == 0;
    }

    public static int radioChoice(String string, String string2, int n, String ... stringArray) {
        return Dialog.radioChoice(null, string, string2, n, stringArray);
    }

    public static int radioChoice(Shell shell, String string, String string2, int n, String ... stringArray) {
        Dialog dialog = new Dialog(shell);
        dialog.setTitle(ResourceManager.getLabel("Choice"));
        dialog.getMessageArea().setTitle(string).setText(string2).setIcon(Display.getCurrent().getSystemImage(4)).addRadioButtons(n, stringArray);
        dialog.setButtonType(OpalDialogType.SELECT_CANCEL);
        if (dialog.show() == 0) {
            return dialog.getMessageArea().getRadioChoice();
        }
        return -1;
    }

    public static void showException(Throwable throwable) {
        Dialog dialog = new Dialog();
        dialog.setTitle(ResourceManager.getLabel("Exception"));
        String string = throwable.getMessage();
        String string2 = throwable.getClass().getName();
        boolean bl = string == null || string.trim().length() == 0;
        dialog.getMessageArea().setTitle(bl ? string2 : string).setText(bl ? "" : string2).setIcon(Display.getCurrent().getSystemImage(1)).setException(throwable);
        dialog.getFooterArea().setExpanded(true);
        dialog.setButtonType(OpalDialogType.CLOSE);
        dialog.show();
    }

    public static int choice(String string, String string2, int n, ChoiceItem ... choiceItemArray) {
        return Dialog.choice(null, string, string2, n, choiceItemArray);
    }

    public static int choice(Shell shell, String string, String string2, int n, ChoiceItem ... choiceItemArray) {
        Dialog dialog = new Dialog(shell);
        dialog.setTitle(ResourceManager.getLabel("Choice"));
        dialog.getMessageArea().setTitle(string).setText(string2).setIcon(Display.getCurrent().getSystemImage(4)).addChoice(n, choiceItemArray);
        dialog.setButtonType(OpalDialogType.NONE);
        dialog.show();
        return dialog.getMessageArea().getChoice();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public OpalDialogType getButtonType() {
        return this.buttonType;
    }

    public void setButtonType(OpalDialogType opalDialogType) {
        this.buttonType = opalDialogType;
        switch (opalDialogType) {
            case CLOSE: {
                this.footerArea.setButtonLabels(ResourceManager.getLabel("Close")).setDefaultButtonIndex(0);
                break;
            }
            case NO_BUTTON: {
                break;
            }
            case OK: {
                this.footerArea.setButtonLabels(ResourceManager.getLabel("Ok")).setDefaultButtonIndex(0);
                break;
            }
            case OK_CANCEL: {
                this.footerArea.setButtonLabels(ResourceManager.getLabel("Ok"), ResourceManager.getLabel("Cancel")).setDefaultButtonIndex(-1);
                break;
            }
            case SELECT_CANCEL: {
                this.footerArea.setButtonLabels(ResourceManager.getLabel("Select"), ResourceManager.getLabel("Cancel")).setDefaultButtonIndex(-1);
                break;
            }
            case YES_NO: {
                this.footerArea.setButtonLabels(ResourceManager.getLabel("Yes"), ResourceManager.getLabel("No")).setDefaultButtonIndex(0);
                break;
            }
        }
    }

    public MessageArea getMessageArea() {
        return this.messageArea;
    }

    public FooterArea getFooterArea() {
        return this.footerArea;
    }

    public Shell getShell() {
        return this.shell;
    }

    public int getSelectedButton() {
        return this.getFooterArea().getSelectedButton();
    }

    public boolean getCheckboxValue() {
        return this.footerArea.getCheckBoxValue();
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public void setMinimumWidth(int n) {
        this.minimumWidth = n;
    }

    public int getMinimumHeight() {
        return this.minimumHeight;
    }

    public void setMinimumHeight(int n) {
        this.minimumHeight = n;
    }

    public CenterOption getCenterPolicy() {
        return this.centerPolicy;
    }

    public void setCenterPolicy(CenterOption centerOption) {
        this.centerPolicy = centerOption;
    }

    public static enum CenterOption {
        CENTER_ON_SCREEN,
        CENTER_ON_DIALOG;

    }

    public static enum OpalDialogType {
        CLOSE,
        YES_NO,
        OK,
        OK_CANCEL,
        SELECT_CANCEL,
        NO_BUTTON,
        OTHER,
        NONE;

    }
}

