/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.widgets.Text;

public class FormulaConstructor {
    private List<String> techFormula;
    private List<String> descFormula;
    private Text txt;

    public FormulaConstructor() {
        this(new LinkedList<String>(), new LinkedList<String>());
    }

    public FormulaConstructor(Text txt) {
        this();
        this.txt = txt;
    }

    public FormulaConstructor(List<String> techFormula, List<String> descFormula) {
        this.techFormula = techFormula;
        this.descFormula = descFormula;
    }

    public void add(String tech, String desc) {
        this.techFormula.add(tech);
        this.descFormula.add(desc);
    }

    public void add(String techAndDesc) {
        this.add(techAndDesc, techAndDesc);
    }

    public void addDummy() {
        this.add("");
    }

    public void set(int index, String tech, String desc) {
        this.techFormula.set(index, tech);
        this.descFormula.set(index, desc);
    }

    public void set(int index, String techAndDesc) {
        this.set(index, techAndDesc, techAndDesc);
    }

    public void setTxt(Text txt) {
        this.txt = txt;
    }

    public List<String> getTechFormula() {
        return this.techFormula;
    }

    public void remove(int index) {
        this.techFormula.remove(index);
        this.descFormula.remove(index);
    }

    public int getSize() {
        return this.techFormula.size();
    }

    public String getTechString() {
        StringBuilder formula = new StringBuilder();
        int i = 0;
        while (i < this.techFormula.size()) {
            if (this.techFormula.get(i) != null && !this.techFormula.get(i).isEmpty()) {
                formula.append(this.techFormula.get(i));
            }
            ++i;
        }
        return formula.toString();
    }

    public String getDescString() {
        StringBuilder formula = new StringBuilder();
        int i = 0;
        while (i < this.descFormula.size()) {
            if (this.descFormula.get(i) != null && !this.descFormula.get(i).isEmpty()) {
                formula.append(this.descFormula.get(i));
                formula.append(" ");
            }
            ++i;
        }
        return formula.toString();
    }

    public void update() {
        if (this.txt != null) {
            this.txt.setText(this.getTechString());
        }
    }

    public void clear() {
        this.techFormula.clear();
        this.descFormula.clear();
        if (this.txt != null && !this.txt.isDisposed()) {
            this.txt.setText("");
        }
    }
}

