/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.handlers.discountsystem;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.discountmanager.dialogs.discountsystem.DiscountRateDialog;
import su.artix.discountmanager.handlers.discountsystem.HandlerUtils;
import su.artix.discountmanager.holders.ViewHolder;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCardCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObjectCheck;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRate;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateCalculate;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateIndex;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRatePercent;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRatePrice;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateSum;
import su.artix.loyaltylib.domain.java.observable.Named;
import su.artix.yuki.editors.DialogMode;

public class AddDiscountRateHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(AddDiscountRateHandler.class);
    private static final String PARAMETER_ID = "su.artix.discountmanager.commands.addrate.parameter";
    private static final String PARAMETER_VALUE1 = "DiscountRatePercent";
    private static final String PARAMETER_VALUE2 = "DiscountRateCalculate";
    private static final String PARAMETER_VALUE3 = "DiscountRateIndex";
    private static final String PARAMETER_VALUE4 = "DiscountRateSum";
    private static final String PARAMETER_VALUE5 = "DiscountRatePrice";
    private Discount parent;

    private void runDialog(DiscountRateDialog dialog) {
        if (dialog.open() == 0) {
            this.parent.setDiscountRate(dialog.getDiscountRate());
            dialog.getDiscountRate().setParent((Named)this.parent);
            log.trace("Added " + dialog.getDiscountRate() + " to " + this.parent);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        DiscountRate rate = (DiscountRate)ViewHolder.INSTANCE.getSelectionElementFromActiveView();
        this.parent = (Discount)rate.getParent();
        String titleBase = "";
        Map<Object, Object> paramList = new HashMap();
        try {
            titleBase = event.getCommand().getName();
            paramList = HandlerUtils.fillParams(event, event.getCommand().getName());
        }
        catch (NotDefinedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        String parameter = event.getParameter(PARAMETER_ID);
        if (parameter.equals(PARAMETER_VALUE1)) {
            String title = String.valueOf(titleBase) + " \u043d\u0430 \u043f\u0440\u043e\u0446\u0435\u043d\u0442\u043d\u0443\u044e";
            paramList.put("title", title);
            DiscountRateDialog dialog = new DiscountRateDialog(this.parent, (DiscountRate)new DiscountRatePercent(), paramList, DialogMode.CREATE);
            this.runDialog(dialog);
        } else if (parameter.equals(PARAMETER_VALUE2)) {
            String title = String.valueOf(titleBase) + " \u043d\u0430 \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u0443\u044e";
            paramList.put("title", title);
            if (!(this.parent.getDiscountObject() instanceof DiscountObjectCheck)) {
                paramList.put("type", "position");
            }
            for (DiscountCondition condition : this.parent.getDiscountConditions()) {
                if (!(condition instanceof DiscountCardCondition)) continue;
                paramList.put("type", "card");
                break;
            }
            DiscountRateDialog dialog = new DiscountRateDialog(this.parent, (DiscountRate)new DiscountRateCalculate(), paramList, DialogMode.CREATE);
            this.runDialog(dialog);
        } else if (parameter.equals(PARAMETER_VALUE3)) {
            String title = String.valueOf(titleBase) + " \u043d\u0430 \u0438\u043d\u0434\u0435\u043a\u0441\u043d\u0443\u044e";
            paramList.put("title", title);
            DiscountRateDialog dialog = new DiscountRateDialog(this.parent, (DiscountRate)new DiscountRateIndex(), paramList, DialogMode.CREATE);
            this.runDialog(dialog);
        } else if (parameter.equals(PARAMETER_VALUE4)) {
            String title = String.valueOf(titleBase) + " \u043d\u0430 \u0441\u0443\u043c\u043c\u043e\u0432\u0443\u044e";
            paramList.put("title", title);
            DiscountRateDialog dialog = new DiscountRateDialog(this.parent, (DiscountRate)new DiscountRateSum(), paramList, DialogMode.CREATE);
            this.runDialog(dialog);
        } else if (parameter.equals(PARAMETER_VALUE5)) {
            String title = String.valueOf(titleBase) + " \u043d\u0430 \u0444\u0438\u043a\u0441. \u0446\u0435\u043d\u0443";
            paramList.put("title", title);
            DiscountRateDialog dialog = new DiscountRateDialog(this.parent, (DiscountRate)new DiscountRatePrice(), paramList, DialogMode.CREATE);
            this.runDialog(dialog);
        }
        return null;
    }
}

