/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.discount.condition.constructor.dao.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import su.artix.yuki.discount.condition.constructor.dao.ConstructorTreeProcessor;
import su.artix.yuki.discount.condition.constructor.dao.TreeException;
import su.artix.yuki.discount.condition.constructor.dao.impl.ConditionObjectTagDAO;
import su.artix.yuki.discount.condition.constructor.dao.impl.ConstructorTreeDAO;
import su.artix.yuki.discount.condition.domain.xml.ConditionCustomeType;
import su.artix.yuki.discount.condition.domain.xml.ConditionObjectTag;
import su.artix.yuki.discount.condition.domain.xml.ConstructorWidgetType;
import su.artix.yuki.discount.condition.domain.xml.FunctionDataElement;
import su.artix.yuki.discount.condition.domain.xml.NodeValueType;
import su.artix.yuki.discount.condition.domain.xml.TreeContainerNode;
import su.artix.yuki.discount.condition.domain.xml.TreeFunctionNode;
import su.artix.yuki.discount.condition.domain.xml.TreeNode;
import su.artix.yuki.discount.condition.domain.xml.TreePropertyNode;
import su.artix.yuki.discount.condition.domain.xml.TreeRootNode;
import su.artix.yuki.discount.condition.template.dao.ConditionCustomTypeDAO;

public class ConstructorTreeProcessorImpl
implements ConstructorTreeProcessor {
    private List<ConstructorTreeDAO> treeDao;
    private ConditionCustomTypeDAO customDao;
    private ConditionObjectTagDAO tagsDao;

    public ConstructorTreeProcessorImpl(List<ConstructorTreeDAO> args, ConditionCustomTypeDAO customDao, ConditionObjectTagDAO tagDao) {
        this.treeDao = args;
        this.customDao = customDao;
        this.tagsDao = tagDao;
    }

    @Override
    public TreeRootNode getTree() throws TreeException {
        if (this.treeDao == null) {
            throw new TreeException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0434\u0435\u0440\u0435\u0432\u0430: TreeDAO");
        }
        TreeRootNode root = null;
        for (ConstructorTreeDAO dao : this.treeDao) {
            if (root == null) {
                root = dao.getTree();
                continue;
            }
            TreeRootNode tmp = dao.getTree();
            root.getCategories().addAll(tmp.getCategories());
        }
        if (root == null) {
            throw new TreeException("\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0434\u0435\u0440\u0435\u0432\u0430: \u0438\u0437 DAO \u0431\u044b\u043b \u043f\u043e\u043b\u0443\u0447\u0435\u043d null");
        }
        if (this.customDao != null) {
            this.fillCustomVar(root);
        }
        return root;
    }

    private void fillCustomVar(TreeNode node) {
        block6: {
            block8: {
                NodeValueType type;
                block7: {
                    block5: {
                        if (!(node instanceof TreeContainerNode)) break block5;
                        for (TreeNode treeNode : ((TreeContainerNode)node).getNodes()) {
                            this.fillCustomVar(treeNode);
                        }
                        break block6;
                    }
                    if (!(node instanceof TreePropertyNode)) break block7;
                    TreePropertyNode treePropertyNode = (TreePropertyNode)node;
                    NodeValueType type2 = this.getType(treePropertyNode.getVar());
                    if (type2 == null) break block6;
                    treePropertyNode.setVar(type2);
                    break block6;
                }
                if (!(node instanceof TreeFunctionNode)) break block8;
                TreeFunctionNode treeFunctionNode = (TreeFunctionNode)node;
                if (treeFunctionNode.isReturn() && (type = this.getType(treeFunctionNode.getReturnValue().getVar())) != null) {
                    treeFunctionNode.getReturnValue().setVar(type);
                }
                if (treeFunctionNode.getParams() == null) break block6;
                for (FunctionDataElement elem : treeFunctionNode.getParams()) {
                    NodeValueType type3 = this.getType(elem.getVar());
                    if (type3 == null) continue;
                    elem.setVar(type3);
                }
                break block6;
            }
            if (node instanceof TreeRootNode) {
                for (TreeNode treeNode : ((TreeRootNode)node).getCategories()) {
                    this.fillCustomVar(treeNode);
                }
            }
        }
    }

    private NodeValueType getType(NodeValueType type) {
        if (type == null) {
            return null;
        }
        ConstructorWidgetType wType = ConstructorWidgetType.getControlTypeFromString(type.getXmlType());
        if (wType != ConstructorWidgetType.Unknown) {
            type.setType(wType);
        } else {
            ConditionCustomeType customType = this.customDao.getValueType(type.getXmlType());
            if (customType != null) {
                customType.getValue().setType(ConstructorWidgetType.getControlTypeFromString(customType.getValue().getXmlType()));
                customType.getValue().setXmlType(type.getXmlType());
                if (type.getDefaultValue() != null) {
                    customType.getValue().setDefaultValue(type.getDefaultValue());
                }
                return customType.getValue();
            }
            type.setType(ConstructorWidgetType.Unknown);
        }
        return null;
    }

    @Override
    public TreeRootNode getTree(List<String> configuration) throws TreeException {
        TreeRootNode root = this.getTree();
        this.applyRequirements(root, configuration);
        return root;
    }

    @Override
    public void applyRequirements(TreeNode node, List<String> configuration) {
        block8: {
            block7: {
                if (configuration == null) {
                    configuration = new ArrayList<String>();
                }
                if (this.isRequirements(node) && !this.isRequirementsSatisfied(node, configuration) && node.getParent() != null) {
                    TreeNode parent = node.getParent();
                    if (parent instanceof TreeContainerNode) {
                        TreeContainerNode containerNode = (TreeContainerNode)parent;
                        containerNode.getNodes().remove(node);
                        node.setParent(null);
                    } else if (parent instanceof TreeRootNode && node instanceof TreeContainerNode) {
                        ((TreeRootNode)parent).removeCategory((TreeContainerNode)node);
                        node.setParent(null);
                    }
                    return;
                }
                if (!(node instanceof TreeContainerNode)) break block7;
                TreeContainerNode containerNode = (TreeContainerNode)node;
                Object[] objectArray = containerNode.getNodes().toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    TreeNode child = (TreeNode)obj;
                    this.applyRequirements(child, configuration);
                    ++n2;
                }
                break block8;
            }
            if (!(node instanceof TreeRootNode)) break block8;
            TreeRootNode root = (TreeRootNode)node;
            Object[] objectArray = root.getCategories().toArray();
            int n = objectArray.length;
            int n3 = 0;
            while (n3 < n) {
                Object obj = objectArray[n3];
                TreeNode child = (TreeNode)obj;
                this.applyRequirements(child, configuration);
                ++n3;
            }
        }
    }

    @Override
    public List<ConditionObjectTag> getConditionObjectTagsList() {
        if (this.tagsDao != null) {
            return this.tagsDao.getTagsList();
        }
        return new ArrayList<ConditionObjectTag>();
    }

    @Override
    public Boolean filterByTag(TreeNode node, String tag) {
        if (tag == null) {
            return false;
        }
        if (node instanceof TreePropertyNode || node instanceof TreeFunctionNode) {
            return this.tagContains(node, tag);
        }
        if (node instanceof TreeContainerNode) {
            TreeContainerNode containerNode = (TreeContainerNode)node;
            if (this.tagContains(node, tag)) {
                return true;
            }
            Iterator<TreeNode> iter = containerNode.getNodes().iterator();
            boolean flag = false;
            while (iter.hasNext()) {
                if (!this.filterByTag(iter.next(), tag).booleanValue()) {
                    iter.remove();
                    continue;
                }
                flag = true;
            }
            return flag;
        }
        if (node instanceof TreeRootNode) {
            TreeRootNode root = (TreeRootNode)node;
            Iterator<TreeContainerNode> iter = root.getCategories().iterator();
            while (iter.hasNext()) {
                if (this.filterByTag(iter.next(), tag).booleanValue()) continue;
                iter.remove();
            }
            return true;
        }
        return false;
    }

    @Override
    public List<TreeNode> searchTreeNode(TreeRootNode root, String name) {
        ArrayList<TreeNode> founded = new ArrayList<TreeNode>();
        for (TreeContainerNode category : root.getCategories()) {
            this.searchTreeNode((TreeNode)category, name, founded);
        }
        return founded;
    }

    private void searchTreeNode(TreeNode node, String name, List<TreeNode> founded) {
        if (node instanceof TreeContainerNode) {
            for (TreeNode child : ((TreeContainerNode)node).getNodes()) {
                this.searchTreeNode(child, name, founded);
            }
        } else if (node.getName().equalsIgnoreCase(name)) {
            founded.add(node);
        }
    }

    @Override
    public List<TreeNode> searchTreeNode(TreeRootNode root, TreeNode node) {
        ArrayList<TreeNode> founded = new ArrayList<TreeNode>();
        for (TreeContainerNode category : root.getCategories()) {
            this.searchTreeNode((TreeNode)category, node, founded);
        }
        return founded;
    }

    private void searchTreeNode(TreeNode node, TreeNode searchedNode, List<TreeNode> founded) {
        if (node instanceof TreeContainerNode) {
            for (TreeNode child : ((TreeContainerNode)node).getNodes()) {
                this.searchTreeNode(child, searchedNode, founded);
            }
        } else if (this.isNodesEqualWithNullFields(node, searchedNode)) {
            founded.add(node);
        }
    }

    private boolean isNodesEqualWithNullFields(TreeNode node, TreeNode searchedNode) {
        if (node == null || searchedNode == null) {
            return false;
        }
        if (!node.getClass().equals(searchedNode.getClass())) {
            return false;
        }
        if (searchedNode.getName() != null && !searchedNode.getName().equalsIgnoreCase(node.getName())) {
            return false;
        }
        if (searchedNode.getDisplay() != null && !searchedNode.getDisplay().equalsIgnoreCase(node.getDisplay())) {
            return false;
        }
        if (searchedNode.getDesc() != null && !searchedNode.getDesc().equalsIgnoreCase(node.getDesc())) {
            return false;
        }
        if (searchedNode.getFullName() != null && !searchedNode.getFullName().equalsIgnoreCase(node.getFullName())) {
            return false;
        }
        return searchedNode.getRequirements() == null || searchedNode.getRequirements().equals(node.getRequirements());
    }

    @Override
    public String getFullNameOfNode(TreeNode node) {
        if (node != null && node.getFullName() != null) {
            return node.getFullName();
        }
        return this.buildFullName(node);
    }

    public boolean isRequirementsSatisfied(TreeNode node, List<String> list) {
        if (!this.isRequirements(node)) {
            return true;
        }
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (String require : node.getRequirements()) {
            if (list.contains(require)) continue;
            return false;
        }
        return true;
    }

    public boolean tagContains(TreeNode node, String tag) {
        if (tag == null || tag.isEmpty() || !this.isTags(node)) {
            return false;
        }
        return node.getTags().contains(tag);
    }

    public boolean isRequirements(TreeNode node) {
        if (node == null) {
            return false;
        }
        return node.getRequirements() != null && !node.getRequirements().isEmpty();
    }

    public boolean isTags(TreeNode node) {
        if (node == null) {
            return false;
        }
        return node.getTags() != null && !node.getTags().isEmpty();
    }

    public String buildFullName(TreeNode node) {
        StringBuilder name = new StringBuilder();
        if (node != null) {
            if (node instanceof TreeFunctionNode) {
                return node.getName();
            }
            TreeNode current = node;
            while (current.getParent().getParent() != null) {
                name.insert(0, "\"]");
                name.insert(0, current.getName());
                name.insert(0, "[\"");
                current = current.getParent();
            }
            name.insert(0, current.getName());
        }
        return name.toString();
    }
}

