/*
 * Decompiled with CFR 0.152.
 */
package su.artix.widgets;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import su.artix.widgets.TextWithClear;

public class TextWithClearLabel
extends TextWithClear {
    public TextWithClearLabel(Composite parent) {
        super(parent);
    }

    public TextWithClearLabel(Composite parent, String initText) {
        super(parent, initText);
    }

    @Override
    protected Control createClearText(Composite parent, Action clearTextAction) {
        final Action act = clearTextAction;
        final Image inactiveImage = JFaceResources.getImageRegistry().getDescriptor("org.eclipse.ui.internal.dialogs.DCLEAR_ICON").createImage();
        final Image activeImage = JFaceResources.getImageRegistry().getDescriptor("org.eclipse.ui.internal.dialogs.CLEAR_ICON").createImage();
        final Image pressedImage = new Image((Device)this.getDisplay(), activeImage, 2);
        final Label clearButton = new Label(parent, 0);
        clearButton.setDragDetect(false);
        GridData data = new GridData(1, 0x1000000, false, false);
        clearButton.setLayoutData((Object)data);
        clearButton.setImage(inactiveImage);
        clearButton.setBackground(parent.getDisplay().getSystemColor(25));
        clearButton.setToolTipText("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c");
        clearButton.addListener(6, new Listener(){

            public void handleEvent(Event e) {
                clearButton.setImage(activeImage);
            }
        });
        clearButton.addListener(7, new Listener(){

            public void handleEvent(Event e) {
                clearButton.setImage(inactiveImage);
            }
        });
        clearButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                clearButton.setImage(inactiveImage);
                if (this.isMouseInButton(e)) {
                    act.run();
                }
            }

            public void mouseDown(MouseEvent e) {
                clearButton.setImage(this.isMouseInButton(e) ? pressedImage : inactiveImage);
            }

            private boolean isMouseInButton(MouseEvent e) {
                Point buttonSize = clearButton.getSize();
                return e.x >= 0 && e.x < buttonSize.x && e.y >= 0 && e.y < buttonSize.y;
            }
        });
        clearButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                inactiveImage.dispose();
                activeImage.dispose();
                pressedImage.dispose();
            }
        });
        clearButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = 43;
            }
        });
        return clearButton;
    }
}

