/*
 * Decompiled with CFR 0.152.
 */
package su.artix.accounting.domain;

public enum CardStatus {
    ACTIVE(0),
    BLOCKED(1),
    WITHDRAWAL(2),
    ANONYMOUS_CARD(3),
    EARN_PAY(0),
    NO_OPERATION(1),
    EARN_ONLY(3),
    PAY_ONLY(4);

    private final int value;

    private CardStatus(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static CardStatus findByValue(int value) {
        switch (value) {
            case 0: {
                return EARN_PAY;
            }
            case 1: {
                return NO_OPERATION;
            }
            case 2: {
                return WITHDRAWAL;
            }
            case 3: {
                return EARN_ONLY;
            }
            case 4: {
                return PAY_ONLY;
            }
        }
        return null;
    }

    public static CardStatus convertFromDeprecated(CardStatus status) {
        switch (status) {
            case ACTIVE: {
                return EARN_PAY;
            }
            case BLOCKED: {
                return NO_OPERATION;
            }
            case ANONYMOUS_CARD: {
                return EARN_ONLY;
            }
        }
        return status;
    }

    public static CardStatus[] getLegacy() {
        return new CardStatus[]{ACTIVE, BLOCKED, ANONYMOUS_CARD, WITHDRAWAL};
    }

    public static CardStatus[] getModern() {
        return new CardStatus[]{EARN_ONLY, EARN_PAY, NO_OPERATION, PAY_ONLY};
    }
}

