/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.assetgroup;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import su.artix.accounting.domain.AssetGroup;
import su.artix.accounting.rpc.logic.LocationNotFound;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.dialogs.assetgroup.AssetGroupEditPanel;
import su.artix.discountmanager.utils.ErrorMessageFactory;
import su.artix.discountmanagercore.dao.accounting.AccountingDAO;
import su.artix.discountmanagercore.model.accounting.AccountingResult;
import su.artix.yuki.editors.DialogMode;
import su.artix.yuki.editors.DirectoryEditDialog;
import su.artix.yuki.editors.EditorComposite;

public class AssetGroupDialog
extends DirectoryEditDialog<AssetGroup> {
    private static final Logger log = LoggerFactory.getLogger(AssetGroupDialog.class);
    private EditorComposite<AssetGroup> panel;

    public AssetGroupDialog(Shell parentShell, AssetGroup model, DialogMode dialogMode) {
        super(parentShell, (Object)model, dialogMode);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        super.setTitle("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439", "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439 (\u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e)");
        super.setMessage("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439", "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b (\u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e)", 1);
        return contents;
    }

    protected EditorComposite<AssetGroup> getEditPanel(Composite parent, AssetGroup model) {
        this.panel = new AssetGroupEditPanel(parent, 0, model);
        this.panel.setParentDialog((DirectoryEditDialog)this);
        this.panel.initialize();
        return this.panel;
    }

    public boolean close() {
        this.panel.dispose();
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        AssetGroup actualModel = null;
        try {
            actualModel = (AssetGroup)org.apache.commons.beanutils.BeanUtils.cloneBean((Object)this.getOldModel());
        }
        catch (Exception exception) {
            log.error("can't clone model {} for {}", (Object)AssetGroup.class.getName(), this.getOldModel());
            actualModel = new AssetGroup();
        }
        this.panel = this.getEditPanel(parent, actualModel);
        this.panel.applyRights();
        if (DialogMode.UPDATE.equals((Object)this.getDialogMode())) {
            this.panel.bindValues();
            this.panel.setLayoutData((Object)new GridData(4, 4, true, true));
            Label titleBarSeparator = new Label(parent, 258);
            titleBarSeparator.setLayoutData((Object)new GridData(4, 0, true, false));
        }
        return parent;
    }

    public void saveAction(SelectionEvent event, boolean closeAfterSave) {
        block11: {
            AssetGroup model = (AssetGroup)this.panel.getActualModel();
            if (!model.equals(this.getOldModel())) {
                long beginShift = 0L;
                long endShift = 0L;
                int weight = 0;
                if (model.getBegin() != null && !model.getBegin().equals(((AssetGroup)this.getOldModel()).getBegin())) {
                    beginShift = ((AssetGroup)this.getOldModel()).getBegin() == null ? model.getBegin().getTime() : model.getBegin().getTime() - ((AssetGroup)this.getOldModel()).getBegin().getTime();
                }
                if (model.getEnd() != null && !model.getEnd().equals(((AssetGroup)this.getOldModel()).getEnd())) {
                    endShift = ((AssetGroup)this.getOldModel()).getEnd() == null ? model.getEnd().getTime() : model.getEnd().getTime() - ((AssetGroup)this.getOldModel()).getEnd().getTime();
                }
                if (!model.getWeight().equals(((AssetGroup)this.getOldModel()).getWeight())) {
                    weight = model.getWeight();
                }
                try {
                    AccountingResult result = Activator.getDefault().getBeanByClass(AccountingDAO.class).changeAssetGroup(model.getGroupId(), beginShift, endShift, weight);
                    if (result.isSuccess()) {
                        BeanUtils.copyProperties((Object)model, (Object)this.getOldModel());
                        if (closeAfterSave) {
                            this.buttonPressed((Integer)event.widget.getData());
                        }
                        break block11;
                    }
                    log.error("{}", (Object)result);
                    this.setErrorMessage("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u0443\u0434\u0430\u043b\u0430\u0441\u044c, \u0431\u043e\u043d\u0443\u0441\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0435\u0440 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0438\u043b: " + result.getDescription());
                }
                catch (LocationNotFound locationNotFound) {
                    ErrorMessageFactory.bonusServerMessage();
                }
                catch (BeansException beansException) {
                    log.error("can't copy properties into old model!!!");
                }
            } else if (closeAfterSave) {
                this.buttonPressed((Integer)event.widget.getData());
            }
        }
    }
}

