/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.python.core.PyBaseExceptionDerived;
import org.python.core.PyException;
import org.python.core.PySyntaxError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.discountmanager.dialogs.discountsystem.DiscountConditionValuePanel;
import su.artix.discountmanager.dialogs.discountsystem.FormulaConstructor;
import su.artix.discountmanager.dialogs.discountsystem.ParsedControlsMeta;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionControlListener;
import su.artix.discountmanager.holders.ViewHolder;
import su.artix.discountmanager.images.ImagesFactory;
import su.artix.discountmanager.utils.AstParser;
import su.artix.discountmanager.views.PeriodicImpactsBonusSystemView;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCardCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountConditionTemplate;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountConditionTemplateValue;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCouponCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObjectPosition;
import su.artix.widgets.TextWithClear;
import su.artix.widgets.TextWithClearLabel;
import su.artix.yuki.discount.condition.constructor.dao.ConstructorTreeProcessor;
import su.artix.yuki.discount.condition.constructor.dao.TreeException;
import su.artix.yuki.discount.condition.domain.xml.ConditionObjectTag;
import su.artix.yuki.discount.condition.domain.xml.ConditionTemplate;
import su.artix.yuki.discount.condition.domain.xml.ConditionTemplateValue;
import su.artix.yuki.discount.condition.domain.xml.ConditionType;
import su.artix.yuki.discount.condition.domain.xml.ConstListItem;
import su.artix.yuki.discount.condition.domain.xml.ConstListNode;
import su.artix.yuki.discount.condition.domain.xml.ConstructorWidgetType;
import su.artix.yuki.discount.condition.domain.xml.DiscountObjectType;
import su.artix.yuki.discount.condition.domain.xml.FunctionDataElement;
import su.artix.yuki.discount.condition.domain.xml.NodeValueType;
import su.artix.yuki.discount.condition.domain.xml.TreeContainerNode;
import su.artix.yuki.discount.condition.domain.xml.TreeFunctionNode;
import su.artix.yuki.discount.condition.domain.xml.TreeNode;
import su.artix.yuki.discount.condition.domain.xml.TreePropertyNode;
import su.artix.yuki.discount.condition.domain.xml.TreeRootNode;

public class DiscountConditionConstructorPanel
extends Composite {
    private static final Logger log = LoggerFactory.getLogger(DiscountConditionConstructorPanel.class);
    private TextWithClear txtCond;
    private TextWithClear txtDesc;
    private Text txtEvalMessage;
    private Button btnAdd;
    private Button btnAND;
    private Button btnOR;
    private Button btnNOT;
    private Button btnParenthesis;
    private Button btnEval;
    private ScrolledComposite panelReturn;
    private Action disableButtons;
    private Action enableButtons;
    private Button lessBtn;
    private Button greaterBtn;
    private Button lessOrEqualBtn;
    private Button greaterOrEqualBtn;
    private Button equalBtn;
    private Button notequalBtn;
    private Button inList;
    private List<String> mainSpecification;
    private List<String> mainDefinition;
    private List<String> mainFormula;
    private List<DiscountConditionTemplateValue> mainMetaArray;
    private List<String> simpleSpec;
    private List<String> simpleDef;
    private FormulaConstructor simpleFormula;
    private List<DiscountConditionTemplateValue> simpleMetaArray;
    private TreeRootNode objectTree;
    private ConstructorTreeProcessor processor;
    private TreeNode selectedNode;
    private boolean isTextConditionModified;
    private boolean isTextModifiedByProgram;
    private boolean isCardCondition;
    private boolean isCouponCondition;
    private static final String CARD = "card";
    private static final String COUPON = "coupon";
    private Discount parentDiscount;
    private DiscountCondition condition;
    private AstParser astParser;
    private String astParserErrorString;
    private List<DiscountConditionControlListener> listeners;
    private boolean isInputMultiple;
    private SelectionAdapter adapterLess = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            DiscountConditionConstructorPanel.this.changeToSingleInput(CompareButtonType.LESS);
        }
    };
    private SelectionAdapter adapterGreater = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            DiscountConditionConstructorPanel.this.changeToSingleInput(CompareButtonType.GREATER);
        }
    };
    private SelectionAdapter adapterInList = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            DiscountConditionConstructorPanel.this.changeToMultipleInput();
        }
    };
    private SelectionAdapter adapterLessOrEqual = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            DiscountConditionConstructorPanel.this.changeToSingleInput(CompareButtonType.LESS_OR_EQUAL);
        }
    };
    private SelectionAdapter adapterGreaterOrEqual = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            DiscountConditionConstructorPanel.this.changeToSingleInput(CompareButtonType.GREATER_OR_EQUAL);
        }
    };
    private SelectionAdapter adapterNotEqual = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            DiscountConditionConstructorPanel.this.changeToSingleInput(CompareButtonType.NOT_EQUAL);
        }
    };
    private SelectionAdapter adapterTwiceEqual = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            DiscountConditionConstructorPanel.this.changeToSingleInput(CompareButtonType.EQUAL);
        }
    };
    private static final List<ConstructorWidgetType> forbidenTypes = Arrays.asList(ConstructorWidgetType.Date, ConstructorWidgetType.Time, ConstructorWidgetType.Datetime);

    public DiscountConditionConstructorPanel(Composite parent, int style, Discount discount, DiscountCondition condition, ConstructorTreeProcessor processor) {
        super(parent, style);
        this.parentDiscount = discount;
        this.condition = condition != null ? condition : new DiscountCondition();
        this.processor = processor;
        this.mainSpecification = new ArrayList<String>();
        this.mainDefinition = new ArrayList<String>();
        this.mainFormula = new ArrayList<String>();
        this.mainMetaArray = new ArrayList<DiscountConditionTemplateValue>();
        this.simpleSpec = new ArrayList<String>();
        this.simpleDef = new ArrayList<String>();
        this.simpleFormula = new FormulaConstructor();
        this.simpleMetaArray = new ArrayList<DiscountConditionTemplateValue>();
        this.listeners = new ArrayList<DiscountConditionControlListener>();
        try {
            this.astParser = new AstParser();
        }
        catch (PyException ex) {
            log.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f python \u043f\u0430\u0440\u0441\u0435\u0440\u0430");
            this.astParserErrorString = ex.value.toString();
            this.astParser = null;
        }
        catch (Exception ex) {
            log.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f python \u043f\u0430\u0440\u0441\u0435\u0440\u0430", (Throwable)ex);
            this.astParserErrorString = ex.getMessage();
            this.astParser = null;
        }
        this.createWidgets();
    }

    /*
     * Unable to fully structure code
     */
    protected Control createWidgets() {
        block8: {
            mainPanel = this;
            GridLayoutFactory.fillDefaults().margins(5, 5).applyTo((Composite)mainPanel);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mainPanel);
            panelConditionText = new Composite((Composite)mainPanel, 2048);
            GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(2).applyTo(panelConditionText);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)panelConditionText);
            panelConditionConstructor = new Group((Composite)mainPanel, 0);
            GridLayoutFactory.fillDefaults().margins(3, 3).applyTo((Composite)panelConditionConstructor);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)panelConditionConstructor);
            panelConditionConstructor.setText("\u041a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0442\u043e\u0440");
            splitPanel = new SashForm((Composite)panelConditionConstructor, 256);
            GridLayoutFactory.fillDefaults().applyTo((Composite)splitPanel);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)splitPanel);
            lblDesc = new Label(panelConditionText, 0);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)lblDesc);
            lblDesc.setText("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435");
            this.txtDesc = new TextWithClearLabel(panelConditionText);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.txtDesc);
            this.txtDesc.setText(this.condition.getDescription());
            this.mainSpecification.add(this.condition.getDescription());
            this.txtDesc.setClearAction(new Action(){

                public void run() {
                    DiscountConditionConstructorPanel.this.mainSpecification.clear();
                }
            });
            lblCond = new Label(panelConditionText, 0);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)lblCond);
            lblCond.setText("\u0423\u0441\u043b\u043e\u0432\u0438\u0435");
            this.txtCond = new TextWithClearLabel(panelConditionText);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.txtCond);
            this.txtCond.setText(this.condition.getCondition());
            this.txtCond.setClearAction(new Action(){

                public void run() {
                    DiscountConditionConstructorPanel.this.txtDesc.clearText();
                    DiscountConditionConstructorPanel.this.txtCond.getTextField().setFocus();
                    if (DiscountConditionConstructorPanel.this.astParser != null) {
                        DiscountConditionConstructorPanel.this.txtEvalMessage.setText("");
                    }
                }
            });
            this.txtCond.getTextField().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!DiscountConditionConstructorPanel.this.txtCond.getText().trim().isEmpty()) {
                        DiscountConditionConstructorPanel.this.enableAndOrBtns();
                        DiscountConditionConstructorPanel.this.btnEval.setEnabled(DiscountConditionConstructorPanel.this.astParser != null);
                        DiscountConditionConstructorPanel.this.enableButtons.run();
                        if (DiscountConditionConstructorPanel.this.isTextModifiedByProgram) {
                            DiscountConditionConstructorPanel.this.isTextModifiedByProgram = false;
                        } else {
                            DiscountConditionConstructorPanel.this.isTextConditionModified = true;
                        }
                    } else {
                        DiscountConditionConstructorPanel.this.disableAndOrBtns();
                        DiscountConditionConstructorPanel.this.btnEval.setEnabled(false);
                        DiscountConditionConstructorPanel.this.disableButtons.run();
                        DiscountConditionConstructorPanel.this.isTextConditionModified = false;
                        DiscountConditionConstructorPanel.this.mainFormula.clear();
                        DiscountConditionConstructorPanel.this.mainSpecification.clear();
                        DiscountConditionConstructorPanel.this.mainDefinition.clear();
                        DiscountConditionConstructorPanel.this.mainMetaArray.clear();
                        DiscountConditionConstructorPanel.this.resetFlagsCondition();
                    }
                }
            });
            GridDataFactory.fillDefaults().applyTo((Control)new Label(panelConditionText, 0));
            panelControl = new Composite(panelConditionText, 0);
            GridLayoutFactory.fillDefaults().numColumns(6).applyTo(panelControl);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)panelControl);
            btnHeight = 22;
            btnWidth = 40;
            this.btnAND = new Button(panelControl, 8);
            GridDataFactory.fillDefaults().hint(btnWidth.intValue(), btnHeight.intValue()).applyTo((Control)this.btnAND);
            this.btnAND.setText("\u0418");
            this.btnAND.setToolTipText("\u041b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0435 '\u0418'");
            this.btnAND.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DiscountConditionConstructorPanel.this.addAnd("\u0438 ", " and ");
                }
            });
            this.btnOR = new Button(panelControl, 8);
            GridDataFactory.fillDefaults().hint(btnWidth.intValue(), btnHeight.intValue()).applyTo((Control)this.btnOR);
            this.btnOR.setText("\u0418\u041b\u0418");
            this.btnOR.setToolTipText("\u041b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0435 '\u0418\u041b\u0418'");
            this.btnOR.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DiscountConditionConstructorPanel.this.addAnd("\u0438\u043b\u0438 ", " or ");
                }
            });
            this.btnNOT = new Button(panelControl, 8);
            GridDataFactory.fillDefaults().hint(btnWidth.intValue(), btnHeight.intValue()).applyTo((Control)this.btnNOT);
            this.btnNOT.setText("\u041d\u0415");
            this.btnNOT.setToolTipText("\u041b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043e\u0442\u0440\u0438\u0446\u0430\u043d\u0438\u0435");
            this.btnNOT.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DiscountConditionConstructorPanel.this.addAnd("\u043d\u0435 ", " not ");
                }
            });
            this.btnParenthesis = new Button(panelControl, 8);
            GridDataFactory.fillDefaults().hint(btnWidth.intValue(), btnHeight.intValue()).applyTo((Control)this.btnParenthesis);
            this.btnParenthesis.setText("( )");
            this.btnParenthesis.setToolTipText("\u0412\u0437\u044f\u0442\u044c \u0432\u0441\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u0435 \u0432 \u043a\u0440\u0443\u0433\u043b\u044b\u0435 \u0441\u043a\u043e\u0431\u043a\u0438");
            this.btnParenthesis.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DiscountConditionConstructorPanel.this.isTextModifiedByProgram = true;
                    DiscountConditionConstructorPanel.this.txtCond.setText("(" + DiscountConditionConstructorPanel.this.txtCond.getText().trim() + ")");
                    DiscountConditionConstructorPanel.this.enableAndOrBtns();
                    DiscountConditionConstructorPanel.this.mainFormula.add(0, "(");
                    DiscountConditionConstructorPanel.this.mainDefinition.add(0, "(");
                    DiscountConditionConstructorPanel.this.mainFormula.add(")");
                    DiscountConditionConstructorPanel.this.mainDefinition.add(")");
                    DiscountConditionConstructorPanel.this.txtCond.getTextField().setFocus();
                    DiscountConditionConstructorPanel.this.txtCond.getTextField().setSelection(DiscountConditionConstructorPanel.this.txtCond.getText().length());
                }
            });
            this.btnEval = new Button(panelControl, 8);
            GridDataFactory.fillDefaults().hint(btnWidth * 2, btnHeight.intValue()).applyTo((Control)this.btnEval);
            this.btnEval.setText("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c");
            this.btnEval.setToolTipText("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0443\u0441\u043b\u043e\u0432\u0438\u044f");
            this.btnEval.setEnabled(false);
            this.txtEvalMessage = new Text(panelControl, 2056);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.txtEvalMessage);
            if (this.astParser == null) {
                this.btnEval.setEnabled(false);
                this.txtEvalMessage.setText("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0443\u0441\u043b\u043e\u0432\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430. \u041e\u0448\u0438\u0431\u043a\u0430: " + this.astParserErrorString);
            }
            requireList = new ArrayList<String>();
            try {
                dObj = this.parentDiscount.getDiscountObject();
                requireList.add("card");
                requireList.add("coupon");
                if (!(ViewHolder.INSTANCE.getActiveViewPart() instanceof PeriodicImpactsBonusSystemView)) {
                    requireList.add("document");
                    if (dObj instanceof DiscountObjectPosition) {
                        requireList.add("position");
                    }
                }
                this.objectTree = this.processor.getTree(requireList);
                break block8;
            }
            catch (TreeException ex) {
                var15_13 = panelConditionConstructor.getChildren();
                var14_15 = var15_13.length;
                var13_17 = 0;
                ** while (var13_17 < var14_15)
            }
lbl-1000:
            // 1 sources

            {
                control = var15_13[var13_17];
                control.dispose();
                ++var13_17;
                continue;
            }
lbl91:
            // 1 sources

            errorLabel = new Label((Composite)panelConditionConstructor, 0);
            errorLabel.setText(ex.getMessage());
            GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)errorLabel);
            return mainPanel;
        }
        this.btnEval.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AstParser.AstParserContext context = DiscountConditionConstructorPanel.this.validateContidion(DiscountConditionConstructorPanel.this.txtCond.getText(), DiscountConditionConstructorPanel.this.objectTree);
                DiscountConditionConstructorPanel.this.txtEvalMessage.setForeground(context.getColor());
                DiscountConditionConstructorPanel.this.txtEvalMessage.setText(context.getMessage());
                String obj = context.getUnknownObj();
                if (obj != null) {
                    int start = context.getColumn();
                    int end = start + obj.length();
                    DiscountConditionConstructorPanel.this.txtCond.getTextField().setSelection(start, end);
                }
            }
        });
        this.disableAndOrBtns();
        panelTree = new Composite((Composite)splitPanel, 0);
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo(panelTree);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panelTree);
        patternFilter = new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                boolean result = false;
                if (!result && (element instanceof TreePropertyNode || element instanceof TreeFunctionNode) && !(result = this.wordMatches(((TreeNode)element).getDisplay()))) {
                    result = this.wordMatches(((TreeNode)element).getName());
                }
                return result;
            }
        };
        patternFilter.setIncludeLeadingWildcard(true);
        groupTreePanel = new Composite(panelTree, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(groupTreePanel);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)groupTreePanel);
        groupTreeLabel = new Label(groupTreePanel, 0);
        groupTreeLabel.setText("\u0413\u0440\u0443\u043f\u043f\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432: ");
        combo = new ComboViewer(groupTreePanel, 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)combo.getCombo());
        tagsList = this.processor.getConditionObjectTagsList();
        combo.add((Object)"\u0412\u0441\u0435");
        for (ConditionObjectTag tag : tagsList) {
            combo.add((Object)tag.getDisplayText());
            combo.setData(tag.getDisplayText(), (Object)tag.getTagName());
        }
        combo.getCombo().select(0);
        filter = new FilteredTree(panelTree, 68352, patternFilter, true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)filter);
        treeViewer = filter.getViewer();
        filter.setInitialText("\u0424\u0438\u043b\u044c\u0442\u0440");
        textDescription = new Text(panelTree, 2114);
        GridDataFactory.fillDefaults().hint(45, 45).align(4, 1024).grab(true, false).applyTo((Control)textDescription);
        textDescription.setEditable(false);
        tmpTreeViewer = treeViewer;
        combo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                ComboViewer selectedCombo = (ComboViewer)arg0.getSource();
                String data = (String)selectedCombo.getData(selectedCombo.getCombo().getText());
                try {
                    TreeRootNode root = DiscountConditionConstructorPanel.this.processor.getTree(requireList);
                    if (data != null) {
                        boolean find = false;
                        find = DiscountConditionConstructorPanel.this.processor.filterByTag((TreeNode)root, data);
                        if (find && root.getCategories() != null && root.getCategories().size() == 0) {
                            root.addCategory(new TreeContainerNode("<none>", "<\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0435 \u0443\u0437\u043b\u044b>"));
                        }
                    }
                    tmpTreeViewer.setInput((Object)root);
                    textDescription.setText("");
                }
                catch (TreeException e) {
                    log.error(e.getMessage());
                }
            }
        });
        tree = treeViewer.getTree();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tree);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        treeColomn = new TreeColumn(tree, 16384);
        treeColomn.setText("\u042d\u043b\u0435\u043c\u0435\u043d\u0442");
        treeColomn = new TreeColumn(tree, 16384);
        treeColomn.setText("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
        layout = new TableLayout();
        weight = 180;
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(weight * 2 / 3));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(weight * 1 / 3));
        tree.setLayout((Layout)layout);
        treeViewer.setContentProvider((IContentProvider)new ObjectTreeContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new ObjectTreeLabelProvider());
        treeViewer.setInput((Object)this.objectTree);
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeSelection selection = (TreeSelection)event.getSelection();
                TreeNode node = (TreeNode)selection.getFirstElement();
                if (node != null) {
                    DiscountConditionConstructorPanel.this.clearSimpleCond();
                    if (node.getDesc() != null) {
                        textDescription.setText(node.getDesc());
                    }
                    DiscountConditionConstructorPanel.this.disableOpButtons();
                    if (!(node instanceof TreeContainerNode)) {
                        DiscountConditionConstructorPanel.this.isInputMultiple = false;
                        DiscountConditionConstructorPanel.this.addElement(((TreeViewer)event.getSource()).getTree());
                        DiscountConditionConstructorPanel.this.enableOpButtons(node);
                    }
                }
            }
        });
        secondPathPanel = new Composite((Composite)splitPanel, 0);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo(secondPathPanel);
        panelOperator = new Composite(secondPathPanel, 0);
        GridLayoutFactory.fillDefaults().applyTo(panelOperator);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)panelOperator);
        this.equalBtn = this.createOpButton(panelOperator, (SelectionListener)this.adapterTwiceEqual, "\u0420\u0430\u0432\u043d\u043e");
        this.notequalBtn = this.createOpButton(panelOperator, (SelectionListener)this.adapterNotEqual, "\u041d\u0435 \u0440\u0430\u0432\u043d\u043e");
        this.lessOrEqualBtn = this.createOpButton(panelOperator, (SelectionListener)this.adapterLessOrEqual, "\u041c\u0435\u043d\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e");
        this.greaterOrEqualBtn = this.createOpButton(panelOperator, (SelectionListener)this.adapterGreaterOrEqual, "\u0411\u043e\u043b\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e");
        this.lessBtn = this.createOpButton(panelOperator, (SelectionListener)this.adapterLess, "\u041c\u0435\u043d\u044c\u0448\u0435");
        this.greaterBtn = this.createOpButton(panelOperator, (SelectionListener)this.adapterGreater, "\u0411\u043e\u043b\u044c\u0448\u0435");
        this.inList = this.createOpButton(panelOperator, (SelectionListener)this.adapterInList, "\u041e\u0434\u0438\u043d \u0438\u0437");
        this.equalBtn.setImage(ImagesFactory.INSTANCE.getImage("24x24/shadow/equal.png"));
        this.notequalBtn.setImage(ImagesFactory.INSTANCE.getImage("24x24/shadow/not_equal.png"));
        this.lessOrEqualBtn.setImage(ImagesFactory.INSTANCE.getImage("24x24/shadow/less_or_equal.png"));
        this.greaterOrEqualBtn.setImage(ImagesFactory.INSTANCE.getImage("24x24/shadow/greater_or_equal.png"));
        this.lessBtn.setImage(ImagesFactory.INSTANCE.getImage("24x24/shadow/less.png"));
        this.greaterBtn.setImage(ImagesFactory.INSTANCE.getImage("24x24/shadow/greater.png"));
        this.inList.setImage(ImagesFactory.INSTANCE.getImage("24x24/shadow/inList.png"));
        panelLast = new Composite(secondPathPanel, 2048);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(panelLast);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)panelLast);
        this.panelReturn = new ScrolledComposite(panelLast, 512);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo((Composite)this.panelReturn);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.panelReturn);
        this.panelReturn.setExpandHorizontal(true);
        this.panelReturn.setExpandVertical(true);
        simpleCond = new Group(panelLast, 0);
        GridLayoutFactory.fillDefaults().applyTo((Composite)simpleCond);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)simpleCond);
        simpleCond.setText("\u041f\u0440\u043e\u0441\u0442\u043e\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u0435");
        txtSimple = new TextWithClearLabel((Composite)simpleCond);
        this.simpleFormula.setTxt(txtSimple.getTextField());
        txtSimple.setEditable(false);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)txtSimple);
        txtSimple.setClearAction(new Action(){

            public void run() {
                DiscountConditionConstructorPanel.this.clearSimpleCond();
                DiscountConditionConstructorPanel.this.txtCond.getTextField().setFocus();
            }
        });
        this.btnAdd = new Button((Composite)simpleCond, 8);
        this.btnAdd.setEnabled(false);
        this.btnAdd.setText("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u0432 \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u0435");
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false).applyTo((Control)this.btnAdd);
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscountConditionConstructorPanel.this.addSimpleToMain();
                DiscountConditionConstructorPanel.this.clearSimpleCond();
                DiscountConditionConstructorPanel.this.enableAndOrBtns();
                DiscountConditionConstructorPanel.this.txtCond.getTextField().setFocus();
            }
        });
        if (!this.txtCond.getText().isEmpty()) {
            this.enableAndOrBtns();
            this.btnEval.setEnabled(true);
            this.mainFormula.add(this.condition.getCondition());
            this.mainDefinition.add(this.condition.getCondition());
        }
        this.disableOpButtons();
        this.txtCond.getTextField().setFocus();
        return mainPanel;
    }

    private void changeToSingleInput(CompareButtonType operatorType) {
        if (this.isInputMultiple) {
            String previousValue = this.getPreviousValue();
            this.clearSimpleCond();
            this.showValueWidgets(this.selectedNode, false, previousValue);
            this.enableOpButtons(this.selectedNode);
            this.isInputMultiple = false;
        }
        this.showOperator(operatorType);
    }

    private void changeToMultipleInput() {
        if (!this.isInputMultiple) {
            String previousValue = this.getPreviousValue();
            this.clearSimpleCond();
            this.showValueWidgets(this.selectedNode, true, previousValue);
            this.enableOpButtons(this.selectedNode);
            this.showOperator(CompareButtonType.IN_LIST);
            this.simpleFormula.update();
            this.isInputMultiple = true;
        }
    }

    private String getPreviousValue() {
        String result = this.simpleFormula.getTechFormula().get(this.simpleFormula.getSize() - 1);
        if (result.startsWith("[") && result.endsWith("]")) {
            result = StringUtils.substringBetween((String)result, (String)"[", (String)"]");
        }
        if ((result = StringUtils.substringBefore((String)result, (String)",")).startsWith("u\"") && result.endsWith("\"")) {
            result = StringUtils.substringBetween((String)result, (String)"u\"", (String)"\"");
        }
        return result;
    }

    private void addAnd(String desc, String cond) {
        this.isTextModifiedByProgram = true;
        this.txtCond.append(cond);
        this.txtDesc.append(desc);
        this.disableAndOrBtns();
        this.mainFormula.add(cond);
        this.mainSpecification.add(desc);
        this.mainDefinition.add(cond);
        this.txtCond.getTextField().setFocus();
        this.txtCond.getTextField().setSelection(this.txtCond.getText().length());
    }

    private void disableAndOrBtns() {
        this.btnAND.setEnabled(false);
        this.btnOR.setEnabled(false);
        this.btnParenthesis.setEnabled(false);
    }

    private void enableAndOrBtns() {
        this.btnAND.setEnabled(true);
        this.btnOR.setEnabled(true);
        this.btnParenthesis.setEnabled(true);
    }

    protected void addSimpleToMain() {
        int start = this.txtCond.getText().length();
        this.mainFormula.addAll(this.simpleFormula.getTechFormula());
        this.mainSpecification.addAll(this.simpleSpec);
        this.mainDefinition.addAll(this.simpleDef);
        this.mainMetaArray.addAll(this.simpleMetaArray);
        this.isTextModifiedByProgram = true;
        this.txtCond.append(this.simpleFormula.getTechString());
        int finish = this.txtCond.getText().length();
        this.txtDesc.append(this.simpleFormula.getDescString());
        this.txtCond.getTextField().setSelection(start, finish);
    }

    protected void clearSimpleCond() {
        this.simpleMetaArray.clear();
        this.simpleFormula.clear();
        this.simpleSpec.clear();
        this.simpleDef.clear();
        Control[] controlArray = this.panelReturn.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        this.disableOpButtons();
        this.btnAdd.setEnabled(false);
        this.listeners.clear();
    }

    private Button createOpButton(Composite parent, SelectionListener adapter, String tooltipText) {
        Button btn = new Button(parent, 8);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)btn);
        btn.addSelectionListener(adapter);
        btn.setToolTipText(tooltipText);
        return btn;
    }

    private void addElement(Tree tree) {
        TreeItem[] items = tree.getSelection();
        if (items != null && items.length > 0) {
            TreeNode newSelectedNode = (TreeNode)items[0].getData();
            if (newSelectedNode instanceof TreeFunctionNode || newSelectedNode instanceof TreePropertyNode) {
                this.disableOpButtons();
                this.showValueWidgets(newSelectedNode, false);
                this.selectedNode = newSelectedNode;
            } else {
                this.selectedNode = null;
            }
        } else {
            this.selectedNode = null;
        }
    }

    private void showValueWidgets(TreeNode node, boolean multipleInput) {
        this.showValueWidgets(node, multipleInput, null);
    }

    private void showValueWidgets(TreeNode node, boolean multipleInput, String defaultValue) {
        Composite main = new Composite((Composite)this.panelReturn, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(main);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        this.panelReturn.setContent((Control)main);
        if (node instanceof TreeFunctionNode) {
            DiscountConditionValuePanel panel;
            TreeFunctionNode nodeFunc = (TreeFunctionNode)node;
            if (nodeFunc.getRequirements() != null) {
                if (nodeFunc.getRequirements().contains(CARD)) {
                    this.isCardCondition = true;
                }
                if (nodeFunc.getRequirements().contains(COUPON)) {
                    this.isCouponCondition = true;
                }
            }
            String startFuncStr = String.valueOf(StringUtils.isEmpty((String)node.getPrefix()) ? "" : node.getPrefix()) + nodeFunc.getName() + "(";
            this.simpleFormula.add(startFuncStr, nodeFunc.getDesc());
            this.simpleDef.add(startFuncStr);
            this.simpleSpec.add(nodeFunc.getDesc());
            if (nodeFunc.isParamsExists()) {
                List<ParsedControlsMeta> metas = this.getParamMetas(nodeFunc);
                panel = new DiscountConditionValuePanel(main, 0, metas);
                GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)panel);
                main.layout();
                Map<ParsedControlsMeta, DiscountConditionControl> controls = panel.getControlsWithMetaMap();
                int i = 0;
                for (Map.Entry<ParsedControlsMeta, DiscountConditionControl> entry : controls.entrySet()) {
                    DiscountConditionControl control = entry.getValue();
                    DiscountConditionControlListener listener = this.getListener(i * 2 + 1, control, this.simpleMetaArray.get(i));
                    ++i;
                    this.listeners.add(listener);
                    control.addListener(listener);
                    this.simpleFormula.add(control.getText(), control.getDesc());
                    this.simpleDef.add("${..}");
                    this.simpleSpec.add("[..]");
                    this.simpleFormula.add(",", "\u0438");
                    this.simpleDef.add(",");
                    this.simpleSpec.add("\u0438");
                }
                this.simpleFormula.remove(this.simpleFormula.getSize() - 1);
                this.simpleSpec.remove(this.simpleSpec.size() - 1);
                this.simpleDef.remove(this.simpleDef.size() - 1);
            }
            this.simpleFormula.add(")", "");
            this.simpleDef.add(")");
            this.simpleSpec.add("");
            if (nodeFunc.isReturn()) {
                NodeValueType type = nodeFunc.getReturnValue().getVar();
                ParsedControlsMeta retMeta = this.getMeta(nodeFunc.getReturnValue().getDisplay(), type);
                DiscountConditionTemplateValue val = new DiscountConditionTemplateValue(nodeFunc.getReturnValue().getDisplay(), type.getXmlType());
                this.simpleMetaArray.add(val);
                if (multipleInput) {
                    this.changeTypeToList(retMeta, val);
                }
                if (defaultValue != null) {
                    retMeta.setDefaultValue(defaultValue);
                }
                panel = new DiscountConditionValuePanel(main, 0, Arrays.asList(retMeta));
                GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
                main.layout();
                this.simpleFormula.addDummy();
                this.simpleFormula.addDummy();
                DiscountConditionControl returnControl = panel.getControlsWithMetaMap().get(retMeta);
                DiscountConditionControlListener listener = this.getListener(this.simpleFormula.getSize() - 1, returnControl, this.simpleMetaArray.get(this.simpleMetaArray.size() - 1));
                this.listeners.add(listener);
                returnControl.addListener(listener);
                this.simpleSpec.add("");
                this.simpleSpec.add("[..]");
                this.simpleDef.add("");
                this.simpleDef.add("${..}");
                this.showOperator(CompareButtonType.EQUAL);
            }
            this.callListeners();
        } else if (node instanceof TreePropertyNode) {
            TreePropertyNode nodeProp = (TreePropertyNode)node;
            String techObject = this.processor.getFullNameOfNode((TreeNode)nodeProp);
            if (techObject.contains(CARD)) {
                this.isCardCondition = true;
            }
            if (techObject.contains(COUPON)) {
                this.isCouponCondition = true;
            }
            this.simpleFormula.add(techObject.toLowerCase(Locale.US), nodeProp.getDesc());
            this.simpleFormula.addDummy();
            this.simpleFormula.addDummy();
            this.simpleDef.add(techObject.toLowerCase(Locale.US));
            this.simpleDef.add("");
            this.simpleDef.add("${..}");
            this.simpleSpec.add(nodeProp.getDesc());
            this.simpleSpec.add("");
            this.simpleSpec.add("[..]");
            ParsedControlsMeta retMeta = this.getMeta(nodeProp.getDisplay(), nodeProp.getVar());
            DiscountConditionTemplateValue val = new DiscountConditionTemplateValue(nodeProp.getDisplay(), nodeProp.getVar().getXmlType());
            this.simpleMetaArray.add(val);
            if (multipleInput) {
                this.changeTypeToList(retMeta, val);
            }
            if (defaultValue != null) {
                retMeta.setDefaultValue(defaultValue);
            }
            DiscountConditionValuePanel panel = new DiscountConditionValuePanel(main, 0, Arrays.asList(retMeta));
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
            main.layout();
            DiscountConditionControl control = panel.getControlsWithMetaMap().get(retMeta);
            DiscountConditionControlListener listener = this.getListener(2, control, this.simpleMetaArray.get(0));
            this.listeners.add(listener);
            control.addListener(listener);
            this.showOperator(CompareButtonType.EQUAL);
        }
        this.simpleFormula.update();
        this.panelReturn.setMinSize(main.computeSize(-1, -1));
    }

    private void changeTypeToList(ParsedControlsMeta meta, DiscountConditionTemplateValue tempVal) {
        ConstructorWidgetType type;
        switch (meta.getType()) {
            case Text: {
                type = ConstructorWidgetType.MultiText;
                break;
            }
            case String: {
                type = ConstructorWidgetType.MultiString;
                break;
            }
            case Double: {
                type = ConstructorWidgetType.MultiDouble;
                break;
            }
            case Int: {
                type = ConstructorWidgetType.MultiInt;
                break;
            }
            case Code: {
                type = ConstructorWidgetType.Codes;
                break;
            }
            case Barcode: {
                type = ConstructorWidgetType.Barcodes;
                break;
            }
            case InventGroup: {
                type = ConstructorWidgetType.InventGroups;
                break;
            }
            case Client: {
                type = ConstructorWidgetType.Clients;
                break;
            }
            case Card: {
                type = ConstructorWidgetType.Cards;
                break;
            }
            case CardGroup: {
                type = ConstructorWidgetType.CardGroups;
                break;
            }
            case Catalog: {
                type = ConstructorWidgetType.Catalogs;
                break;
            }
            case Valut: {
                type = ConstructorWidgetType.Valuts;
                break;
            }
            default: {
                type = ConstructorWidgetType.Unknown;
            }
        }
        if (ConstructorWidgetType.Unknown != type) {
            meta.setType(type);
            tempVal.setType(type.toString());
        }
    }

    private DiscountConditionControlListener getListener(final int index, final DiscountConditionControl control, final DiscountConditionTemplateValue tempValue) {
        return new DiscountConditionControlListener(){

            @Override
            public void exec() {
                String text = control.getText();
                DiscountConditionConstructorPanel.this.simpleFormula.set(index, text, control.getDesc());
                if (text.startsWith("u\"") && text.endsWith("\"")) {
                    text = StringUtils.substringBetween((String)text, (String)"u\"", (String)"\"");
                }
                tempValue.setDefaultValue(text);
                DiscountConditionConstructorPanel.this.simpleFormula.update();
            }
        };
    }

    private List<ParsedControlsMeta> getParamMetas(TreeFunctionNode nodeFunc) {
        ArrayList<ParsedControlsMeta> metas = new ArrayList<ParsedControlsMeta>();
        if (nodeFunc.isParamsExists()) {
            for (FunctionDataElement elem : nodeFunc.getParams()) {
                metas.add(this.getMeta(elem.getDisplay(), elem.getVar()));
                this.simpleMetaArray.add(new DiscountConditionTemplateValue(elem.getDisplay(), elem.getVar().getXmlType()));
            }
        }
        return metas;
    }

    private ParsedControlsMeta getMeta(String name, NodeValueType value) {
        ParsedControlsMeta meta = new ParsedControlsMeta();
        meta.setLabel(name);
        meta.setType(value.getType());
        meta.setDefaultValue(value.getDefaultValue());
        if (value instanceof ConstListNode) {
            ConstListNode constNode = (ConstListNode)value;
            meta.setConstListType(constNode.getMode());
            for (ConstListItem item : constNode.getList()) {
                meta.addValue(item.getDisplay(), item.getValue());
            }
        }
        return meta;
    }

    private void callListeners() {
        for (DiscountConditionControlListener listener : this.listeners) {
            listener.exec();
        }
    }

    public boolean okPressed() {
        AstParser.AstParserContext context = this.validateContidion(this.txtCond.getText(), this.objectTree);
        if (AstParser.ValidateResultType.SUCCESS == context.getType() || MessageDialog.openConfirm((Shell)this.getShell(), (String)"\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", (String)(String.valueOf(context.getMessage()) + "\n\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c?"))) {
            this.condition = this.isCardCondition ? new DiscountCardCondition() : (this.isCouponCondition ? new DiscountCouponCondition() : new DiscountCondition());
            this.condition.setDescription(this.txtDesc.getText());
            this.condition.setCondition(this.txtCond.getText());
            this.condition.setTemplate(this.buildTemplate());
            return true;
        }
        return false;
    }

    public void dispose() {
        this.mainSpecification.clear();
        this.mainDefinition.clear();
        this.mainFormula.clear();
        this.mainMetaArray.clear();
        this.simpleSpec.clear();
        this.simpleDef.clear();
        this.simpleMetaArray.clear();
        this.simpleFormula.clear();
        this.listeners.clear();
        super.dispose();
    }

    public ConditionTemplate getTemplate() {
        ConditionTemplate template = new ConditionTemplate();
        if (this.isCardCondition) {
            template.setType(ConditionType.CARD);
            template.addTag(CARD);
        } else if (this.isCouponCondition) {
            template.setType(ConditionType.COUPON);
            template.addTag(COUPON);
        } else {
            template.setType(ConditionType.COMMON);
            template.addTag("common");
        }
        template.addTag("custom");
        if (this.isTextConditionModified) {
            template.setDefinition(null);
        } else {
            template.setDefinition(this.buildDefinition());
        }
        template.setSpecification(this.buildSpecification());
        template.addDiscountType(DiscountObjectType.CHECK);
        template.addDiscountType(DiscountObjectType.POSITION);
        template.addDiscountType(DiscountObjectType.KIT);
        ArrayList<ConditionTemplateValue> list = new ArrayList<ConditionTemplateValue>();
        for (DiscountConditionTemplateValue val : this.mainMetaArray) {
            list.add(new ConditionTemplateValue(val.getLabel(), val.getType(), val.getDefaultValue()));
        }
        template.setValues(list);
        return template;
    }

    /*
     * Unable to fully structure code
     */
    private AstParser.AstParserContext validateContidion(String conditionString, TreeRootNode root) {
        block16: {
            context = new AstParser.AstParserContext();
            if (this.astParser == null) {
                context.setType(AstParser.ValidateResultType.SUCCESS);
                return context;
            }
            notFound = new ArrayList<String>();
            try {
                card = false;
                coupon = false;
                exprs = this.astParser.parse(conditionString);
                for (TreeNode node : exprs) {
                    fullName = this.processor.getFullNameOfNode(node);
                    find = false;
                    for (TreeNode findNode : this.processor.searchTreeNode(root, node.getName())) {
                        nameOfFindNode = this.processor.getFullNameOfNode(findNode);
                        if (!fullName.equalsIgnoreCase(nameOfFindNode)) continue;
                        find = true;
                        if (findNode instanceof TreeFunctionNode) {
                            functionNode = (TreeFunctionNode)findNode;
                            if (functionNode.getRequirements() == null) break;
                            if (functionNode.getRequirements().contains("card")) {
                                card = true;
                            }
                            if (!functionNode.getRequirements().contains("coupon")) break;
                            coupon = true;
                            break;
                        }
                        if (!(findNode instanceof TreePropertyNode)) break;
                        propertyNode = (TreePropertyNode)findNode;
                        nameOfPropertyNode = this.processor.getFullNameOfNode((TreeNode)propertyNode);
                        if (nameOfPropertyNode.contains("card")) {
                            card = true;
                        }
                        if (!nameOfPropertyNode.contains("coupon")) break;
                        coupon = true;
                        break;
                    }
                    if (find) continue;
                    notFound.add(fullName);
                }
                if (!notFound.isEmpty()) {
                    this.isCardCondition = this.condition instanceof DiscountCardCondition;
                    this.isCouponCondition = this.condition instanceof DiscountCouponCondition;
                    throw new Exception();
                }
                this.resetFlagsCondition();
                this.isCardCondition = card;
                this.isCouponCondition = coupon;
                if (this.isCardCondition && this.isCouponCondition) {
                    context.setType(AstParser.ValidateResultType.ERROR);
                    context.setColor(Display.getDefault().getSystemColor(3));
                    context.setMessage("\u0423\u0441\u043b\u043e\u0432\u0438\u0435 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u043f\u043e \u043a\u0430\u0440\u0442\u0435 \u0438 \u043f\u043e \u043a\u0443\u043f\u043e\u043d\u0443 \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e");
                } else {
                    context.setType(AstParser.ValidateResultType.SUCCESS);
                    greenColor = new Color((Device)Display.getDefault(), 20, 140, 20);
                    context.setColor(greenColor);
                    context.setMessage("\u0423\u0441\u043b\u043e\u0432\u0438\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e");
                }
                break block16;
            }
            catch (PySyntaxError ex) {
                context = this.astParser.parseSyntaxException(ex);
                context.setType(AstParser.ValidateResultType.ERROR);
                context.setColor(Display.getDefault().getSystemColor(3));
                DiscountConditionConstructorPanel.log.warn(ex.value.toString());
                break block16;
            }
            catch (PyException ex) {
                context.setType(AstParser.ValidateResultType.WARNINNG);
                orangeColor = new Color((Device)Display.getDefault(), 210, 105, 0);
                context.setColor(orangeColor);
                pyobj = ex.value;
                if (pyobj instanceof PyBaseExceptionDerived) {
                    context.setMessage(pyobj.__getattr__("message").toString());
                } else {
                    context.setMessage(pyobj.__str__().toString());
                }
                DiscountConditionConstructorPanel.log.warn(context.getMessage());
                break block16;
            }
            catch (Exception v0) {
                context.setType(AstParser.ValidateResultType.WARNINNG);
                orangeColor = new Color((Device)Display.getDefault(), 210, 105, 0);
                context.setColor(orangeColor);
                context.setUnknownObj((String)notFound.get(0));
                context.setColumn(this.txtCond.getText().indexOf(context.getUnknownObj()));
                msg = new StringBuilder();
                ** for (item : notFound)
            }
lbl-1000:
            // 1 sources

            {
                msg.append("\u041e\u0431\u044a\u0435\u043a\u0442 \"");
                msg.append(item);
                msg.append("\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d ");
                continue;
            }
lbl86:
            // 1 sources

            context.setMessage(msg.toString());
            DiscountConditionConstructorPanel.log.warn(context.getMessage());
        }
        return context;
    }

    private void showOperator(CompareButtonType code) {
        String conditionOperatorText;
        String conditionOperator;
        switch (code) {
            case LESS: {
                conditionOperator = " <  ";
                conditionOperatorText = "\u043c\u0435\u043d\u044c\u0448\u0435";
                break;
            }
            case GREATER: {
                conditionOperator = " >  ";
                conditionOperatorText = "\u0431\u043e\u043b\u044c\u0448\u0435";
                break;
            }
            case LESS_OR_EQUAL: {
                conditionOperator = " <= ";
                conditionOperatorText = "\u043c\u0435\u043d\u044c\u0448\u0435 \u043b\u0438\u0431\u043e \u0440\u0430\u0432\u043d\u043e";
                break;
            }
            case GREATER_OR_EQUAL: {
                conditionOperator = " >= ";
                conditionOperatorText = "\u0431\u043e\u043b\u044c\u0448\u0435 \u043b\u0438\u0431\u043e \u0440\u0430\u0432\u043d\u043e";
                break;
            }
            case EQUAL: {
                conditionOperator = " == ";
                conditionOperatorText = "\u0440\u0430\u0432\u043d\u043e";
                break;
            }
            case NOT_EQUAL: {
                conditionOperator = " != ";
                conditionOperatorText = "\u043d\u0435 \u0440\u0430\u0432\u043d\u043e";
                break;
            }
            case IN_LIST: {
                conditionOperator = " in ";
                conditionOperatorText = " \u043e\u0434\u0438\u043d \u0438\u0437 ";
                break;
            }
            default: {
                conditionOperator = "";
                conditionOperatorText = "";
            }
        }
        this.simpleFormula.set(this.simpleFormula.getSize() - 2, conditionOperator, conditionOperatorText);
        this.simpleDef.set(this.simpleFormula.getSize() - 2, conditionOperator);
        this.simpleSpec.set(this.simpleFormula.getSize() - 2, conditionOperatorText);
        this.simpleFormula.update();
        this.callListeners();
        this.btnAdd.setEnabled(true);
    }

    private void enableOpButtons(TreeNode node) {
        this.disableOpButtons();
        boolean funcFlag = node instanceof TreeFunctionNode && ((TreeFunctionNode)node).isReturn();
        boolean propFlag = node instanceof TreePropertyNode;
        NodeValueType valueType = null;
        if (funcFlag) {
            valueType = ((TreeFunctionNode)node).getReturnValue().getVar();
        } else if (propFlag) {
            valueType = ((TreePropertyNode)node).getVar();
        }
        if (propFlag || funcFlag) {
            ConstructorWidgetType type = valueType.getType();
            if (valueType instanceof ConstListNode) {
                type = ((ConstListNode)valueType).getType();
            }
            boolean isReturnTypeString = funcFlag && type != null && type == ConstructorWidgetType.String;
            this.notequalBtn.setEnabled(true);
            this.equalBtn.setEnabled(true);
            ConstructorWidgetType t = ConstructorWidgetType.getControlTypeFromString((String)valueType.getXmlType());
            if (!forbidenTypes.contains(type) && ConstructorWidgetType.Unknown != t) {
                this.inList.setEnabled(true);
            }
            if (propFlag && (type == ConstructorWidgetType.Int || type == ConstructorWidgetType.Double) || funcFlag && !isReturnTypeString) {
                this.lessBtn.setEnabled(true);
                this.greaterBtn.setEnabled(true);
                this.lessOrEqualBtn.setEnabled(true);
                this.greaterOrEqualBtn.setEnabled(true);
            }
        } else {
            this.btnAdd.setEnabled(true);
        }
    }

    private void disableOpButtons() {
        this.lessBtn.setEnabled(false);
        this.greaterBtn.setEnabled(false);
        this.lessOrEqualBtn.setEnabled(false);
        this.greaterOrEqualBtn.setEnabled(false);
        this.equalBtn.setEnabled(false);
        this.notequalBtn.setEnabled(false);
        this.inList.setEnabled(false);
    }

    private String buildDefinition() {
        StringBuilder definition = new StringBuilder();
        for (String str : this.mainDefinition) {
            definition.append(str);
        }
        return definition.toString().trim();
    }

    private String buildSpecification() {
        StringBuilder specitication = new StringBuilder();
        for (String str : this.mainSpecification) {
            specitication.append(str);
            specitication.append(" ");
        }
        return specitication.toString().trim();
    }

    private DiscountConditionTemplate buildTemplate() {
        DiscountConditionTemplate template = new DiscountConditionTemplate();
        template.setSpecification(this.buildSpecification());
        template.setDefinition(this.buildDefinition());
        template.getValues().addAll(this.mainMetaArray);
        return template;
    }

    private void resetFlagsCondition() {
        this.isCardCondition = false;
        this.isCouponCondition = false;
    }

    public boolean isChanged() {
        return !this.condition.getCondition().equals(this.txtCond.getText()) || !this.condition.getDescription().equals(this.txtDesc.getText());
    }

    public DiscountCondition getDiscountCondition() {
        return this.condition;
    }

    public Action getDisableButtons() {
        return this.disableButtons;
    }

    public void setDisableButtons(Action disableButtons) {
        this.disableButtons = disableButtons;
    }

    public Action getEnableButtons() {
        return this.enableButtons;
    }

    public void setEnableButtons(Action enableButtons) {
        this.enableButtons = enableButtons;
    }

    private static enum CompareButtonType {
        LESS("<"),
        GREATER(">"),
        LESS_OR_EQUAL("<="),
        GREATER_OR_EQUAL(">="),
        EQUAL("=="),
        NOT_EQUAL("!="),
        IN_LIST("in");

        private String display;

        private CompareButtonType(String display) {
            this.display = display;
        }

        public String toString() {
            return this.display;
        }
    }

    private static class ObjectTreeContentProvider
    implements ITreeContentProvider {
        private ObjectTreeContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            if (element instanceof TreeRootNode) {
                return ((TreeRootNode)element).getCategories() != null;
            }
            if (element instanceof TreeContainerNode) {
                return ((TreeContainerNode)element).getNodes() != null;
            }
            return false;
        }

        public Object getParent(Object element) {
            TreeNode node = (TreeNode)element;
            return node.getParent();
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof TreeRootNode) {
                return ((TreeRootNode)parentElement).getCategories().toArray();
            }
            if (parentElement instanceof TreeContainerNode) {
                return ((TreeContainerNode)parentElement).getNodes().toArray();
            }
            return new Object[0];
        }
    }

    private static class ObjectTreeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ObjectTreeLabelProvider() {
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public String getColumnText(Object element, int columnIndex) {
            TreeNode node = (TreeNode)element;
            String text = "";
            if (columnIndex == 0) {
                text = node.getDisplay();
            } else if (columnIndex == 1) {
                text = node.getName();
            }
            return text;
        }

        public Image getColumnImage(Object element, int arg1) {
            return null;
        }
    }
}

