/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import su.artix.discountmanager.dialogs.discountsystem.ConditionTemplateConverter;
import su.artix.discountmanager.dialogs.discountsystem.DiscountConditionTemplateFillerDialog;
import su.artix.discountmanager.images.ImagesFactory;
import su.artix.discountmanager.providers.discountsystem.ArrayTreeContentProvider;
import su.artix.discountmanager.providers.discountsystem.DiscountTemplateLabelProvider;
import su.artix.discountmanager.tables.DiscountTemplateTreeViewer;
import su.artix.discountmanager.utils.ErrorMessageFactory;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCardCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCouponCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountKitObject;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObject;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObjectCheck;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObjectKit;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObjectPosition;
import su.artix.yuki.discount.condition.domain.xml.ConditionTemplate;
import su.artix.yuki.discount.condition.domain.xml.ConditionTemplateTag;
import su.artix.yuki.discount.condition.domain.xml.ConditionType;
import su.artix.yuki.discount.condition.domain.xml.DiscountObjectType;
import su.artix.yuki.discount.condition.template.dao.ConditionTemplateDAO;

public class DiscountConditionTemplatePanel
extends Composite {
    private DiscountCondition condition;
    private ConditionTemplate currentTemplate;
    private List<ConditionTemplate> templates;
    private Discount discount;
    private ConditionTemplateDAO conditionTemplatesDAO;
    private TreeViewer treeViewer;
    private FilteredTree filter;
    private Combo comboFilter;
    private ToolBar toolBar;
    private Action deleteTemplateAction;
    private Action restoreTemplateAction;
    private Action fillCurrentTemplateAction;
    private Action doubleClickAction;
    private Action templateFilled;
    private boolean showToolbar;

    public DiscountConditionTemplatePanel(Composite parent, int style, Discount discount, ConditionTemplateDAO dao, boolean showToolbar) {
        super(parent, style);
        this.discount = discount;
        this.conditionTemplatesDAO = dao;
        this.showToolbar = showToolbar;
        this.fillCurrentTemplateAction = new FillTemplateValuesAction();
        this.deleteTemplateAction = new DeleteTemplateAction();
        this.restoreTemplateAction = new RestoreTemplateAction();
        this.doubleClickAction = this.fillCurrentTemplateAction;
        this.createDialogArea(parent);
    }

    private Control createDialogArea(Composite parent) {
        DiscountConditionTemplatePanel mainPanel = this;
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo((Composite)mainPanel);
        Composite filterPanel = new Composite((Composite)mainPanel, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(filterPanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)filterPanel);
        Label labelForType = new Label(filterPanel, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)labelForType);
        labelForType.setText("\u0413\u0440\u0443\u043f\u043f\u0430 \u0443\u0441\u043b\u043e\u0432\u0438\u0439");
        this.comboFilter = new Combo(filterPanel, 2060);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.comboFilter);
        List templateCategories = this.conditionTemplatesDAO.getTemplateTags();
        if (templateCategories != null && !templateCategories.isEmpty()) {
            this.comboFilter.add("\u0412\u0441\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u044f");
            this.comboFilter.setData("\u0412\u0441\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u044f", (Object)"");
            for (ConditionTemplateTag category : templateCategories) {
                this.comboFilter.add(category.getDisplayText());
                this.comboFilter.setData(category.getDisplayText(), (Object)category.getTagName());
            }
            this.comboFilter.select(0);
            this.comboFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DiscountConditionTemplatePanel.this.refreshTreeViewer();
                }
            });
        } else {
            this.comboFilter.setEnabled(false);
            this.comboFilter.add("<\u041d\u0435\u0442 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0439>");
            this.comboFilter.select(0);
        }
        Composite templatesPanel = new Composite((Composite)mainPanel, 2048);
        GridLayoutFactory.fillDefaults().applyTo(templatesPanel);
        GridDataFactory.fillDefaults().hint(400, 400).grab(true, true).applyTo((Control)templatesPanel);
        if (this.showToolbar) {
            this.toolBar = new ToolBar(templatesPanel, 0x820000);
            GridDataFactory.fillDefaults().applyTo((Control)this.toolBar);
            ToolBarManager toolBarManager = new ToolBarManager(this.toolBar);
            toolBarManager.add((IAction)this.fillCurrentTemplateAction);
            toolBarManager.add((IContributionItem)new Separator());
            toolBarManager.add((IAction)this.deleteTemplateAction);
            toolBarManager.add((IAction)this.restoreTemplateAction);
            toolBarManager.update(true);
        }
        this.templates = this.filterByDiscountObjectType(this.conditionTemplatesDAO.getTemplateList());
        PatternFilter patternFilter = new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                boolean result = super.isLeafMatch(viewer, element);
                if (!result && element instanceof ConditionTemplate) {
                    result = this.wordMatches(((ConditionTemplate)element).getSpecification());
                }
                return result;
            }
        };
        this.filter = new DiscountTemplateTreeViewer(templatesPanel, 66306, patternFilter);
        this.filter.getViewer().getControl().setFocus();
        this.treeViewer = this.filter.getViewer();
        this.treeViewer.setContentProvider((IContentProvider)new ArrayTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DiscountTemplateLabelProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DiscountConditionTemplatePanel.this.currentTemplate = (ConditionTemplate)((StructuredSelection)event.getSelection()).getFirstElement();
                if (DiscountConditionTemplatePanel.this.currentTemplate == null) {
                    DiscountConditionTemplatePanel.this.deleteTemplateAction.setEnabled(false);
                    DiscountConditionTemplatePanel.this.fillCurrentTemplateAction.setEnabled(false);
                } else {
                    DiscountConditionTemplatePanel.this.deleteTemplateAction.setEnabled(true);
                    DiscountConditionTemplatePanel.this.fillCurrentTemplateAction.setEnabled(true);
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent arg0) {
                DiscountConditionTemplatePanel.this.doubleClickAction.run();
            }
        });
        this.treeViewer.setInput(this.templates);
        this.selectFirstTableElement();
        return mainPanel;
    }

    private void selectFirstTableElement() {
        if (this.treeViewer.getTree().getItemCount() > 0) {
            TreeItem item = this.treeViewer.getTree().getItem(0);
            this.treeViewer.setSelection((ISelection)new StructuredSelection(item.getData()));
            this.deleteTemplateAction.setEnabled(true);
            this.fillCurrentTemplateAction.setEnabled(true);
            this.currentTemplate = (ConditionTemplate)item.getData();
        } else {
            this.deleteTemplateAction.setEnabled(false);
            this.fillCurrentTemplateAction.setEnabled(false);
            this.currentTemplate = null;
        }
    }

    private void refreshTreeViewer() {
        String tag = (String)this.comboFilter.getData(this.comboFilter.getText());
        if (tag != null && !tag.isEmpty()) {
            this.treeViewer.setInput(this.filterByDiscountObjectType(this.conditionTemplatesDAO.filterTemplatesByTag(tag)));
        } else {
            this.treeViewer.setInput(this.templates);
        }
        this.selectFirstTableElement();
    }

    private List<ConditionTemplate> filterByDiscountObjectType(List<ConditionTemplate> input) {
        ArrayList<ConditionTemplate> newTemplates = new ArrayList<ConditionTemplate>();
        DiscountObject discountObject = this.discount.getDiscountObject();
        if (input != null) {
            for (ConditionTemplate template : input) {
                if (discountObject instanceof DiscountObjectCheck && template.getDiscountTypes().contains(DiscountObjectType.CHECK)) {
                    newTemplates.add(template);
                    continue;
                }
                if (discountObject instanceof DiscountObjectPosition && template.getDiscountTypes().contains(DiscountObjectType.POSITION)) {
                    newTemplates.add(template);
                    continue;
                }
                if (!(discountObject instanceof DiscountObjectKit) && !(discountObject instanceof DiscountKitObject) || !template.getDiscountTypes().contains(DiscountObjectType.KIT)) continue;
                newTemplates.add(template);
            }
        }
        return newTemplates;
    }

    protected boolean isTemplateFormulaValid(ConditionTemplate template) {
        int count;
        String[] values = StringUtils.substringsBetween((String)template.getDefinition(), (String)"${", (String)"}");
        if (values.length != (count = StringUtils.countMatches((String)template.getSpecification(), (String)"[..]"))) {
            ErrorMessageFactory.generalErrorMessage("\u041e\u0448\u0438\u0431\u043a\u0430", "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0448\u0430\u0431\u043b\u043e\u043d", "\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043c\u0430\u043a\u0440\u043e\u0441\u043e\u0432 \u0432 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0438 (" + count + ") \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0443 \u0432\u0432\u043e\u0434\u0438\u043c\u044b\u0445 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 (" + values.length + ")\n" + template.getDefinition());
            return false;
        }
        return true;
    }

    public Action getDoubleClickAction() {
        return this.doubleClickAction;
    }

    public void setDoubleClickAction(Action doubleClickAction) {
        this.doubleClickAction = doubleClickAction;
    }

    public Action getTemplateFilled() {
        return this.templateFilled;
    }

    public void setTemplateFilled(Action templateFilled) {
        this.templateFilled = templateFilled;
    }

    public DiscountCondition getDiscountCondition() {
        return this.condition;
    }

    public ConditionTemplate getSelectedTemplate() {
        return this.currentTemplate;
    }

    public void refresh() {
        this.templates = this.filterByDiscountObjectType(this.conditionTemplatesDAO.getTemplateList());
        this.refreshTreeViewer();
    }

    private class DeleteTemplateAction
    extends Action {
        public DeleteTemplateAction() {
            super("&\u0423\u0434\u0430\u043b\u0438\u0442\u044c", ImagesFactory.INSTANCE.getImageDescriptor("16x16/plane/delete.png"));
        }

        public void run() {
            StructuredSelection selection = (StructuredSelection)DiscountConditionTemplatePanel.this.treeViewer.getSelection();
            ConditionTemplate ct = (ConditionTemplate)selection.getFirstElement();
            if (MessageDialog.openConfirm((Shell)DiscountConditionTemplatePanel.this.getShell(), (String)"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", (String)("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0443\u0441\u043b\u043e\u0432\u0438\u0435 " + ct.getOrder() + "?"))) {
                DiscountConditionTemplatePanel.this.templates.remove(ct);
                DiscountConditionTemplatePanel.this.conditionTemplatesDAO.deleteTemplate(ct);
                DiscountConditionTemplatePanel.this.refreshTreeViewer();
            }
        }
    }

    private class FillTemplateValuesAction
    extends Action {
        public FillTemplateValuesAction() {
            super("&\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u044c", ImagesFactory.INSTANCE.getImageDescriptor("16x16/shadow/form_green.png"));
        }

        public void run() {
            DiscountConditionTemplateFillerDialog dialog;
            if (DiscountConditionTemplatePanel.this.currentTemplate != null && DiscountConditionTemplatePanel.this.isTemplateFormulaValid(DiscountConditionTemplatePanel.this.currentTemplate) && (dialog = new DiscountConditionTemplateFillerDialog(DiscountConditionTemplatePanel.this.getShell(), DiscountConditionTemplatePanel.this.currentTemplate, "\u0417\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u044f")).open() == 0) {
                if (ConditionType.CARD.equals((Object)DiscountConditionTemplatePanel.this.currentTemplate.getType())) {
                    DiscountConditionTemplatePanel.this.condition = (DiscountCondition)new DiscountCardCondition();
                } else if (ConditionType.COUPON.equals((Object)DiscountConditionTemplatePanel.this.currentTemplate.getType())) {
                    DiscountConditionTemplatePanel.this.condition = (DiscountCondition)new DiscountCouponCondition();
                } else {
                    DiscountConditionTemplatePanel.this.condition = new DiscountCondition();
                }
                DiscountConditionTemplatePanel.this.condition.setCondition(dialog.getCondition());
                DiscountConditionTemplatePanel.this.condition.setDescription(dialog.getDescription());
                DiscountConditionTemplatePanel.this.condition.setTemplate(ConditionTemplateConverter.convert(dialog.getTemplate()));
                DiscountConditionTemplatePanel.this.currentTemplate = dialog.getTemplate();
                if (DiscountConditionTemplatePanel.this.templateFilled != null) {
                    DiscountConditionTemplatePanel.this.templateFilled.run();
                }
            }
        }
    }

    private class RestoreTemplateAction
    extends Action {
        public RestoreTemplateAction() {
            super("&\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0448\u0430\u0431\u043b\u043e\u043d\u044b \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e", ImagesFactory.INSTANCE.getImageDescriptor("16x16/plane/restore_template.gif"));
        }

        public void run() {
            DiscountConditionTemplatePanel.this.conditionTemplatesDAO.restoreDefaultTemplate();
            DiscountConditionTemplatePanel.this.templates = DiscountConditionTemplatePanel.this.filterByDiscountObjectType(DiscountConditionTemplatePanel.this.conditionTemplatesDAO.getTemplateList());
            DiscountConditionTemplatePanel.this.refreshTreeViewer();
        }
    }
}

