/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionControlListener;

public class DiscountConditionSelectControl
implements DiscountConditionControl {
    private List<Button> buttons;

    public DiscountConditionSelectControl(Composite parent, String labelName, Map<String, String> items, String defaultValue) {
        Group group = new Group(parent, 0x800000);
        group.setText(labelName);
        GridLayoutFactory.swtDefaults().applyTo((Composite)group);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).align(4, 4).applyTo((Control)group);
        this.buttons = new ArrayList<Button>();
        for (Map.Entry<String, String> entry : items.entrySet()) {
            Button btn = new Button((Composite)group, 16);
            btn.setText(entry.getKey());
            btn.setData((Object)entry.getValue());
            btn.setSelection(false);
            if (defaultValue != null && defaultValue.equalsIgnoreCase(entry.getValue())) {
                btn.setSelection(true);
            }
            this.buttons.add(btn);
        }
        group.layout();
    }

    @Override
    public String getText() {
        String result = "";
        for (Button btn : this.buttons) {
            if (!btn.getSelection()) continue;
            result = (String)btn.getData();
            break;
        }
        return result;
    }

    @Override
    public String getDesc() {
        String result = "";
        for (Button btn : this.buttons) {
            if (!btn.getSelection()) continue;
            result = btn.getText();
            break;
        }
        return result;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void addListener(final DiscountConditionControlListener listener) {
        for (Button btn : this.buttons) {
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    listener.exec();
                }
            });
        }
    }
}

