/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.cashtree.provider;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.artixadmin.connection.ManagedWebUserSource;
import su.artix.cashserver.cashtree.Activator;
import su.artix.cashserver.cashtree.domain.Group;
import su.artix.cashserver.cashtree.domain.MiddleServer;
import su.artix.cashserver.cashtree.domain.Node;
import su.artix.cashserver.cashtree.model.TreeModel;
import su.artix.cashserver.core.cashregistry.domain.CashServerMode;
import su.artix.cashserver.core.cashregistry.domain.WebUser;

public class ViewTreeContentProvider
implements ITreeContentProvider {
    private static final Logger log = LoggerFactory.getLogger(ViewTreeContentProvider.class);
    private TreeModel model;

    private String getClusterId() {
        WebUser user = Activator.getDefault().getBeanByClass(ManagedWebUserSource.class).getCurrentUser();
        return user.getClusterId();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.model = Activator.getDefault().getTreeModel();
    }

    public Object[] getElements(Object inputElement) {
        log.trace("get elements for:{}", inputElement);
        return this.model.getRoots(this.getClusterId()).toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Group) {
            Group group = (Group)parentElement;
            ArrayList childs = new ArrayList();
            childs.addAll(this.model.getGroupsByParentCode(this.getClusterId(), group.getId()));
            childs.addAll(this.model.getMiddleServersByParentCode(this.getClusterId(), group.getId()));
            childs.addAll(this.model.getShopsByParentCode(this.getClusterId(), group.getId()));
            childs.addAll(this.model.getCategoriesByParentCode(this.getClusterId(), group.getId()));
            return childs.toArray();
        }
        if (parentElement instanceof MiddleServer) {
            MiddleServer middleServer = (MiddleServer)parentElement;
            return this.model.getShopsByParentCode(this.getClusterId(), middleServer.getId()).toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Group || element instanceof MiddleServer && CashServerMode.HierarchyMode.MIDDLE.equals((Object)ArtixAdminContextHolder.getCashServerMode().getHierarhyMode())) {
            return ((Node)element).hasChildren();
        }
        return false;
    }
}

