/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.cashtree.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.springframework.beans.factory.annotation.Autowired;
import su.artix.cashserver.cashtree.domain.Tag;
import su.artix.cashserver.cashtree.domain.TagType;
import su.artix.cashserver.cashtree.filter.ShopFilter;
import su.artix.cashserver.cashtree.filter.ShopFilterImpl;
import su.artix.cashserver.cashtree.images.ImagesFactory;
import su.artix.cashserver.cashtree.model.TagModel;
import su.artix.cashserver.cashtree.model.TreeModel;
import su.artix.cashserver.cashtree.model.TypeAction;
import su.artix.cashserver.cashtree.provider.ViewTagContentProvider;
import su.artix.cashserver.cashtree.provider.ViewTagLabelProvider;
import su.artix.widgets.FilterElement;
import su.artix.widgets.SimpleFilterElement;
import su.artix.widgets.SimpleFilterTextControl;

public class ViewShops
extends CommonNavigator
implements PropertyChangeListener,
ISelectionListener {
    public static final String ID = "su.artix.cashserver.cashtree.viewShops";
    private CheckboxTreeViewer tagsTreeViewer;
    private ShopFilter filter;
    @Autowired
    private TagModel tagModel;
    @Autowired
    private TreeModel treeModel;
    private Button clearFilterButton;

    public void createPartControl(Composite parent) {
        GridLayout gl_parent = new GridLayout(1, false);
        gl_parent.marginHeight = 0;
        gl_parent.marginWidth = 0;
        parent.setLayout((Layout)gl_parent);
        this.treeModel.addPropertyChangeListener((PropertyChangeListener)this);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        final SashForm sashForm = new SashForm(composite, 66048);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite compositeTreeView = new Composite((Composite)sashForm, 2048);
        SimpleFilterTextControl searchText = new SimpleFilterTextControl(compositeTreeView, 128, 1000L, (FilterElement)new SimpleFilterElement(new String[]{"field"})){

            protected void acceptFilter(ColumnViewer viewer, FilterElement filterElement, Object filterValue) {
                if (filterValue instanceof String) {
                    ViewShops.this.filter.setSearchText((String)filterValue);
                    Object[] expandElements = ((CommonViewer)viewer).getExpandedElements();
                    ((CommonViewer)viewer).refresh();
                    ((CommonViewer)viewer).setExpandedElements(expandElements);
                }
            }
        };
        searchText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        super.createPartControl(compositeTreeView);
        compositeTreeView.setLayout((Layout)new GridLayout(1, false));
        this.filter = new ShopFilterImpl();
        this.getCommonViewer().addFilter((ViewerFilter)this.filter);
        searchText.setViewer((ColumnViewer)this.getCommonViewer());
        Tree shopTree = this.getCommonViewer().getTree();
        GridData gd_shopTree = new GridData(4, 4, true, true, 1, 1);
        gd_shopTree.widthHint = 186;
        gd_shopTree.heightHint = 469;
        shopTree.setLayoutData((Object)gd_shopTree);
        Group group = new Group((Composite)sashForm, 0);
        group.setText("\u0424\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u043c\u0435\u0442\u043a\u0430\u043c");
        group.setLayout((Layout)new GridLayout(1, true));
        this.tagsTreeViewer = new CheckboxTreeViewer((Composite)group, 2048);
        this.tagsTreeViewer.setContentProvider((IContentProvider)new ViewTagContentProvider(this.tagModel){

            @Override
            public Object[] getElements(Object inputElement) {
                ArrayList<TagType> searchTree = new ArrayList<TagType>();
                for (TagType type : ViewShops.this.tagModel.getTagTypes()) {
                    if (ViewShops.this.tagModel.getTagsByType(type).size() <= 0) continue;
                    searchTree.add(type);
                }
                return searchTree.toArray();
            }
        });
        this.tagsTreeViewer.setLabelProvider((IBaseLabelProvider)new ViewTagLabelProvider());
        this.tagsTreeViewer.setInput((Object)this.tagModel);
        this.tagsTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object[] objects;
                if (event.getChecked()) {
                    ViewShops.this.tagsTreeViewer.setSubtreeChecked(event.getElement(), true);
                } else {
                    ViewShops.this.tagsTreeViewer.setSubtreeChecked(event.getElement(), false);
                }
                ArrayList<Tag> tags = new ArrayList<Tag>();
                Object[] objectArray = objects = ViewShops.this.tagsTreeViewer.getCheckedElements();
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof Tag) {
                        tags.add((Tag)obj);
                    }
                    ++n2;
                }
                ViewShops.this.filter.setSearchTags(tags);
                ViewShops.this.clearFilterButton.setEnabled(!tags.isEmpty());
                Object[] expandElements = ViewShops.this.getCommonViewer().getExpandedElements();
                ViewShops.this.getCommonViewer().refresh();
                ViewShops.this.getCommonViewer().setExpandedElements(expandElements);
            }
        });
        Tree tagsTree = this.tagsTreeViewer.getTree();
        tagsTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tagsTreeViewer.setSorter(new ViewerSorter());
        sashForm.setWeights(new int[]{1000, 1});
        Composite compositeShopNameLabel = new Composite(composite, 0);
        compositeShopNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gl_compositeShopNameLabel = new GridLayout(2, false);
        gl_compositeShopNameLabel.marginHeight = 0;
        gl_compositeShopNameLabel.marginWidth = 0;
        compositeShopNameLabel.setLayout((Layout)gl_compositeShopNameLabel);
        final Button buttonHide = new Button(compositeShopNameLabel, 0x800002);
        buttonHide.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        buttonHide.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (buttonHide.getSelection()) {
                    sashForm.setWeights(new int[]{1, 1});
                } else {
                    sashForm.setWeights(new int[]{1000, 1});
                }
            }
        });
        buttonHide.setToolTipText("\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0444\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u043c\u0435\u0442\u043a\u0430\u043c");
        buttonHide.setImage(ImagesFactory.INSTANCE.getImageDescriptor("filter.png").createImage());
        this.clearFilterButton = new Button(compositeShopNameLabel, 0);
        this.clearFilterButton.setText("\u043e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0444\u0438\u043b\u044c\u0442\u0440");
        this.clearFilterButton.setToolTipText("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0444\u0438\u043b\u044c\u0442\u0440\u0430 \u043f\u043e \u043c\u0435\u0442\u043a\u0430\u043c \u0434\u043b\u044f \u0434\u0435\u0440\u0435\u0432\u0430 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432");
        this.clearFilterButton.setEnabled(false);
        this.clearFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] objectArray = ViewShops.this.tagsTreeViewer.getCheckedElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    ViewShops.this.tagsTreeViewer.setSubtreeChecked(element, false);
                    ++n2;
                }
                List<Tag> tags = Collections.emptyList();
                ViewShops.this.filter.setSearchTags(tags);
                Object[] expandElements = ViewShops.this.getCommonViewer().getExpandedElements();
                ViewShops.this.getCommonViewer().refresh();
                ViewShops.this.getCommonViewer().setExpandedElements(expandElements);
                ViewShops.this.clearFilterButton.setEnabled(false);
            }
        });
        this.tagModel.addPropertyChangeListener((PropertyChangeListener)this);
        ToolBarManager toolManager = new ToolBarManager(256);
        toolManager.createControl(parent);
        if (this.getCommonViewer().getTree().getItemCount() > 0) {
            this.getCommonViewer().expandToLevel(2);
        }
    }

    public void setFocus() {
        this.getCommonViewer().getControl().setFocus();
    }

    protected Object getInitialInput() {
        return this.treeModel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof TagModel) {
            Object[] expandedElements = this.tagsTreeViewer.getExpandedElements();
            this.tagsTreeViewer.setInput((Object)this.tagModel);
            this.tagsTreeViewer.refresh();
            this.tagsTreeViewer.setExpandedElements(expandedElements);
        } else if (TypeAction.REFRESH.toString().equals(evt.getPropertyName())) {
            this.getCommonViewer().refresh();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }
}

