/*
 * Decompiled with CFR 0.152.
 */
package manual;

import javax.xml.bind.JAXBException;
import manual.DT208Keyboard;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import su.artix.yuki.keyboard.dao.XmlKeyboardDAO;
import su.artix.yuki.keyboard.domain.KeyboardContainer;
import su.artix.yuki.keyboard.gui.KeyboardPanel;

public class KeyboardViewerDialog
extends Dialog {
    private XmlKeyboardDAO keyboardDAO = new XmlKeyboardDAO();

    protected KeyboardViewerDialog(Shell parentShell) throws JAXBException {
        super(parentShell);
    }

    public static void main(String[] args) throws JAXBException {
        new KeyboardViewerDialog(null).open();
    }

    protected Control createDialogArea(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(main);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        Button loadKeyboard = new Button(main, 8);
        loadKeyboard.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        loadKeyboard.setText("\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u0443");
        Button showHotKeys = new Button(main, 32);
        GridDataFactory.fillDefaults().applyTo((Control)showHotKeys);
        showHotKeys.setText("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0433\u043e\u0440\u044f\u0447\u0438\u0435 \u043a\u043b\u0430\u0432\u0438\u0448\u0438");
        Button showCodes = new Button(main, 32);
        GridDataFactory.fillDefaults().applyTo((Control)showCodes);
        showCodes.setText("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043a\u043e\u0434\u044b \u043a\u043b\u0430\u0432\u0438\u0448");
        KeyboardContainer keyboard = DT208Keyboard.getKeyboard();
        final KeyboardPanel panel = new KeyboardPanel(main, 0, keyboard);
        GridDataFactory.fillDefaults().applyTo((Control)panel);
        loadKeyboard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(KeyboardViewerDialog.this.getShell());
                String[] extensions = new String[]{"*.xml"};
                dialog.setFilterExtensions(extensions);
                String filePath = dialog.open();
                if (filePath != null && !filePath.isEmpty()) {
                    try {
                        KeyboardContainer container = KeyboardViewerDialog.this.keyboardDAO.getKeyboard(filePath);
                        panel.update(container);
                    }
                    catch (JAXBException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        showCodes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button btn = (Button)e.widget;
                if (btn.getSelection()) {
                    panel.setShowCode(true);
                } else {
                    panel.setShowCode(false);
                }
            }
        });
        showHotKeys.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button btn = (Button)e.widget;
                if (btn.getSelection()) {
                    panel.setShowHotKey(true);
                } else {
                    panel.setShowHotKey(false);
                }
            }
        });
        Button saveKeyboard = new Button(main, 8);
        GridDataFactory.fillDefaults().applyTo((Control)saveKeyboard);
        saveKeyboard.setText("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u0443");
        saveKeyboard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(KeyboardViewerDialog.this.getShell());
                String filePath = dialog.open();
                if (filePath != null && !filePath.isEmpty()) {
                    try {
                        KeyboardViewerDialog.this.keyboardDAO.saveKeyboard(panel.getKeyboard(), filePath);
                        System.out.println("Keyboard " + panel.getKeyboard().getName() + " saved to file: " + filePath);
                    }
                    catch (JAXBException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        return main;
    }
}

