/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanagercore.holders;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.discountmanagercore.holders.ProperiesType;

public enum PropertiesHolder {
    INSTANCE;

    private final Logger log = LoggerFactory.getLogger(PropertiesHolder.class);
    private Map<ProperiesType, Properties> map = new HashMap<ProperiesType, Properties>();
    private Map<String, String> accountingProperties = new HashMap<String, String>();

    private PropertiesHolder() {
        ProperiesType[] properiesTypeArray = ProperiesType.values();
        int n2 = properiesTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ProperiesType type = properiesTypeArray[n3];
            Properties properties = new Properties();
            String path = this.getPath(type);
            if (path != null) {
                this.log.info("load properties from:{}", (Object)path);
                try {
                    if (this.loadProperties(properties, path)) {
                        type.setCurrentPath(path);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.log.warn("properties:{} not found in path:{}", (Object)type, (Object)path);
                }
            } else {
                this.log.error("properties:{} not found", (Object)type);
            }
            this.map.put(type, properties);
            ++n3;
        }
    }

    public String getPath(ProperiesType name) {
        String fileName = name.getName();
        String path = this.getUserLocation(fileName);
        if (this.checkPath(path)) {
            return path;
        }
        String installPath = this.getInstallLocation(fileName);
        if (installPath != null) {
            if (this.checkPath(installPath)) {
                try {
                    FileUtils.copyFile((File)new File(installPath), (File)new File(path));
                }
                catch (IOException iOException) {
                    return installPath;
                }
                return path;
            }
            return path;
        }
        return null;
    }

    private boolean checkPath(String path) {
        this.log.debug("check path {}", (Object)path);
        return new File(path).exists();
    }

    private String getUserLocation(String fileName) {
        return String.valueOf(System.getProperty("user.home")) + "/.yuki/" + fileName;
    }

    private boolean loadProperties(Properties properties, String path) throws FileNotFoundException {
        System.err.println(path);
        FileInputStream fileInputStream = new FileInputStream(new File(path));
        try {
            properties.load(fileInputStream);
            fileInputStream.close();
            return true;
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private void saveProperties(Properties properties, String path) {
        if (path != null && !path.isEmpty()) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(new File(path));
                properties.store(fileOutputStream, null);
                fileOutputStream.close();
            }
            catch (FileNotFoundException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getInstallLocation(String fileName) {
        try {
            URL installLocation = Platform.getInstallLocation().getURL();
            System.err.println(installLocation);
            this.log.trace("installLocation={}", (Object)installLocation);
            URL url = new URL(installLocation + fileName);
            System.err.println(url);
            return url.getFile();
        }
        catch (MalformedURLException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        return null;
    }

    public String getCommonsProperty(String key, String defaultValue) {
        return this.getProperty(ProperiesType.COMMONS, key, defaultValue);
    }

    private String getProperty(ProperiesType type, String key, String defaultValue) {
        if (this.map.get((Object)type).containsKey(key)) {
            return this.map.get((Object)type).getProperty(key);
        }
        return defaultValue;
    }

    public String getGuiProperty(String key, String defaultValue) {
        return this.getProperty(ProperiesType.GUI, key, defaultValue);
    }

    public String getAccountingProperty(String key) {
        return this.accountingProperties.get(key);
    }

    public String getDeviceProperty(String key, String defaultValue) {
        return this.getProperty(ProperiesType.DEVICE, key, defaultValue);
    }

    private void setProperty(ProperiesType type, String key, String value, boolean autosave) {
        this.map.get((Object)type).setProperty(key, value);
        if (autosave) {
            this.saveProperties(this.map.get((Object)type), type.getCurrentPath());
        }
    }

    public void setCommonsProperty(String key, String value) {
        this.setProperty(ProperiesType.COMMONS, key, value, true);
    }

    public void setAccountingProperty(String key, String value) {
        this.accountingProperties.put(key, value);
    }

    public void setGuiProperty(String key, String value) {
        this.setProperty(ProperiesType.GUI, key, value, false);
    }

    public void save(ProperiesType type) {
        this.saveProperties(this.map.get((Object)type), type.getCurrentPath());
    }
}

