/*
 * Decompiled with CFR 0.152.
 */
package com.richclientgui.toolbox.label;

import com.richclientgui.toolbox.label.ScrollingLabelListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ScrollingLabel
extends Canvas {
    private static final int DEFAULT_PERIOD = 100;
    private final Timer timer = new Timer();
    private final List<ScrollingLabelListener> listeners = new ArrayList<ScrollingLabelListener>();
    private final Object disposeLock = new Object();
    private boolean disposed = false;
    private ScrollTask task;
    private String message;
    private int xPos = 0;
    private int yPos = 0;
    private long periodScrollCharacter = 100L;
    private boolean verticalScroll = false;
    private boolean textFits = false;
    private boolean init = true;
    private Point window;
    private Point textExtent;

    private static int checkStyle(int style) {
        int newStyle = 0;
        if ((style & 0x800) == 2048) {
            newStyle |= 0x800;
        }
        if ((style & 0x40000) == 262144) {
            newStyle |= 0x40000;
        }
        return newStyle;
    }

    public ScrollingLabel(Composite parent, int style) {
        this(parent, style, 100L);
    }

    public ScrollingLabel(Composite parent, int style, long scrollPeriod) {
        super(parent, ScrollingLabel.checkStyle(style) | 0x20000000);
        this.verticalScroll = (style & 0x200) == 512;
        this.periodScrollCharacter = scrollPeriod;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ScrollingLabel.this.paintControl(e);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                ScrollingLabel.this.widgetDisposed();
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent arg0) {
                ScrollingLabel.this.window = new Point(ScrollingLabel.this.getClientArea().width, ScrollingLabel.this.getClientArea().height);
                if (ScrollingLabel.this.textExtent != null) {
                    ScrollingLabel.this.textFits = !ScrollingLabel.this.verticalScroll && ((ScrollingLabel)ScrollingLabel.this).textExtent.x <= ((ScrollingLabel)ScrollingLabel.this).window.x || ScrollingLabel.this.verticalScroll && ((ScrollingLabel)ScrollingLabel.this).textExtent.y <= ((ScrollingLabel)ScrollingLabel.this).window.y;
                    if (ScrollingLabel.this.textFits) {
                        ScrollingLabel.this.xPos = 0;
                        ScrollingLabel.this.yPos = 0;
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScrollListener(ScrollingLabelListener listener) {
        List<ScrollingLabelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateListeners() {
        List<ScrollingLabelListener> list = this.listeners;
        synchronized (list) {
            Iterator<ScrollingLabelListener> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                iter.next().cycleComplete();
            }
        }
    }

    public void setScrollPeriod(long milliseconds) {
        this.checkWidget();
        this.periodScrollCharacter = milliseconds;
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = new ScrollTask();
        this.textFits = false;
        this.init = true;
        this.timer.schedule((TimerTask)this.task, 0L, this.periodScrollCharacter);
    }

    public void setText(String text) {
        this.checkWidget();
        this.message = text;
        this.xPos = 0;
        this.yPos = 0;
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = new ScrollTask();
        this.textFits = false;
        this.init = true;
        this.timer.schedule((TimerTask)this.task, 0L, this.periodScrollCharacter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void widgetDisposed() {
        Object object = this.disposeLock;
        synchronized (object) {
            this.disposed = true;
        }
        if (this.task != null) {
            this.task.cancel();
        }
        this.timer.cancel();
        this.timer.purge();
    }

    private void paintControl(PaintEvent e) {
        if (this.init) {
            Point pnt = e.gc.textExtent(this.message);
            this.textExtent = new Point(pnt.x + e.gc.textExtent((String)this.message.substring((int)(this.message.length() - 1), (int)this.message.length())).x, pnt.y);
            this.window = new Point(this.getClientArea().width, this.getClientArea().height);
            this.init = false;
            this.textFits = !this.verticalScroll && this.textExtent.x <= this.window.x || this.verticalScroll && this.textExtent.y <= this.window.y;
            this.xPos = 0;
            this.yPos = 0;
        }
        e.gc.setTextAntialias(1);
        if (this.textFits) {
            e.gc.drawText(this.message, 0, 0, true);
        } else {
            if (this.verticalScroll && this.yPos != 0 && this.textExtent.y + this.yPos < this.window.y) {
                e.gc.drawText(this.message, 0, this.yPos + this.textExtent.y, true);
            } else if (!this.verticalScroll && this.xPos != 0 && this.textExtent.x + this.xPos < this.window.x) {
                e.gc.drawText(this.message, this.xPos + this.textExtent.x, 0, true);
            }
            e.gc.drawText(this.message, this.xPos, this.yPos, true);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (this.textExtent != null) {
            return super.computeSize(wHint, this.textExtent.y, changed);
        }
        return super.computeSize(wHint, hHint, changed);
    }

    private class ScrollTask
    extends TimerTask {
        private ScrollTask() {
        }

        @Override
        public void run() {
            if (ScrollingLabel.this.textFits) {
                return;
            }
            if (!ScrollingLabel.this.init) {
                if (ScrollingLabel.this.verticalScroll) {
                    ScrollingLabel scrollingLabel = ScrollingLabel.this;
                    scrollingLabel.yPos = scrollingLabel.yPos - 1;
                    if (Math.abs(ScrollingLabel.this.yPos) >= ((ScrollingLabel)ScrollingLabel.this).textExtent.y) {
                        ScrollingLabel.this.yPos = 0;
                    }
                    if (ScrollingLabel.this.yPos != 0 && ((ScrollingLabel)ScrollingLabel.this).textExtent.y + ScrollingLabel.this.yPos == ((ScrollingLabel)ScrollingLabel.this).window.y) {
                        ScrollingLabel.this.updateListeners();
                    }
                } else {
                    ScrollingLabel scrollingLabel = ScrollingLabel.this;
                    scrollingLabel.xPos = scrollingLabel.xPos - 1;
                    if (Math.abs(ScrollingLabel.this.xPos) >= ((ScrollingLabel)ScrollingLabel.this).textExtent.x) {
                        ScrollingLabel.this.xPos = 0;
                    }
                    if (ScrollingLabel.this.xPos != 0 && ((ScrollingLabel)ScrollingLabel.this).textExtent.x + ScrollingLabel.this.xPos == ((ScrollingLabel)ScrollingLabel.this).window.x) {
                        ScrollingLabel.this.updateListeners();
                    }
                }
            }
            Display.getDefault().syncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ScrollingLabel.this.disposeLock;
                    synchronized (object) {
                        if (ScrollingLabel.this.disposed) {
                            return;
                        }
                    }
                    ScrollingLabel.this.redraw();
                }
            });
        }
    }
}

