/*
 * Decompiled with CFR 0.152.
 */
package com.richclientgui.toolbox.validation.validator;

import com.richclientgui.toolbox.Messages;
import com.richclientgui.toolbox.validation.converter.DateStringConverter;
import com.richclientgui.toolbox.validation.converter.IContentsStringConverter;
import com.richclientgui.toolbox.validation.validator.AbstractInputMaskValidator;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateFieldValidator
extends AbstractInputMaskValidator<Date> {
    public static final String DATE_ONLY_DASH = "####-##-##";
    public static final String DATE_ONLY_SLASH = "####/##/##";
    public static final String DATE_TIME_HHMM_DASH = "####-##-## ##:##";
    public static final String DATE_TIME_HHMM_SLASH = "####/##/## ##:##";
    public static final String DATE_TIME_HHMMSS_DASH = "####-##-## ##:##:##";
    public static final String DATE_TIME_HHMMSS_SLASH = "####/##/## ##:##:##";
    public static final String TIME_ONLY_HHMMSS = "##:##:##";
    public static final String TIME_ONLY_HHMM = "##:##";
    private static final Map<String, DateFormat> PATTERN_2_DATEFORMAT_MAP = new HashMap<String, DateFormat>();
    private final IContentsStringConverter<Date> dateConverter;

    static {
        PATTERN_2_DATEFORMAT_MAP.put(DATE_ONLY_DASH, DateStringConverter.getDateFormat(5));
        PATTERN_2_DATEFORMAT_MAP.put(DATE_ONLY_SLASH, DateStringConverter.getDateFormat(4));
        PATTERN_2_DATEFORMAT_MAP.put(DATE_TIME_HHMM_DASH, DateStringConverter.getDateFormat(3));
        PATTERN_2_DATEFORMAT_MAP.put(DATE_TIME_HHMM_SLASH, DateStringConverter.getDateFormat(2));
        PATTERN_2_DATEFORMAT_MAP.put(DATE_TIME_HHMMSS_DASH, DateStringConverter.getDateFormat(1));
        PATTERN_2_DATEFORMAT_MAP.put(DATE_TIME_HHMMSS_SLASH, DateStringConverter.getDateFormat(0));
        PATTERN_2_DATEFORMAT_MAP.put(TIME_ONLY_HHMMSS, DateStringConverter.getDateFormat(6));
        PATTERN_2_DATEFORMAT_MAP.put(TIME_ONLY_HHMM, DateStringConverter.getDateFormat(7));
    }

    public DateFieldValidator(String maskPattern, IContentsStringConverter<Date> dateConverter) {
        super(maskPattern);
        this.dateConverter = dateConverter;
        if (PATTERN_2_DATEFORMAT_MAP.containsKey(maskPattern) && dateConverter instanceof DateStringConverter) {
            ((DateStringConverter)dateConverter).setDefaultDateFormat(PATTERN_2_DATEFORMAT_MAP.get(maskPattern));
        }
    }

    @Override
    public boolean isContentsValid(Date contents) {
        return contents != null;
    }

    @Override
    public String getErrorMessage() {
        return MessageFormat.format(Messages.getString("DateFieldValidator.message.error"), this.getMaskPattern());
    }

    @Override
    public String getWarningMessage() {
        return null;
    }

    @Override
    public boolean warningExist(Date contents) {
        return false;
    }

    @Override
    protected void clearText(int startPos, int length) {
        int i = startPos;
        while (i < startPos + length && i < this.inputValue.length()) {
            char c = this.maskPattern.charAt(i);
            if (DateFieldValidator.isPatternChar(c)) {
                this.inputValue.setCharAt(i, '0');
            }
            ++i;
        }
    }

    @Override
    protected boolean mustIncreasePositionOnError() {
        return true;
    }

    @Override
    protected int insertText(String textValue, int start) {
        int caretPos = super.insertText(textValue, start);
        Date date = null;
        date = this.dateConverter.convertFromString(this.inputValue.toString());
        if (date == null) {
            throw new IllegalArgumentException("Not a valid date");
        }
        this.inputValue = new StringBuffer(this.dateConverter.convertToString(date));
        this.updateText(this.inputValue.toString().trim(), 0);
        return caretPos;
    }
}

