/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerAddress {
    final String _host;
    final int _port;
    final InetSocketAddress _addr;
    final InetAddress[] _all;

    public ServerAddress() throws UnknownHostException {
        this(ServerAddress.defaultHost(), ServerAddress.defaultPort());
    }

    public ServerAddress(String host) throws UnknownHostException {
        this(host, ServerAddress.defaultPort());
    }

    public ServerAddress(String host, int port) throws UnknownHostException {
        int idx;
        if (host == null) {
            host = ServerAddress.defaultHost();
        }
        if ((host = host.trim()).length() == 0) {
            host = ServerAddress.defaultHost();
        }
        if ((idx = host.indexOf(":")) > 0) {
            if (port != ServerAddress.defaultPort()) {
                throw new IllegalArgumentException("can't specify port in construct and via host");
            }
            port = Integer.parseInt(host.substring(idx + 1));
            host = host.substring(0, idx).trim();
        }
        this._host = host;
        this._port = port;
        this._all = ServerAddress._getAddress(this._host);
        this._addr = new InetSocketAddress(this._all[0], this._port);
    }

    public ServerAddress(InetAddress addr) {
        this(new InetSocketAddress(addr, ServerAddress.defaultPort()));
    }

    public ServerAddress(InetAddress addr, int port) {
        this(new InetSocketAddress(addr, port));
    }

    public ServerAddress(InetSocketAddress addr) {
        this._addr = addr;
        this._host = this._addr.getHostName();
        this._port = this._addr.getPort();
        this._all = null;
    }

    boolean isPaired() {
        return this._all != null && this._all.length > 1;
    }

    List<ServerAddress> explode() {
        if (this._all == null || this._all.length <= 1) {
            throw new RuntimeException("not replica set mode.  num addresses : " + this._all.length);
        }
        ArrayList<ServerAddress> s = new ArrayList<ServerAddress>();
        for (int i = 0; i < this._all.length; ++i) {
            s.add(new ServerAddress(this._all[i], this._port));
        }
        return s;
    }

    public boolean sameHost(String host) {
        int idx = host.indexOf(":");
        int port = ServerAddress.defaultPort();
        if (idx > 0) {
            port = Integer.parseInt(host.substring(idx + 1));
            host = host.substring(0, idx);
        }
        return this._port == port && this._host.equalsIgnoreCase(host);
    }

    public boolean equals(Object other) {
        if (other instanceof ServerAddress) {
            ServerAddress a = (ServerAddress)other;
            return a._port == this._port && a._host.equals(this._host);
        }
        return false;
    }

    public int hashCode() {
        return this._host.hashCode() + this._port;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public InetSocketAddress getSocketAddress() {
        return this._addr;
    }

    public String toString() {
        return this._host + ":" + this._port;
    }

    private static InetAddress[] _getAddress(String host) throws UnknownHostException {
        if (host.toLowerCase().equals("localhost")) {
            return new InetAddress[]{InetAddress.getLocalHost()};
        }
        return InetAddress.getAllByName(host);
    }

    public static String defaultHost() {
        return "127.0.0.1";
    }

    public static int defaultPort() {
        return 27017;
    }
}

