/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapExecutor;
import com.ibatis.sqlmap.client.event.RowHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.JdbcUpdateAffectedIncorrectNumberOfRowsException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.JdbcAccessor;
import org.springframework.orm.ibatis.SqlMapClientCallback;
import org.springframework.orm.ibatis.SqlMapClientOperations;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class SqlMapClientTemplate
extends JdbcAccessor
implements SqlMapClientOperations {
    private SqlMapClient sqlMapClient;

    public SqlMapClientTemplate() {
    }

    public SqlMapClientTemplate(SqlMapClient sqlMapClient) {
        this.setSqlMapClient(sqlMapClient);
        this.afterPropertiesSet();
    }

    public SqlMapClientTemplate(DataSource dataSource, SqlMapClient sqlMapClient) {
        this.setDataSource(dataSource);
        this.setSqlMapClient(sqlMapClient);
        this.afterPropertiesSet();
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        this.sqlMapClient = sqlMapClient;
    }

    public SqlMapClient getSqlMapClient() {
        return this.sqlMapClient;
    }

    public DataSource getDataSource() {
        DataSource ds = super.getDataSource();
        return ds != null ? ds : this.sqlMapClient.getDataSource();
    }

    public void afterPropertiesSet() {
        if (this.sqlMapClient == null) {
            throw new IllegalArgumentException("Property 'sqlMapClient' is required");
        }
        super.afterPropertiesSet();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execute(SqlMapClientCallback<T> action) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        Assert.notNull((Object)this.sqlMapClient, (String)"No SqlMapClient specified");
        session = this.sqlMapClient.openSession();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Opened SqlMapSession [" + session + "] for iBATIS operation"));
        }
        ibatisCon = null;
        try {
            block21: {
                block20: {
                    springCon = null;
                    dataSource = this.getDataSource();
                    transactionAware = dataSource instanceof TransactionAwareDataSourceProxy;
                    try {
                        ibatisCon = session.getCurrentConnection();
                        if (ibatisCon == null) {
                            springCon = transactionAware != false ? dataSource.getConnection() : DataSourceUtils.doGetConnection((DataSource)dataSource);
                            session.setUserConnection(springCon);
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Obtained JDBC Connection [" + springCon + "] for iBATIS operation"));
                            }
                            break block20;
                        }
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Reusing JDBC Connection [" + ibatisCon + "] for iBATIS operation"));
                        }
                    }
                    catch (SQLException ex) {
                        throw new CannotGetJdbcConnectionException("Could not get JDBC Connection", ex);
                    }
                }
                try {
                    ex = action.doInSqlMapClient((SqlMapExecutor)session);
                    var9_10 = null;
                }
                catch (SQLException ex) {
                    try {
                        throw this.getExceptionTranslator().translate("SqlMapClient operation", null, ex);
                    }
                    catch (Throwable var8_16) {
                        var9_11 = null;
                        try {
                            if (springCon == null) throw var8_16;
                            if (transactionAware) {
                                springCon.close();
                                throw var8_16;
                            }
                            DataSourceUtils.doReleaseConnection((Connection)springCon, (DataSource)dataSource);
                            throw var8_16;
                        }
                        catch (Throwable ex) {
                            this.logger.debug((Object)"Could not close JDBC Connection", ex);
                        }
                        throw var8_16;
                    }
                }
                ** try [egrp 4[TRYBLOCK] [4 : 285->315)] { 
lbl47:
                // 1 sources

                if (springCon != null) {
                    if (transactionAware) {
                        springCon.close();
                        break block21;
                    } else {
                        DataSourceUtils.doReleaseConnection((Connection)springCon, (DataSource)dataSource);
                    }
                }
                break block21;
lbl54:
                // 1 sources

                catch (Throwable ex) {
                    this.logger.debug((Object)"Could not close JDBC Connection", ex);
                }
            }
            var12_14 = null;
            if (ibatisCon != null) return ex;
        }
        catch (Throwable var11_17) {
            var12_15 = null;
            if (ibatisCon != null) throw var11_17;
            session.close();
            throw var11_17;
        }
        session.close();
        return ex;
    }

    @Deprecated
    public List executeWithListResult(SqlMapClientCallback<List> action) throws DataAccessException {
        return this.execute(action);
    }

    @Deprecated
    public Map executeWithMapResult(SqlMapClientCallback<Map> action) throws DataAccessException {
        return this.execute(action);
    }

    @Override
    public Object queryForObject(String statementName) throws DataAccessException {
        return this.queryForObject(statementName, null);
    }

    @Override
    public Object queryForObject(final String statementName, final Object parameterObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Object>(){

            @Override
            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForObject(statementName, parameterObject);
            }
        });
    }

    @Override
    public Object queryForObject(final String statementName, final Object parameterObject, final Object resultObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Object>(){

            @Override
            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForObject(statementName, parameterObject, resultObject);
            }
        });
    }

    @Override
    public List queryForList(String statementName) throws DataAccessException {
        return this.queryForList(statementName, null);
    }

    @Override
    public List queryForList(final String statementName, final Object parameterObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<List>(){

            @Override
            public List doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForList(statementName, parameterObject);
            }
        });
    }

    @Override
    public List queryForList(String statementName, int skipResults, int maxResults) throws DataAccessException {
        return this.queryForList(statementName, null, skipResults, maxResults);
    }

    @Override
    public List queryForList(final String statementName, final Object parameterObject, final int skipResults, final int maxResults) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<List>(){

            @Override
            public List doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForList(statementName, parameterObject, skipResults, maxResults);
            }
        });
    }

    @Override
    public void queryWithRowHandler(String statementName, RowHandler rowHandler) throws DataAccessException {
        this.queryWithRowHandler(statementName, null, rowHandler);
    }

    @Override
    public void queryWithRowHandler(final String statementName, final Object parameterObject, final RowHandler rowHandler) throws DataAccessException {
        this.execute(new SqlMapClientCallback<Object>(){

            @Override
            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                executor.queryWithRowHandler(statementName, parameterObject, rowHandler);
                return null;
            }
        });
    }

    @Override
    public Map queryForMap(final String statementName, final Object parameterObject, final String keyProperty) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Map>(){

            @Override
            public Map doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForMap(statementName, parameterObject, keyProperty);
            }
        });
    }

    @Override
    public Map queryForMap(final String statementName, final Object parameterObject, final String keyProperty, final String valueProperty) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Map>(){

            @Override
            public Map doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForMap(statementName, parameterObject, keyProperty, valueProperty);
            }
        });
    }

    @Override
    public Object insert(String statementName) throws DataAccessException {
        return this.insert(statementName, null);
    }

    @Override
    public Object insert(final String statementName, final Object parameterObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Object>(){

            @Override
            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.insert(statementName, parameterObject);
            }
        });
    }

    @Override
    public int update(String statementName) throws DataAccessException {
        return this.update(statementName, null);
    }

    @Override
    public int update(final String statementName, final Object parameterObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Integer>(){

            @Override
            public Integer doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.update(statementName, parameterObject);
            }
        });
    }

    @Override
    public void update(String statementName, Object parameterObject, int requiredRowsAffected) throws DataAccessException {
        int actualRowsAffected = this.update(statementName, parameterObject);
        if (actualRowsAffected != requiredRowsAffected) {
            throw new JdbcUpdateAffectedIncorrectNumberOfRowsException(statementName, requiredRowsAffected, actualRowsAffected);
        }
    }

    @Override
    public int delete(String statementName) throws DataAccessException {
        return this.delete(statementName, null);
    }

    @Override
    public int delete(final String statementName, final Object parameterObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Integer>(){

            @Override
            public Integer doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.delete(statementName, parameterObject);
            }
        });
    }

    @Override
    public void delete(String statementName, Object parameterObject, int requiredRowsAffected) throws DataAccessException {
        int actualRowsAffected = this.delete(statementName, parameterObject);
        if (actualRowsAffected != requiredRowsAffected) {
            throw new JdbcUpdateAffectedIncorrectNumberOfRowsException(statementName, requiredRowsAffected, actualRowsAffected);
        }
    }
}

