/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentEntityParameterValueProvider<P extends PersistentProperty<P>>
implements ParameterValueProvider<P> {
    private final PersistentEntity<?, P> entity;
    private final PropertyValueProvider<P> provider;
    private final Object parent;
    private SpELExpressionEvaluator spELEvaluator;

    public PersistentEntityParameterValueProvider(PersistentEntity<?, P> entity, PropertyValueProvider<P> provider, Object parent) {
        Assert.notNull(entity);
        Assert.notNull(provider);
        this.entity = entity;
        this.provider = provider;
        this.parent = parent;
    }

    public void setSpELEvaluator(SpELExpressionEvaluator spELEvaluator) {
        this.spELEvaluator = spELEvaluator;
    }

    @Override
    public <T> T getParameterValue(PreferredConstructor.Parameter<T, P> parameter) {
        if (this.spELEvaluator != null && parameter.hasSpelExpression()) {
            return this.spELEvaluator.evaluate(parameter.getSpelExpression());
        }
        PreferredConstructor<T, P> constructor = this.entity.getPersistenceConstructor();
        if (constructor.isEnclosingClassParameter(parameter)) {
            return (T)this.parent;
        }
        P property = this.entity.getPersistentProperty(parameter.getName());
        if (property == null) {
            throw new MappingException(String.format("No property %s found on entity %s to bind constructor parameter to!", parameter.getName(), this.entity.getType()));
        }
        return this.provider.getPropertyValue(property);
    }
}

