/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.examples;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.nebula.visualization.widgets.datadefinition.IManualValueChangeListener;
import org.eclipse.nebula.visualization.widgets.figures.GaugeFigure;
import org.eclipse.nebula.visualization.widgets.figures.KnobFigure;
import org.eclipse.nebula.visualization.widgets.figures.TankFigure;
import org.eclipse.nebula.visualization.widgets.figures.ThermometerFigure;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MultipleWidgetsExample {
    public static void main(String[] args) {
        Shell shell = new Shell();
        shell.setText("Multiple Widgets Example");
        shell.setSize(400, 400);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gd = new GridData(4, 4, true, true);
        shell.setLayout((Layout)layout);
        Canvas knobCanvas = new Canvas((Composite)shell, 0);
        knobCanvas.setLayoutData((Object)gd);
        Canvas gaugeCanvas = new Canvas((Composite)shell, 0);
        gaugeCanvas.setLayoutData((Object)gd);
        Canvas thermoCanvas = new Canvas((Composite)shell, 0);
        thermoCanvas.setLayoutData((Object)gd);
        Canvas tankCanvas = new Canvas((Composite)shell, 0);
        tankCanvas.setLayoutData((Object)gd);
        LightweightSystem lws = new LightweightSystem(knobCanvas);
        KnobFigure knobFigure = new KnobFigure();
        lws.setContents((IFigure)knobFigure);
        lws = new LightweightSystem(gaugeCanvas);
        final GaugeFigure gauge = new GaugeFigure();
        gauge.setBackgroundColor(XYGraphMediaFactory.getInstance().getColor(0, 0, 0));
        gauge.setForegroundColor(XYGraphMediaFactory.getInstance().getColor(255, 255, 255));
        lws.setContents((IFigure)gauge);
        lws = new LightweightSystem(thermoCanvas);
        final ThermometerFigure thermo = new ThermometerFigure();
        lws.setContents((IFigure)thermo);
        lws = new LightweightSystem(tankCanvas);
        final TankFigure tank = new TankFigure();
        lws.setContents((IFigure)tank);
        knobFigure.addManualValueChangeListener(new IManualValueChangeListener(){

            @Override
            public void manualValueChanged(double newValue) {
                gauge.setValue(newValue);
                thermo.setValue(newValue);
                tank.setValue(newValue);
            }
        });
        shell.open();
        Display display = Display.getDefault();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

