/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.directory.action.touch;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.editors.directory.action.touch.ColorUtils;
import ru.ssa.cashadmin.domain.Actionpanel;
import ru.ssa.cashadmin.domain.Actionpanelitem;

class DisplayItemContainer {
    private static final Logger log = LoggerFactory.getLogger(DisplayItem.class);
    private static final int MAX_COLUMN = 20;
    private static final int MAX_ROW = 20;
    private static final int BORDER_WIDTH = 5;
    private DisplayItem[][] matrix;
    private Actionpanel actionpanel;

    public DisplayItemContainer(Actionpanel actionpanel, List<Actionpanelitem> items) {
        this.actionpanel = actionpanel;
        this.matrix = new DisplayItem[21][21];
        for (Actionpanelitem item : items) {
            int rowI;
            int columnI = item.getColumn();
            if (this.matrix[columnI][rowI = item.getRow().intValue()] != null) continue;
            DisplayItem di = new DisplayItem(actionpanel);
            di.item = item;
            this.matrix[columnI][rowI] = di;
        }
        int j = 0;
        while (j < 20) {
            int i = 0;
            while (i < 20) {
                if (this.matrix[i + 1][j + 1] == null) {
                    this.matrix[i + 1][j + 1] = new DisplayItem(actionpanel);
                    this.matrix[i + 1][j + 1].item = this.getNewActionpanelitem(actionpanel);
                    this.matrix[i + 1][j + 1].item.setRow(Integer.valueOf(j + 1));
                    this.matrix[i + 1][j + 1].item.setColumn(Integer.valueOf(i + 1));
                    this.matrix[i + 1][j + 1].item.setRowspan(Integer.valueOf(1));
                    this.matrix[i + 1][j + 1].item.setColumnspan(Integer.valueOf(1));
                    this.matrix[i + 1][j + 1].stub = true;
                }
                ++i;
            }
            ++j;
        }
    }

    protected Actionpanelitem getNewActionpanelitem(Actionpanel parent) {
        Actionpanelitem actionpanelitem = new Actionpanelitem();
        if (parent != null) {
            actionpanelitem.setActionpanelcode(parent.getActionpanelcode());
        }
        return actionpanelitem;
    }

    public DisplayItem find(int x, int y) {
        int j = 0;
        while (j < 20) {
            int i = 0;
            while (i < 20) {
                if (this.matrix[i + 1][j + 1] != null && this.matrix[i + 1][j + 1].rectangle != null) {
                    log.trace("check={} x={} y={} col={} row={}", new Object[]{this.matrix[i + 1][j + 1].rectangle, x, y, i + 1, j + 1});
                    if (this.matrix[i + 1][j + 1].rectangle.contains(x, y)) {
                        log.trace("finded");
                        return this.matrix[i + 1][j + 1];
                    }
                }
                ++i;
            }
            ++j;
        }
        return null;
    }

    private DisplayItem findbWithSpan(int x, int y, boolean includeStub) {
        int j = 0;
        while (j < 20) {
            int i = 0;
            while (i < 20) {
                DisplayItem item = this.matrix[i + 1][j + 1];
                if (item != null && item.rectangle != null && (!item.stub || includeStub)) {
                    Rectangle check = new Rectangle(((DisplayItem)item).rectangle.x, ((DisplayItem)item).rectangle.y, ((DisplayItem)item).rectangle.width * (Integer)ObjectUtils.defaultIfNull((Object)item.item.getColumnspan(), (Object)1), ((DisplayItem)item).rectangle.height * (Integer)ObjectUtils.defaultIfNull((Object)item.item.getRowspan(), (Object)1));
                    log.trace("check={} x={} y={} col={} row={}", new Object[]{check, x, y, i + 1, j + 1});
                    if (check.contains(x, y)) {
                        log.trace("finded");
                        return item;
                    }
                }
                ++i;
            }
            ++j;
        }
        return null;
    }

    public DisplayItem findNotStubWithSpan(int x, int y) {
        return this.findbWithSpan(x, y, false);
    }

    public void set(DisplayItem item) {
        this.matrix[((DisplayItem)item).item.getColumn().intValue()][((DisplayItem)item).item.getRow().intValue()] = item;
    }

    public void set(int col, int row, DisplayItem item) {
        this.matrix[col][row] = item;
    }

    public DisplayItem get(int i, int j) {
        return this.matrix[i][j];
    }

    public List<Actionpanelitem> getNormal() {
        ArrayList<Actionpanelitem> list = new ArrayList<Actionpanelitem>();
        int j = 0;
        while (j < 20) {
            int i = 0;
            while (i < 20) {
                if (!this.matrix[i + 1][j + 1].stub) {
                    list.add(this.matrix[i + 1][j + 1].item);
                }
                ++i;
            }
            ++j;
        }
        return list;
    }

    public boolean intersects(DisplayItem input, Rectangle current, boolean additionalLogic) {
        if (current != null && !input.stub) {
            int j = 0;
            while (j < 20) {
                int i = 0;
                while (i < 20) {
                    Rectangle check;
                    DisplayItem item = this.matrix[i + 1][j + 1];
                    if (item != null && !item.stub && item.rectangle != null && !item.stub && !input.stub && (check = new Rectangle(((DisplayItem)item).rectangle.x + 1, ((DisplayItem)item).rectangle.y + 1, (((DisplayItem)item).rectangle.width - 2) * (Integer)ObjectUtils.defaultIfNull((Object)item.item.getColumnspan(), (Object)1) - 2, (((DisplayItem)item).rectangle.height - 2) * (Integer)ObjectUtils.defaultIfNull((Object)item.item.getRowspan(), (Object)1) - 2)).intersects(current) && (additionalLogic ? !item.equals(input) : item.equals(input))) {
                        return true;
                    }
                    ++i;
                }
                ++j;
            }
        }
        return false;
    }

    public DisplayItem findWithSpan(int x, int y) {
        return this.findbWithSpan(x, y, true);
    }

    public void fillRect(Rectangle bounds, int column, int row) {
        int width = bounds.width / column;
        int height = bounds.height / row;
        int j = 0;
        while (j < row) {
            int i = 0;
            while (i < column) {
                Rectangle elRec = new Rectangle(i * width, j * height, width, height);
                this.get(i + 1, j + 1).rectangle = elRec;
                ++i;
            }
            ++j;
        }
    }

    public void fillStubElement(DisplayItem item) {
        DisplayItem stub = new DisplayItem(this.actionpanel);
        stub.rectangle = item.rectangle;
        stub.stub = true;
        stub.item = this.getNewActionpanelitem(this.actionpanel);
        stub.item.setRow(item.item.getRow());
        stub.item.setColumn(item.item.getColumn());
        stub.item.setActionpanelitemcode(item.item.getActionpanelitemcode());
        this.set(stub);
    }

    public void move(DisplayItem oldLocation, DisplayItem newLocation) {
        int col = newLocation.item.getColumn();
        int row = newLocation.item.getRow();
        this.fillStubElement(oldLocation);
        oldLocation.rectangle = newLocation.rectangle;
        oldLocation.item.setColumn(newLocation.item.getColumn());
        oldLocation.item.setRow(newLocation.item.getRow());
        this.set(col, row, oldLocation);
    }

    static class DisplayItem {
        private Actionpanelitem item;
        private Actionpanel actionpanel;
        private Rectangle rectangle;
        private boolean stub = false;

        private DisplayItem(Actionpanel actionpanel) {
            this.actionpanel = actionpanel;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DisplayItem [stub=");
            builder.append(this.stub);
            builder.append(", rectangle=");
            builder.append(this.rectangle);
            builder.append(", item=");
            builder.append(this.item);
            builder.append("]");
            return builder.toString();
        }

        public String getItemName() {
            String name = this.item.getName();
            if (StringUtils.isBlank((String)name) && this.item.getAction() != null) {
                name = this.item.getAction().getCmactionname();
            }
            return StringUtils.defaultString((String)name);
        }

        public Color getBackground() {
            return ColorUtils.fromOur(this.item.getColor());
        }

        public Color getForeground() {
            return ColorUtils.textColor(this.item.getColor());
        }

        public Actionpanelitem getData() {
            return this.item;
        }

        public void setData(Actionpanelitem item) {
            this.item = item;
        }

        public Rectangle getRectangle() {
            return this.rectangle;
        }

        public Rectangle getRectangleForButton() {
            return new Rectangle(this.rectangle.x + 5, this.rectangle.y + 5, this.rectangle.width * (Integer)ObjectUtils.defaultIfNull((Object)this.item.getColumnspan(), (Object)1) - 10, this.rectangle.height * (Integer)ObjectUtils.defaultIfNull((Object)this.item.getRowspan(), (Object)1) - 10);
        }

        public boolean isStub() {
            return this.stub;
        }

        public void setStub(boolean stub) {
            this.stub = stub;
        }

        public void recalculateSpan(int width, int height) {
            int colspan = this.getSpan(width, this.rectangle.width, this.actionpanel.getColumncount() - this.item.getColumn() + 1);
            int rowspan = this.getSpan(height, this.rectangle.height, this.actionpanel.getRowcount() - this.item.getRow() + 1);
            this.item.setColumnspan(Integer.valueOf(colspan));
            this.item.setRowspan(Integer.valueOf(rowspan));
        }

        private int getSpan(int all, int part, int max) {
            int span = all / part;
            if (all % part > part / 2) {
                ++span;
            }
            span = Math.min(Math.max(span, 1), max);
            log.trace("calculated span={}", (Object)span);
            return span;
        }
    }
}

