/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.directory.goods;

import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.editors.directory.goods.MultiSelectCheckBoxTableViewer;
import ru.ssa.artixadmin.view.directory.goods.InventViewPanel;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.Catalog;
import ru.ssa.cashadmin.domain.Invent;
import ru.ssa.cashadmin.domain.InventCatalog;
import ru.ssa.cashadmin.utils.ArtixFilter;
import su.artix.cashserver.security.SecurityKey;
import su.artix.widgets.FilterElement;
import su.artix.yuki.binding.BindingKey;
import su.artix.yuki.binding.BindingType;
import su.artix.yuki.editors.EditorComposite;
import su.artix.yuki.view.DirectoryTableViewPanel;

@SecurityKey(title="\u041a\u0430\u0442\u0430\u043b\u043e\u0433\u0438")
public class CatalogEditPanel
extends EditorComposite<Catalog> {
    private static final Logger log = LoggerFactory.getLogger(CatalogEditPanel.class);
    @SecurityKey(title="\u041a\u043e\u0434", id="catalogid")
    private Label codeLabel;
    @SecurityKey(id="catalogid")
    @BindingKey(autoChanged=true, bindingType=BindingType.STRING)
    private Spinner codeField;
    @SecurityKey(title="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", id="catalogname")
    private Label nameLabel;
    @SecurityKey(id="catalogname")
    private Text nameField;
    @SecurityKey(title="\u041f\u0430\u043d\u0435\u043b\u044c \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u0430")
    private Composite composite;
    @SecurityKey(title="\u041f\u0430\u043d\u0435\u043b\u044c \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u0430 \u043e\u0441\u043d\u043e\u0432\u043d\u0430\u044f")
    private Composite mainEditPanelComposite;
    @SecurityKey(title="\u041f\u0430\u043d\u0435\u043b\u044c \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u0430 \u0432\u044b\u0431\u043e\u0440")
    private Composite selectInventComposite;
    private static final String INVENT_NOT_FOUND_IN_DB_MESSAGE = "<\u0422\u043e\u0432\u0430\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0411\u0414>";
    private MultiSelectCheckBoxTableViewer<InventCatalog, Catalog, Invent> multiSelectCheckBoxTableViewer;

    public CatalogEditPanel(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public CatalogEditPanel(Composite parent, int style, Catalog model) {
        super(parent, style, Catalog.class, (Object)model);
    }

    public void initialize() {
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)this);
        this.setLayout((Layout)new FillLayout(256));
        this.composite = new Composite((Composite)this, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.mainEditPanelComposite = new Composite(this.composite, 0);
        this.mainEditPanelComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mainEditPanelComposite.setBounds(0, 0, 64, 64);
        this.mainEditPanelComposite.setLayout((Layout)new GridLayout(2, false));
        this.codeLabel = new Label(this.mainEditPanelComposite, 0);
        this.codeLabel.setText("\u041a\u043e\u0434:");
        this.codeField = new Spinner(this.mainEditPanelComposite, 2048);
        this.codeField.setMaximum(Integer.MAX_VALUE);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.codeField);
        this.nameLabel = new Label(this.mainEditPanelComposite, 0);
        this.nameLabel.setText("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:");
        this.nameField = new Text(this.mainEditPanelComposite, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.nameField);
        this.selectInventComposite = new Composite(this.composite, 4);
        this.selectInventComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.selectInventComposite.setLayout((Layout)new GridLayout(1, false));
        this.createInventCatalogListComposite(this.selectInventComposite);
    }

    private void createInventCatalogListComposite(Composite parent) {
        this.multiSelectCheckBoxTableViewer = new MultiSelectCheckBoxTableViewer<InventCatalog, Catalog, Invent>(4, this.getParentDialog().getDialogMode(), (Catalog)this.getModel(), InventCatalog.class, Invent.class){

            @Override
            public Catalog getPrimaryFromJoiting(InventCatalog joiting) {
                return joiting.getCatalog();
            }

            @Override
            public Invent getSecondaryFromJoiting(InventCatalog joiting) {
                return joiting.getTmc();
            }

            @Override
            public InventCatalog setPrimary(InventCatalog joiting, Catalog primary) {
                joiting.setCatalog(primary);
                return joiting;
            }

            @Override
            public InventCatalog setSecondary(InventCatalog joiting, Invent secondary) {
                joiting.setTmc(secondary);
                return joiting;
            }

            @Override
            public String getTextForSelectedCheckBox() {
                return "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0432\u0445\u043e\u0434\u044f\u0449\u0438\u0435 \u0432 \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043a\u0430\u0442\u0430\u043b\u043e\u0433 \u0442\u043e\u0432\u0430\u0440\u044b";
            }

            @Override
            public String getTextForTopLabel() {
                return "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u043e\u0432\u0430\u0440\u044b, \u0432\u0445\u043e\u0434\u044f\u0449\u0438\u0435 \u0432 \u0434\u0430\u043d\u043d\u044b\u0439 \u043a\u0430\u0442\u0430\u043b\u043e\u0433:";
            }

            @Override
            public String getSortProperty() {
                return "bcode";
            }

            @Override
            public Invent createEmptySecondary(InventCatalog joiting) {
                Invent invent = (Invent)LibActivator.getDefault().getActualClassResolver().getInstance(Invent.class);
                invent.setCode(joiting.getTmccode());
                invent.setName(CatalogEditPanel.INVENT_NOT_FOUND_IN_DB_MESSAGE);
                return invent;
            }

            @Override
            public boolean checkSecondaryOnEmpty(Invent secondary) {
                return secondary != null && CatalogEditPanel.INVENT_NOT_FOUND_IN_DB_MESSAGE.equals(secondary.getName());
            }

            @Override
            public DirectoryTableViewPanel<Invent> getSecondaryPanel(Composite composite) {
                return new InventViewPanel(CatalogEditPanel.this.selectInventComposite, 2048, true){

                    protected int getSelectionStyle() {
                        return super.getSelectionStyle() | 0x20;
                    }

                    protected void createFilterMenu(Menu parent, Class<Invent> clazz, TableViewer viewer) {
                        this.setFilter(new ArtixFilter(clazz));
                    }

                    @Override
                    protected FilterElement getFilterElement() {
                        FilterElement secondaryFilterElement = super.getFilterElement();
                        this.setFilterElement(secondaryFilterElement);
                        return secondaryFilterElement;
                    }
                };
            }
        };
        try {
            this.multiSelectCheckBoxTableViewer.createDeptValutListComposite(parent);
        }
        catch (Exception e) {
            log.error("cannot create table viewer composite: {}", (Throwable)e);
        }
        parent.layout(true, true);
    }

    public void bindValues() {
        this.initDefaulBinding();
    }

    public void switchID() {
        if (this.autoChangedValue != null) {
            try {
                this.autoChangedValue.setValue((Object)Integer.valueOf((String)this.getDirectoryModel().getNextId()));
            }
            catch (NumberFormatException numberFormatException) {
                this.autoChangedValue.setValue((Object)0);
            }
        }
    }

    public Map<InventCatalog, String> getInventCatalogsMap() {
        return this.multiSelectCheckBoxTableViewer.getChangedMap((Catalog)this.getModel());
    }
}

