/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.webuser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.provider.security.AvailableSecurityRoleContentProvider;
import ru.ssa.artixadmin.view.security.SecurityRoleViewPanel;
import su.artix.cashserver.core.cashregistry.domain.Dept;
import su.artix.cashserver.core.cashregistry.domain.SecurityRole;
import su.artix.cashserver.core.cashregistry.domain.WebUser;
import su.artix.cashserver.security.SecurityKey;
import su.artix.yuki.binding.BindingKey;
import su.artix.yuki.binding.BindingType;
import su.artix.yuki.directory.DirectoryLabelProvider;
import su.artix.yuki.directory.DirectoryList;
import su.artix.yuki.editors.EditorComposite;
import su.artix.yuki.images.ArtixAdminImages;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.provider.PojoTableLabelProvider;
import su.artix.yuki.view.DirectoryTableViewPanel;

@SecurityKey(title="\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438")
public class WebUserEditPanel
extends EditorComposite<WebUser> {
    private static final Logger log = LoggerFactory.getLogger(WebUserEditPanel.class);
    private Button addButtonSecurityRole;
    private Button removeButtonSecurityRole;
    private Button addAllButtonSecurityRole;
    private Button removeAllButtonSecurityRole;
    private DirectoryTableViewPanel<SecurityRole> securityRoleUserViewPanel;
    private DirectoryTableViewPanel<SecurityRole> securityRoleViewPanel;
    private List<SecurityRole> securityRoles = new ArrayList<SecurityRole>();
    @SecurityKey(title="\u041b\u043e\u0433\u0438\u043d", id="name")
    private Label labelLogin;
    @SecurityKey(id="name")
    private Text login;
    @SecurityKey(title="\u041f\u0430\u0440\u043e\u043b\u044c", id="password")
    private Label labelPassword;
    @SecurityKey(id="password")
    private Text password;
    @SecurityKey(id="deptCode", title="\u041e\u0442\u0434\u0435\u043b")
    private Label reasonListLabel;
    @SecurityKey(id="deptCodeSelect")
    @BindingKey(bindingType=BindingType.DIRECTORY_LIST_STRING, id="deptCode")
    private ComboViewer reasonListField;
    private DirectoryList reasons;

    public WebUserEditPanel(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public WebUserEditPanel(Composite parent, int style, WebUser model) {
        super(parent, style, WebUser.class, (Object)model);
        WebUser withRoles = (WebUser)ModelActivator.getDefault().getModelProvider().getDirectoryModel(WebUser.class).getById((Object)model.getName());
        if (withRoles != null && withRoles.getSecurityRoles() != null) {
            ((WebUser)this.getModel()).setSecurityRoles(withRoles.getSecurityRoles());
            this.securityRoles.addAll(withRoles.getSecurityRoles());
        }
    }

    private void add(Object[] objects) {
        if (objects != null && objects.length > 0) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof SecurityRole) {
                    this.securityRoles.add((SecurityRole)obj);
                    ((WebUser)this.getModel()).setSecurityRoles(this.securityRoles);
                    ((TableViewer)this.securityRoleUserViewPanel.getViewer()).refresh();
                    ((TableViewer)this.securityRoleViewPanel.getViewer()).refresh();
                }
                ++n2;
            }
        }
    }

    private void remove(Object[] objects) {
        if (objects != null && objects.length > 0) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof SecurityRole) {
                    this.securityRoles.remove(obj);
                    ((WebUser)this.getModel()).setSecurityRoles(this.securityRoles);
                    ((TableViewer)this.securityRoleViewPanel.getViewer()).refresh();
                    ((TableViewer)this.securityRoleUserViewPanel.getViewer()).refresh();
                }
                ++n2;
            }
        }
    }

    public void initialize() {
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)this);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this);
        this.labelLogin = new Label((Composite)this, 0);
        this.labelLogin.setText("\u041b\u043e\u0433\u0438\u043d:");
        this.login = new Text((Composite)this, 2048);
        this.login.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.login.setTextLimit(200);
        this.labelPassword = new Label((Composite)this, 0);
        this.labelPassword.setText("\u041f\u0430\u0440\u043e\u043b\u044c:");
        this.password = new Text((Composite)this, 2048);
        this.password.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.password.setTextLimit(200);
        this.reasonListLabel = new Label((Composite)this, 0);
        this.reasonListLabel.setText("\u041e\u0442\u0434\u0435\u043b:");
        this.reasonListField = new ComboViewer((Composite)this, 0);
        this.reasonListField.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.reasonListField.setLabelProvider((IBaseLabelProvider)new DirectoryLabelProvider());
        this.reasons = new DirectoryList();
        try {
            List list = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Dept.class).getList();
            for (Dept reason : list) {
                this.reasons.add(reason.getCode(), reason.getName());
            }
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.reasonListField.setInput((Object)this.reasons);
        GridDataFactory.fillDefaults().applyTo((Control)this.reasonListField.getCombo());
        Composite securityRoleChooseComposite = new Composite((Composite)this, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(securityRoleChooseComposite);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)securityRoleChooseComposite);
        Group securityRoleGroup = new Group(securityRoleChooseComposite, 16);
        securityRoleGroup.setText("\u0421\u043f\u0438\u0441\u043e\u043a \u0440\u043e\u043b\u0435\u0439");
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo((Composite)securityRoleGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)securityRoleGroup);
        this.securityRoleViewPanel = new SecurityRoleViewPanel((Composite)securityRoleGroup, 0, true);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)((TableViewer)this.securityRoleViewPanel.getViewer()).getTable());
        ((TableViewer)this.securityRoleViewPanel.getViewer()).getTable().setHeaderVisible(false);
        ((TableViewer)this.securityRoleViewPanel.getViewer()).getTable().setLinesVisible(false);
        ((TableViewer)this.securityRoleViewPanel.getViewer()).setContentProvider((IContentProvider)new AvailableSecurityRoleContentProvider());
        ((TableViewer)this.securityRoleViewPanel.getViewer()).setLabelProvider((IBaseLabelProvider)new PojoTableLabelProvider(this.securityRoleViewPanel.getColumns(), false));
        ((TableViewer)this.securityRoleViewPanel.getViewer()).setInput(this.securityRoles);
        Composite securityButtonComposite = new Composite(securityRoleChooseComposite, 0);
        GridLayoutFactory.swtDefaults().applyTo(securityButtonComposite);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)securityButtonComposite);
        GridDataFactory securityButtonGridData = GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false);
        this.addButtonSecurityRole = new Button(securityButtonComposite, 8);
        this.addButtonSecurityRole.setImage(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/navigate_right").createImage());
        this.addButtonSecurityRole.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StructuredSelection structuredSelection = (StructuredSelection)((TableViewer)WebUserEditPanel.this.securityRoleViewPanel.getViewer()).getSelection();
                if (!structuredSelection.isEmpty()) {
                    WebUserEditPanel.this.add(structuredSelection.toArray());
                }
            }
        });
        securityButtonGridData.applyTo((Control)this.addButtonSecurityRole);
        this.removeButtonSecurityRole = new Button(securityButtonComposite, 8);
        this.removeButtonSecurityRole.setImage(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/navigate_left").createImage());
        this.removeButtonSecurityRole.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StructuredSelection structuredSelection = (StructuredSelection)((TableViewer)WebUserEditPanel.this.securityRoleUserViewPanel.getViewer()).getSelection();
                if (!structuredSelection.isEmpty()) {
                    WebUserEditPanel.this.remove(structuredSelection.toArray());
                }
            }
        });
        securityButtonGridData.applyTo((Control)this.removeButtonSecurityRole);
        this.addAllButtonSecurityRole = new Button(securityButtonComposite, 8);
        this.addAllButtonSecurityRole.setImage(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/navigate_right2").createImage());
        this.addAllButtonSecurityRole.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object[] objects = ((IStructuredContentProvider)((TableViewer)WebUserEditPanel.this.securityRoleViewPanel.getViewer()).getContentProvider()).getElements((Object)WebUserEditPanel.this.securityRoles);
                WebUserEditPanel.this.add(objects);
            }
        });
        securityButtonGridData.applyTo((Control)this.addAllButtonSecurityRole);
        this.removeAllButtonSecurityRole = new Button(securityButtonComposite, 8);
        this.removeAllButtonSecurityRole.setImage(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/navigate_left2").createImage());
        this.removeAllButtonSecurityRole.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WebUserEditPanel.this.remove(WebUserEditPanel.this.securityRoles.toArray());
            }
        });
        securityButtonGridData.applyTo((Control)this.removeAllButtonSecurityRole);
        Group securityroleUserGroup = new Group(securityRoleChooseComposite, 16);
        securityroleUserGroup.setText("\u0420\u043e\u043b\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f");
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo((Composite)securityroleUserGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)securityroleUserGroup);
        this.securityRoleUserViewPanel = new SecurityRoleViewPanel((Composite)securityroleUserGroup, 0, true);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)((TableViewer)this.securityRoleUserViewPanel.getViewer()).getTable());
        ((TableViewer)this.securityRoleUserViewPanel.getViewer()).getTable().setHeaderVisible(false);
        ((TableViewer)this.securityRoleUserViewPanel.getViewer()).getTable().setLinesVisible(false);
        ((TableViewer)this.securityRoleUserViewPanel.getViewer()).setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        ((TableViewer)this.securityRoleUserViewPanel.getViewer()).setLabelProvider((IBaseLabelProvider)new PojoTableLabelProvider(this.securityRoleUserViewPanel.getColumns(), false));
        ((TableViewer)this.securityRoleUserViewPanel.getViewer()).setInput(this.securityRoles);
    }

    public void bindValues() {
        this.initDefaulBinding();
    }
}

