/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.presentation;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.preferences.IPropertyMap;
import org.eclipse.ui.internal.preferences.IPropertyMapListener;
import org.eclipse.ui.internal.presentations.util.AbstractTabFolder;
import org.eclipse.ui.internal.presentations.util.ISystemMenu;
import org.eclipse.ui.internal.presentations.util.PresentablePartFolder;
import org.eclipse.ui.internal.presentations.util.StandardViewSystemMenu;
import org.eclipse.ui.internal.presentations.util.TabbedStackPresentation;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackPresentation;
import org.eclipse.ui.presentations.WorkbenchPresentationFactory;
import su.artix.yuki.presentation.CustomTabFolder;
import su.artix.yuki.presentation.DefaultSimpleTabListener;
import su.artix.yuki.presentation.DefaultThemeListener;

public class CustomPresentationFactory
extends WorkbenchPresentationFactory {
    private static int viewTabPosition = 128;

    public StackPresentation createViewPresentation(Composite parent, IStackPresentationSite site) {
        CustomTabFolder folder = new CustomTabFolder(parent, viewTabPosition | 0x800, site.supportsState(0), site.supportsState(1));
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        int minimumCharacters = store.getInt("VIEW_MINIMUM_CHARACTERS");
        if (minimumCharacters >= 0) {
            folder.setMinimumCharacters(minimumCharacters);
        }
        PresentablePartFolder partFolder = new PresentablePartFolder((AbstractTabFolder)folder);
        folder.setUnselectedCloseVisible(false);
        folder.setUnselectedImageVisible(true);
        TabbedStackPresentation result = new TabbedStackPresentation(site, partFolder, (ISystemMenu)new StandardViewSystemMenu(site));
        DefaultThemeListener themeListener = new DefaultThemeListener(folder, (IPropertyMap)result.getTheme());
        result.getTheme().addListener((IPropertyMapListener)themeListener);
        new DefaultSimpleTabListener(result.getApiPreferences(), "SHOW_TRADITIONAL_STYLE_TABS", folder);
        return result;
    }
}

