/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.action;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;
import su.artix.yuki.action.DirectoryRefreshAction;
import su.artix.yuki.action.DirectoryRemoveAction;
import su.artix.yuki.action.DirectorySelectAction;

public class DirectorySelectActionGroup<E>
extends ActionGroup {
    private final Class<E> e;
    private IAction selectAction;
    private IAction removeAction;
    private IAction refreshAction;
    private List<IAction> customActions = new ArrayList<IAction>();

    public DirectorySelectActionGroup(Class<E> cl) {
        this.e = cl;
        this.makeActions();
    }

    public DirectorySelectActionGroup(Class<E> cl, List<IAction> customActions) {
        this(cl);
        this.customActions = customActions;
    }

    private void makeActions() {
        this.selectAction = new DirectorySelectAction<E>(this.e);
        this.removeAction = new DirectoryRemoveAction<E>(this.e);
        this.refreshAction = new DirectoryRefreshAction<E>(this.e);
        this.refreshAction.setAccelerator(262226);
    }

    protected void fillToolBar(IToolBarManager toolBar) {
        if (!this.customActions.isEmpty()) {
            for (IAction action : this.customActions) {
                toolBar.add(action);
            }
            toolBar.add((IContributionItem)new Separator());
        }
        toolBar.add(this.refreshAction);
        toolBar.add(this.selectAction);
        toolBar.add(this.removeAction);
    }

    protected void fillViewMenu(IMenuManager menu) {
        if (!this.customActions.isEmpty()) {
            for (IAction action : this.customActions) {
                menu.add(action);
            }
            menu.add((IContributionItem)new Separator());
        }
        menu.add(this.refreshAction);
        menu.add(this.selectAction);
        menu.add(this.removeAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        this.fillToolBar(actionBars.getToolBarManager());
        this.fillViewMenu(actionBars.getMenuManager());
    }

    public IAction getSelectAction() {
        return this.selectAction;
    }

    public void setEnabledEditGroupActions(Boolean isEnabled) {
        this.selectAction.setEnabled(isEnabled.booleanValue());
        this.removeAction.setEnabled(isEnabled.booleanValue());
    }

    public void setRemoveActionEnabled(Boolean isAvailable) {
        this.removeAction.setEnabled(false);
    }

    public void dispose() {
        super.dispose();
        ((DirectoryRemoveAction)this.removeAction).dispose();
    }
}

