/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.view.state;

import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IMemento;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.yuki.view.state.PersistState;

public class PersistTreeWidthState
implements PersistState<Tree> {
    private static final Logger log = LoggerFactory.getLogger(PersistTreeWidthState.class);
    private IMemento memento;
    private String id;

    public PersistTreeWidthState(IMemento memento, String id) {
        this.memento = memento;
        this.id = id;
    }

    @Override
    public void saveState(IMemento memento, Tree composite) {
        log.trace("save state");
        IMemento stored = memento.getChild(String.valueOf(this.id) + "_width");
        memento = stored == null ? memento.createChild(String.valueOf(this.id) + "_width") : stored;
        int i = 0;
        while (i < composite.getColumnCount()) {
            int width = composite.getColumn(i).getWidth();
            log.trace("column={},width={}", (Object)i, (Object)width);
            memento.putInteger("column_" + i, width);
            ++i;
        }
    }

    @Override
    public void restoreState(Tree composite) {
        log.trace("restore state");
        if (this.memento != null) {
            this.memento = this.memento.getChild(String.valueOf(this.id) + "_width");
            if (this.memento != null) {
                Menu menu = composite.getMenu();
                int i = 0;
                while (i < composite.getColumnCount()) {
                    Integer width = this.memento.getInteger("column_" + i);
                    if (width != null) {
                        composite.getColumn(i).setWidth(width.intValue());
                        if (menu != null) {
                            menu.getItem(i).setSelection(width != 0);
                        }
                    }
                    log.trace("column={},width={}", (Object)i, (Object)width);
                    ++i;
                }
            }
        }
    }
}

