/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.model.directory;

import java.util.Collection;
import java.util.List;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.dao.DaoFactory;
import ru.ssa.cashadmin.dao.DaoInterface;
import ru.ssa.cashadmin.domain.Role;
import ru.ssa.cashadmin.domain.Rolecommand;
import ru.ssa.cashadmin.domain.Rolerelation;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.yuki.model.directory.DirectoryAction;
import su.artix.yuki.model.directory.DirectoryModel;
import su.artix.yuki.model.directory.DirectoryModelFactory;

public class DirectoryRoleModel
extends DirectoryModel<Role> {
    public DirectoryRoleModel() {
        super(Role.class);
    }

    @Override
    protected void doAfterChangeId(Object oldId, Role obj) throws ExecuteQueryException {
        Integer id = (Integer)oldId;
        this.updateRoleCommands(id, obj);
        this.updatePrimaryRoleRelations(id, obj);
        this.updateSecondRoleRelations(id, obj);
    }

    @Override
    public void delete(Role obj) throws ExecuteQueryException {
        super.delete(obj);
        this.removeRoleCommands(obj);
        this.removePrimaryRoleRelations(obj);
        this.removeSecondRoleRelations(obj);
    }

    @Override
    public void cascadeRefresh() {
        super.cascadeRefresh();
        DirectoryModelFactory.getModel(Rolerelation.class).firePropertyChange(DirectoryAction.CASCADE_REFRESH, null, null);
        DirectoryModelFactory.getModel(Rolecommand.class).firePropertyChange(DirectoryAction.CASCADE_REFRESH, null, null);
    }

    private void updateRoleCommands(Integer oldId, Role obj) throws ExecuteQueryException {
        Rolecommand state = (Rolecommand)LibActivator.getDefault().getActualClassResolver().getInstance(Rolecommand.class);
        state.setRolecode(oldId);
        DaoInterface dao = DaoFactory.getDAO(Rolecommand.class);
        List list = dao.getList((Object)state);
        for (Rolecommand command : list) {
            command.setRole(obj);
            dao.update((Object)command);
        }
    }

    private void updatePrimaryRoleRelations(Integer oldId, Role obj) throws ExecuteQueryException {
        Rolerelation state = (Rolerelation)LibActivator.getDefault().getActualClassResolver().getInstance(Rolerelation.class);
        state.setPrimary(oldId);
        DaoInterface dao = DaoFactory.getDAO(Rolerelation.class);
        List list = dao.getList((Object)state);
        for (Rolerelation relation : list) {
            relation.setPrimaryrole(obj);
            dao.update((Object)relation);
        }
    }

    private void updateSecondRoleRelations(Integer oldId, Role obj) throws ExecuteQueryException {
        Rolerelation state = (Rolerelation)LibActivator.getDefault().getActualClassResolver().getInstance(Rolerelation.class);
        state.setSecondory(oldId);
        DaoInterface dao = DaoFactory.getDAO(Rolerelation.class);
        List list = dao.getList((Object)state);
        for (Rolerelation relation : list) {
            relation.setSecondaryrole(obj);
            dao.update((Object)relation);
        }
    }

    private void removeRoleCommands(Role obj) throws ExecuteQueryException {
        Rolecommand state = (Rolecommand)LibActivator.getDefault().getActualClassResolver().getInstance(Rolecommand.class);
        state.setRolecode(obj.getRolecode());
        DaoInterface dao = DaoFactory.getDAO(Rolecommand.class);
        dao.deleteAll((Collection)dao.getList((Object)state));
    }

    private void removePrimaryRoleRelations(Role obj) throws ExecuteQueryException {
        Rolerelation state = (Rolerelation)LibActivator.getDefault().getActualClassResolver().getInstance(Rolerelation.class);
        state.setPrimary(obj.getRolecode());
        DaoInterface dao = DaoFactory.getDAO(Rolerelation.class);
        dao.deleteAll((Collection)dao.getList((Object)state));
    }

    private void removeSecondRoleRelations(Role obj) throws ExecuteQueryException {
        Rolerelation state = (Rolerelation)LibActivator.getDefault().getActualClassResolver().getInstance(Rolerelation.class);
        state.setSecondory(obj.getRolecode());
        DaoInterface dao = DaoFactory.getDAO(Rolerelation.class);
        dao.deleteAll((Collection)dao.getList((Object)state));
    }
}

